require 'hildon'
#require 'conic'
require 'dialogs'
require 'cgi'

class Scanner < Gtk::Table
	
	def initialize(label, rbox)
		@scanning = false
		@rbox = rbox
		super(15, 15)
		set_row_spacings(5)
		set_column_spacings(5)
		@scan_element = Gtk::TreeStore.new(TrueClass, String, Gtk::ListStore, Integer, TrueClass, String, String)
		@scan_list = Gtk::TreeView.new(@scan_element)
		@scan_list.headers_visible = true
		@scan_list.selection.mode = Gtk::SELECTION_SINGLE
		["Add", "Name", "Executable"].each_with_index do | field, i |
			renderer = nil
			col = nil
			if i == 1
				renderer = Gtk::CellRendererText.new
				col = Gtk::TreeViewColumn.new(field, renderer, :text => i)
				renderer.weight = Pango::FontDescription::WEIGHT_BOLD
			elsif i == 2
				renderer = Gtk::CellRendererCombo.new
				renderer.editable = true
				renderer.signal_connect("edited") do |renderer, path, text|
					iter = @scan_element.get_iter(path)
					iter[5] = text if File.exists?(File.join(iter[6], text))
				end
				col = Gtk::TreeViewColumn.new(field, renderer, :model => 2, :text_column => 3, :has_entry => 4, :text => 5)
			elsif i == 0
				renderer = Gtk::CellRendererToggle.new
				col = Gtk::TreeViewColumn.new(field, renderer, :active => i)
				renderer.activatable = true
				renderer.active = true
				renderer.signal_connect("toggled") do | widget , path |
					iter = @scan_element.get_iter(path)
					iter.set_value(0, !iter.get_value(0))
				end
			end
			@scan_list.append_column(col)
		end
		sw = Gtk::ScrolledWindow.new
		sw.add(@scan_list)
		attach_defaults(sw, 0,15,0,13)
		@import_button = Gtk::CheckButton.new("Try to import game settings")
		@import_button.active = @rbox.config["nick"] != nil
		attach_defaults(@import_button, 0,15,13,14)
		button_container = Gtk::HButtonBox.new
		button_container.layout_style = Gtk::ButtonBox::START
		@scan_button = Gtk::Button.new("Scan")
		@scan_button.signal_connect( "button_press_event" ) do | w, e |
			scan_apps
		end
		@cancel_button = Gtk::Button.new("Cancel")
		@cancel_button.signal_connect( "button_press_event" ) do | w, e |
			cancel_scan
		end
		@add_button = Gtk::Button.new("Add selected")
		@add_button.signal_connect( "button_press_event" ) do | w, e |
			add_selected
		end
		button_container.add(@scan_button)
		button_container.add(@cancel_button)
		button_container.add(@add_button)
		attach_defaults(button_container, 0,15,14,15)
		reset_settings
	end

	def scan_apps
		@scan_element.clear
		Thread.new do
			@scanning = true
			@scan_button.sensitive = false
			anim = Hildon::Banner.show_animation(@rbox, "rbox", "Scanning.")
			added_games = Array.new
			new_games = Hash.new
			Dir.entries(@rbox.prefsdir).push("").sort.each do | dir |
				row = nil
				if !dir.index(".") && File.directory?(File.join(@rbox.prefsdir, dir))
					Dir.entries(File.join(@rbox.prefsdir, dir)).sort.each do | file |
						filename = File.join(@rbox.prefsdir, dir, file)
						if File.extname(file) == ".conf"
							f = File.new(filename)
							data = f.readlines
							f.close
							added_games.push(File.dirname(data[2][1..data[2].length].strip))
						end
					end
				end
				break if !@scanning
			end
			if @scanning
				["/media/mmc1", "/media/mmc2"].each do | scanned |
					Find.find(scanned) do | file |
						if [".bat", ".exe", ".com"].include?(File.extname(file).downcase) && !added_games.include?(File.dirname(file)) && !File.basename(file, ".*").downcase.index("setup") && !File.basename(file, ".*").downcase.index("install") && File.basename(file, ".*")[0,1] != "."
							new_games[File.dirname(file)] = Array.new if !new_games[File.dirname(file)]
							new_games[File.dirname(file)].push(file)
						end
						break if !@scanning
					end
					break if !@scanning
				end
				if @scanning && new_games.size > 0
					new_games.keys.sort.each do | key |
						exes = new_games[key]
						if exes && exes.size > 0
							row = @scan_element.append(nil)
							row[0] = true
							row[1] = File.basename(key)
							exefiles = Gtk::ListStore.new(String)
							exes.sort.each_with_index do | exe, i |
								val = exefiles.append
								val[0] = File.basename(exe)
							end
							row[2] = exefiles
							row[3] = 0
							row[4] = true
							row[5] = File.basename(exes.sort[0])
							row[6] = key
						end
						break if !@scanning
					end
					@add_button.sensitive = true
					@import_button.sensitive = @rbox.config["nick"] != nil
				end
			end
			anim.hide
			@scanning = false
			@scan_button.sensitive = true
			if new_games.size == 0
				Hildon::Banner.show_information(@rbox, "rbox", "No new applications found.")
				@add_button.sensitive = false
			end
		end
	end

	def add_selected
		@scan_button.sensitive = false
		@add_button.sensitive = false
		@cancel_button.sensitive = true
		if @import_button.sensitive? && @import_button.active?
			#c = ConIc::Connection.new
			#c.signal_connect('connection_event') do | c, s |
			#	if s.status == 0
					add_apps
			#	else
					@rbox.page(0)
			#	end
			#end
			#c.connect
		else
			add_apps
		end
	end
	
	def add_apps
		@scanning = true
		pb = Gtk::ProgressBar.new
		progress = Hildon::Banner.show_progress(@rbox, pb, "Adding applications.")
		Thread.new do
			begin
				index = 0
				apps = 0
				@scan_list.model.each do |model, path, iter|
					apps += 1 if iter[0]
				end
				@scan_list.model.each do |model, path, iter|
					if iter[0]
						game_name = CGI::escape(File.basename(iter[6]).downcase.gsub(" ", "_")).gsub("%", "")
						executable = File.join(iter[6], iter[5])
						nice_name = File.basename(iter[6])
						ff = File.new(File.join(@rbox.prefsdir, "#{game_name}.conf"), "w")
						ff.write("# DosBox config created by RubyBox\n# #{nice_name}\n# #{executable}\n#\n")
						ff.close
						if @import_button.sensitive? && @import_button.active?
							@rbox.net.import_game(nice_name, executable, File.join(@rbox.prefsdir, "#{game_name}.conf"), Digest::MD5.hexdigest(File.new(executable).read), false)
						end
						index += 1
						pb.set_fraction(index.to_f / apps.to_f)
					end
					break if !@scanning
				end
				@rbox.update_gamelist
				@rbox.page(0)
			rescue Exception => ex
				puts ex.message
			ensure
				progress.hide
				@scanning = false
			end
		end
	end

	def reset_settings
		@scan_button.sensitive = true
		@add_button.sensitive = false
		@scan_element.clear
		@import_button.sensitive = false
	end

	def cancel_scan
		if !@scanning
			@rbox.page(0)
		else
			@scanning = false
		end
	end
end
