#! /usr/bin/env ruby
require 'hildon'
require 'launcher'
require 'netservices'
require 'downloader'
require 'settings'
#require 'libosso'
#require 'conic'
require 'yaml'
require "thread"
require 'dialogs'
require 'screenshot'
require 'running'
require 'scanner'

class RubyBox < Hildon::Window
	require 'find'
	
	def initialize
		super
		@version = "0.4.5"
		signal_connect( "delete_event" ) { clean_up }
		#context = OSSO.initialize('rbox', @version)
		@prefsdir = "#{ENV["HOME"]}/.rubybox"
		init
		signal_connect('key_release_event') { | w, e | key_pressed(w, e) }
		@fullscreen = false
		create_layout
		create_menu
		toggle_fullscreen
		@launcher.update_gamelist
		show_all
	end

	def init
		@dialogs = Dialogs.new(self)
		@net = NetServices.new(self)
		if !File.exists?(@prefsdir)
			Dir.mkdir(@prefsdir)
		end
		if File.exists?(File.join(@prefsdir, "config.yml"))
			@config = YAML.load_file(File.join(@prefsdir, "config.yml"))
		else
			@config = Hash.new
		end

	end
	
	def version
		return @version
	end

	def new_game
		@settings.new_game
	end
	
	def settings
		return @settings
	end

	def update_gamelist
		@launcher.update_gamelist
	end

	def load_game(name, executable, filename, keyboards)
		@settings.load_game(name, executable, filename, keyboards)
	end

	def page(num)
		@layout.page = num
	end

	def prefsdir
		return @prefsdir
	end

	def create_layout
		@layout = Gtk::Notebook.new
		@layout.show_tabs = false
		@layout.show_border = false
		@launcher = Launcher.new(10, 10, self)
		@settings = Settings.new("Settings", self)
		@download = Downloader.new(10, 10, self)
		@screenshot = Screenshot.new(self)
		@running = Running.new(self)
		@scanner = Scanner.new("Found applications", self)
		@layout.add(@launcher)
		@layout.add(@settings)
		@layout.add(@download)
		@layout.add(@screenshot)
		@layout.add(@running)
		@layout.add(@scanner)
		add(@layout)
	end		

	def dialogs
		return @dialogs
	end
	
	def download
		return @download
	end

	def create_menu
		main = Gtk::Menu.new
		labels = ["Preferences", "Application scan", "Help", "About", "Close"]
		connects = ["prefs", "app_scan", "help", "about", "clean_up"]
		icons = [Gtk::Stock::PREFERENCES, Gtk::Stock::ADD, Gtk::Stock::HELP, Gtk::Stock::ABOUT, Gtk::Stock::QUIT]
		labels.each_with_index do | label, i |
			item = Gtk::ImageMenuItem.new(label)
			item.image = Gtk::Image.new(icons[i],Gtk::IconSize::MENU)
			item.signal_connect( 'activate' ) { self.method(connects[i]).call }
			main.append(item)
		end
		set_menu(main)
	end

	def prefs
		settings = dialogs.prompt("Preferences", "Settings for RubyBox server", ["Address", "Your nickname"], [@config["address"], @config["nick"]])
		if settings && settings["Address"] && settings["Address"].length > 0 && settings["Your nickname"] && settings["Your nickname"].length > 0
			#c = ConIc::Connection.new
			#c.signal_connect('connection_event') do | c, s |
				#if s.status == 0
					@config["address"] = settings["Address"]
					@config["nick"] = settings["Your nickname"]
					data = @net.register_nick 
					if data && data.index("OK")
						save_config
						@launcher.update_buttonlist
						if data.index("OK (0)")
							Hildon::Banner.show_information(@rbox, "rbox", "Registered nick '#{@config["nick"]}'.")
						elsif data.index("OK (1)")
							Hildon::Banner.show_information(@rbox, "rbox", "Changed nick to '#{@config["nick"]}'")
						end
					else
						Hildon::Banner.show_information(@rbox, "rbox", "Unable to register your nickname. Try another one.")
					end
				#end
			#end
			#c.connect
		end
	end

	def save_config
		if @config
			File.open(File.join(@prefsdir, "config.yml"), "w") do | file | 
				YAML.dump(@config, file) 
			end 
		end
	end
	
	def screenshot
		return @screenshot
	end

	def config
		return @config
	end

	def net
		return @net
	end
	
	def running
		return @running
	end

	def toggle_fullscreen
		if !is_fullscreen?
			fullscreen
		else
			unfullscreen
		end
		@fullscreen = !@fullscreen
	end
	
	def is_fullscreen?
		return @fullscreen
	end
	
	def key_pressed(widget, event)	
		if event.keyval == Gdk::Keyval::GDK_F6
			toggle_fullscreen
		elsif event.keyval == Gdk::Keyval::GDK_F7
		elsif event.keyval == Gdk::Keyval::GDK_F8
		elsif event.keyval == Gdk::Keyval::GDK_Escape
			@layout.page = 2 if @layout.page == 3
			return false
		elsif event.keyval == Gdk::Keyval::GDK_Return
		elsif event.keyval == Gdk::Keyval::GDK_Up
		elsif event.keyval == Gdk::Keyval::GDK_Down
		elsif event.keyval == Gdk::Keyval::GDK_Right
		elsif event.keyval == Gdk::Keyval::GDK_Left
		end
	end
	
	def check_update
		#c = ConIc::Connection.new
		#c.signal_connect('connection_event') do | c, s |
			#if s.status == 0
				version, url = @net.check_for_updates
				if version
					path = nil
					if dialogs.confirm("New update (#{version})", "Do you want to install this update?")
						dialog = Gtk::FileChooserDialog.new("Download update to...",
						self,
						Gtk::FileChooser::ACTION_SELECT_FOLDER,
						nil,
						[Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL],
						[Gtk::Stock::OPEN, Gtk::Dialog::RESPONSE_ACCEPT])
						dialog.current_folder = config["current_dir"] || "/media"
						if dialog.run == Gtk::Dialog::RESPONSE_ACCEPT
							path = dialog.filename
						end
						dialog.destroy
						if path
							if download.download(url, File.new(File.join(path, File.basename(url)), "w+"))
								dialog = Gtk::MessageDialog.new(@rbox, 
									Gtk::Dialog::DESTROY_WITH_PARENT,
									Gtk::MessageDialog::INFO,
									Gtk::MessageDialog::BUTTONS_CLOSE,
									"RubyBox Update\n\nRubyBox will now start the application manager and exit.")
									dialog.run
									dialog.destroy
									if net.device_id == 0
										system("dbus-send --print-reply --dest='com.nokia.hildon_application_manager' /com/nokia/hildon_application_manager com.nokia.hildon_application_manager.install_file int32:0 string:'#{File.join(path, File.basename(url))}' &")
									elsif net.device_id == 1
										system("dbus-send --print-reply --dest='com.nokia.osso_application_installer' /com/nokia/osso_application_installer com.nokia.osso_application_installer.mime_open string:'#{File.join(path, File.basename(url))}' &")
									end
									clean_up
							else
								Hildon::Banner.show_information(@rbox, "rbox", "Unable to fetch the update. Try again later.")
							end
						end
					end
				else
					Hildon::Banner.show_information(@rbox, "rbox", "No updates available.")
				end
			#end
		#end
		#c.connect
	end

	def help
		dialogs.help("Help", "/usr/share/rbox/help.txt")
	end

	def about
		Gtk::AboutDialog.show(self, {:authors => ["Janne Mäkinen <janne.makinen@surffi.fi>"], :documenters => ["Pushwall", "Arnim  Sauerbier", "Addison", "qwerty12"], :version => @version, :logo => Gdk::Pixbuf.new("/usr/share/icons/hicolor/scalable/apps/rbox.png"), :comments => "RubyBox - A DosBox Frontend"})
	end
	
	def app_scan
		page(5)
		@scanner.reset_settings
	end

	def clean_up
		system("killall -9 xkbd")
		system("killall -9 dosbox")
		Gtk.main_quit
	end
end

if $0 == __FILE__
	GLib.set_application_name("RubyBox")
	app =  Hildon::Program.new
	app.add_window(RubyBox.new)
	Gtk.main
 end
