require 'hildon'
require 'fileutils'
require 'dialogs'
require 'xml/libxml'

class Launcher < Gtk::Table
	
	def initialize(rows, cols, rbox)
		@expanded = Hash.new
		begin
			@category_pixbuf = Gdk::Pixbuf.new("/usr/share/icons/hicolor/26x26/hildon/qgn_list_filesys_games_fldr.png")
			@game_pixbuf = Gdk::Pixbuf.new("/usr/share/icons/hicolor/26x26/hildon/qgn_list_filesys_game_file.png")
		rescue Exception => e
		end
		@rbox = rbox
		super(rows, cols)
		set_row_spacings(5)
		set_column_spacings(5)
		@listelement = Gtk::TreeStore.new(Gdk::Pixbuf,String, String, String, String)
		@list = Gtk::TreeView.new(@listelement)
		@list.level_indentation = 26 if @list.methods.include?("level_indentation")
		@list.signal_connect( 'row_expanded') do | w, i, p |
			@expanded[i[0]] = p
		end
		@list.signal_connect( 'row_collapsed') do | w, i, p |
			@expanded.delete(i[0]) if i[0]
		end
		row = Gtk::CellRendererPixbuf.new
		col = Gtk::TreeViewColumn.new("type", row, :pixbuf => 0)
		col.set_cell_data_func(row) do |col, renderer, model, iter|
			if !iter[2]
				renderer.pixbuf = @category_pixbuf
			else
				renderer.pixbuf = @game_pixbuf
			end
		end
		@list.append_column(col)
		row = Gtk::CellRendererText.new
		col = Gtk::TreeViewColumn.new("game", row, :text => 1)
		col.set_cell_data_func(row) do |col, renderer, model, iter|
			if !iter[2]
				renderer.weight = Pango::FontDescription::WEIGHT_BOLD
			else
				renderer.weight = Pango::FontDescription::WEIGHT_NORMAL
			end
		end
		@list.append_column(col)
		frame = Gtk::Frame.new("Applications")
		sw = Gtk::ScrolledWindow.new
		sw.add(@list)
		frame.add(sw)
		attach_defaults(frame, 0,10,0,9)
		@button_container = Gtk::HButtonBox.new
		@launch_button = Gtk::Button.new("Run")
		@launch_button.signal_connect( "button_press_event" ) do | w, e |
			run_game
		end
		@add_button = Gtk::Button.new("New")
		@settings_button = Gtk::Button.new("Settings")
		@settings_button.signal_connect( "button_press_event" ) do | w, e |
			game_settings
		end
		@remove_button = Gtk::Button.new("Remove")
		@remove_button.signal_connect( "button_press_event" ) do | w, e |
			remove_game
		end
		@add_button.signal_connect( "button_press_event" ) do | w, e |
			@rbox.new_game
		end
		@import_button = Gtk::Button.new("Import")
		@import_button.signal_connect( "button_press_event" ) do | w, e |
			#c = ConIc::Connection.new
			#c.signal_connect('connection_event') do | c, s |
				#if s.status == 0
					import
				#end
			#end
			#c.connect
		end
		@export_button = Gtk::Button.new("Export")
		@export_button.signal_connect( "button_press_event" ) do | w, e |
			#c = ConIc::Connection.new
			#c.signal_connect('connection_event') do | c, s |
			#	if s.status == 0
					export
			#	end
			#end
			#c.connect
		end
		@download_button = Gtk::Button.new("Download")
		@download_button.signal_connect( "button_press_event" ) do | w, e |
			@rbox.page(2)
		end
		@button_container.add(@launch_button)
		@button_container.add(@add_button)
		@button_container.add(@settings_button)
		@button_container.add(@remove_button)
		@button_container.add(@import_button)
		@button_container.add(@export_button)
		@button_container.add(@download_button)
		attach_defaults(@button_container, 0,10,9,10)
		update_buttonlist
	end
	
	def run_game
		if @list.selection.selected && @list.selection.selected.get_value(2)
			Thread.new do
				@rbox.running.start
				keyboards = @list.selection.selected.get_value(4)
				if keyboards && keyboards.strip != ""
					keyboards.split("|").each do | keyboard |
						keyboard = keyboard.split("=")
						if keyboard.size == 1 || keyboard[1].strip == ""
							system("xkbd -k \"#{keyboard[0]}\" &")
						else
							geometry = ""
							if keyboard[1] == "Top Left"
								geometry = "+65536+65536"
							elsif keyboard[1] == "Top Right"
								size = calculate_keyboard_size(keyboard[0])
								geometry = "+#{800 - size[0]}+65536"
							elsif keyboard[1] == "Middle Left"
								size = calculate_keyboard_size(keyboard[0])
								geometry = "+65536+#{240 - size[1] / 2}"
							elsif keyboard[1] == "Middle Right"
								size = calculate_keyboard_size(keyboard[0])
								geometry = "+#{800 - size[0]}+#{240 - size[1] / 2}"
							elsif keyboard[1] == "Bottom Left"
								size = calculate_keyboard_size(keyboard[0])
								geometry = "+65536+#{480 - size[1]}"
							elsif keyboard[1] == "Bottom Right"
								size = calculate_keyboard_size(keyboard[0])
								geometry = "+#{800 - size[0]}+#{480 - size[1]}"
							elsif keyboard[1] == "Top Center"
								size = calculate_keyboard_size(keyboard[0])
								geometry = "+#{400 - size[0] / 2}+65536"
							elsif keyboard[1] == "Bottom Center"
								size = calculate_keyboard_size(keyboard[0])
								geometry = "+#{400 - size[0] / 2}+#{480 - size[1]}"
							end
							system("xkbd -geometry #{geometry} -k \"#{keyboard[0]}\" &")
						end
					end
				end
				system("/usr/bin/rbox_launcher -conf \"#{@rbox.settings.configfile}\" -conf \"#{@list.selection.selected.get_value(3)}\" \"#{@list.selection.selected.get_value(2)}\"")
				system("killall -9 xkbd")
				@rbox.running.stop
			end
		end
	end
	
	def calculate_keyboard_size(keyboard_file)
		begin
			data = File.readlines(keyboard_file).delete_if{|x|x.index("#")}.join("").gsub("<key>", "<key><![CDATA[").gsub("</key>", "]]></key>")
			data = data[data.index("<layout>"), data.length]
			parser = XML::Parser.new
			parser.string = data
			doc = parser.parse
			rows = doc.find("//layout/row")
			width = 0
			height = 0
			last_width = 0
			last_height = 0
			rows.each do | row |
				current_width = 0
				current_height = 0
				row.find("key").each do | key |
					w = key.content.scan(/width\s{1,}(\d{1,})\n/i).flatten
					h = key.content.scan(/height\s{1,}(\d{1,})\n/i).flatten
					last_width = w[0].to_i if w.size != 0
					last_height = h[0].to_i if h.size != 0
					current_width += last_width
				end
				current_height += last_height
				width = current_width if current_width > width
				height = current_height if current_height > height
			end
			return [width, height * rows.size]
		rescue Exception => ex
			puts ex.message
			return [0,0]
		end
	end

	def update_gamelist
		selected = @list.selection.selected.get_value(1) if @list.selection.selected
		@listelement.clear
		Dir.entries(@rbox.prefsdir).push("").sort.each do | dir |
			row = nil
			if !dir.index(".") && File.directory?(File.join(@rbox.prefsdir, dir))
				Dir.entries(File.join(@rbox.prefsdir, dir)).sort.each do | file |
					filename = File.join(@rbox.prefsdir, dir, file)
					if File.extname(file) == ".conf"
						if !row
							row = @listelement.append(nil)
							row[1] = dir.length > 0 ? dir.gsub("_", " ") : "Uncategorized"
						end
						f = File.new(filename)
						data = f.readlines
						f.close
						row2 = @listelement.append(row)
						row2[1] = data[1][1..data[1].length].strip
						row2[2] = data[2][1..data[2].length].strip
						row2[3] = filename
						row2[4] = data[3][1..data[3].length].strip if data[3] && data[3].strip[0,1] == "#"
						if selected && selected == row2[1]
							Thread.new do
								@list.expand_row(row.path, false)
								sleep 0.1
								@list.selection.select_iter(row2)
								@list.scroll_to_cell(row2.path, nil, true, 0, 0)
								selected = nil
							end
						end
					end
				end
				if !row
					@expanded.delete(dir.gsub("_", " "))
				end
			end
		end
		@expanded.each_key do | key |
			path = @expanded[key]
			val = @list.expand_row(path, false)
			if !val
				@expanded.delete(key)
			end
		end
		
	end
	
	def disable_usage(sensitivity)
		@button_container.sensitive = sensitivity
		@button_container.sensitive = sensitivity
		@button_container.sensitive = sensitivity
		@button_container.sensitive = sensitivity
		@button_container.sensitive = sensitivity
		@button_container.sensitive = sensitivity
		@button_container.sensitive = sensitivity
		@list.sensitive = sensitivity
	end
	
	def update_buttonlist
		if @rbox.config["nick"]
			@import_button.sensitive = true
			@export_button.sensitive = true
			@download_button.sensitive = true
		else
			@import_button.sensitive = false
			@export_button.sensitive = false
			@download_button.sensitive = false
		end
	end

	def export
		if @list.selection.selected && @list.selection.selected.get_value(2)
			anim = Hildon::Banner.show_animation(@rbox, "rbox", "Exporting settings")
			begin
				#Thread.new do
					md5sum = Digest::MD5.hexdigest(File.new(@list.selection.selected.get_value(2)).read)
					config = CGI::escape(File.new(@list.selection.selected.get_value(3)).read)
					if @rbox.net.export_game(@list.selection.selected.get_value(1), md5sum, config)
						Hildon::Banner.show_information(@rbox, "rbox", "Export successful.")
					else
						Hildon::Banner.show_information(@rbox, "rbox", "Export failed!")
					end
				#end
			rescue Exception => e
				Hildon::Banner.show_information(@rbox, "rbox", "Export failed!")
			ensure
				anim.hide
			end
		end
	end

	def import
		if @list.selection.selected && @list.selection.selected.get_value(2)
			anim = Hildon::Banner.show_animation(@rbox, "rbox", "Importing settings")
			begin
				md5sum = Digest::MD5.hexdigest(File.new(@list.selection.selected.get_value(2)).read)
				if @rbox.net.import_game(@list.selection.selected.get_value(1),@list.selection.selected.get_value(2), @list.selection.selected.get_value(3), md5sum)
					update_gamelist
					Hildon::Banner.show_information(@rbox, "rbox", "Import successful.")
				else
					Hildon::Banner.show_information(@rbox, "rbox", "No profile found.")
				end
			rescue Exception => e
				puts e.backtrace.join("\n")
				Hildon::Banner.show_information(@rbox, "rbox", "Import failed!")
			end
			begin
				anim.hide
			rescue Exception => ex
			end
		end
	end
	
	def game_settings
		if @list.selection.selected && @list.selection.selected.get_value(2)
			@rbox.load_game(@list.selection.selected.get_value(1), @list.selection.selected.get_value(2), @list.selection.selected.get_value(3), @list.selection.selected.get_value(4))
		end
	end

	def remove_game
		if @list.selection.selected && @list.selection.selected.get_value(2) && @rbox.dialogs.confirm("Remove application?", "Are you sure you want to remove this item from the list?")
			FileUtils.rm(@list.selection.selected.get_value(3))
			update_gamelist
		end
	end
end
