require 'hildon'
#require 'conic'
require 'fileutils'
require 'dialogs'
require 'xml/libxml'
require 'find'
require 'digest/md5'

class Downloader < Gtk::Table
	
	def initialize(rows, cols, rbox)
		super(rows, cols)
		begin
			@settings_pixbuf = Gdk::Pixbuf.new("/usr/share/icons/hicolor/26x26/hildon/qgn_list_cp_devicesetup.png")
			@screenshot_pixbuf = Gdk::Pixbuf.new("/usr/share/icons/hicolor/26x26/hildon/qgn_list_gene_image_file.png")
		rescue Exception => e
		end
		@rbox = rbox
		@settings_texts = ["No settings in database for this app", "You can import settings for this game", "Doesn't need custom settings"]
		@listelement = Gtk::TreeStore.new(Gdk::Pixbuf, Gdk::Pixbuf, String, String, String, String, String, String, String)
		@list = Gtk::TreeView.new(@listelement)
		@list.signal_connect( 'cursor_changed' ) do | w |
			selection_changed
		end
		row = Gtk::CellRendererPixbuf.new
		col = Gtk::TreeViewColumn.new("settings", row, :pixbuf => 0)
		@list.append_column(col)
		row = Gtk::CellRendererPixbuf.new
		col = Gtk::TreeViewColumn.new("screenshot", row, :pixbuf => 1)
		@list.append_column(col)
		
		row = Gtk::CellRendererText.new
		col = Gtk::TreeViewColumn.new("game", row, :text => 2)
		@list.append_column(col)
		hbox = Gtk::HBox.new
		frame = Gtk::Frame.new("List of freeware applications")
		sw = Gtk::ScrolledWindow.new
		sw.add(@list)
		frame.add(sw)
		frame.width_request = 400
		hbox.pack_start(frame)
		@buffer = Gtk::TextBuffer.new
		@description = Gtk::TextView.new
		@description.editable = false
		@description.cursor_visible = false
		@description.wrap_mode = Gtk::TextTag::WRAP_WORD
		frame = Gtk::Frame.new("Description")
		frame.width_request = 400
		sw = Gtk::ScrolledWindow.new
		sw.add(@description)
		vbox = Gtk::VBox.new
		vbox.pack_start(sw)
		@settings = Gtk::Label.new
		vbox.pack_end(@settings, false, false)
		frame.add(vbox)
		hbox.pack_start(frame)
		attach_defaults(hbox, 0,10,0,8)
		@path = Gtk::Entry.new
		@path.width_request = 400
		@path.text = @rbox.config["current_dir"] if @rbox.config["current_dir"]
		hbox = Gtk::HBox.new
		hbox.pack_start(Gtk::Label.new("Store applications to:"))
		hbox.pack_start(@path)
		@browse_button = Gtk::Button.new("Browse")
		@browse_button.height_request = 26
		@browse_button.signal_connect( "button_press_event" ) do | w, e |
			browse
		end
		hbox.pack_start(@browse_button)
		attach_defaults(hbox, 0,10,8,9)
		button_container = Gtk::HButtonBox.new
		button_container.layout_style = Gtk::ButtonBox::START
		@update_button = Gtk::Button.new("Update list")
		@update_button.signal_connect( "button_press_event" ) do | w, e |
			#c = ConIc::Connection.new
			#c.signal_connect('connection_event') do | c, s |
			#	if s.status == 0
					update_list
			#	end
			#end
			#c.connect
		end
		@download_button = Gtk::Button.new("Download")
		@download_button.signal_connect( "button_press_event" ) do | w, e |
			#c = ConIc::Connection.new
			#c.signal_connect('connection_event') do | c, s |
			#	if s.status == 0
					install_app
			#	end
			#end
			#c.connect	
		end
		@download_button.sensitive = false
		@screenshot_button = Gtk::Button.new("Screenshot")
		@screenshot_button.signal_connect( "button_press_event" ) do | w, e |
			#c = ConIc::Connection.new
			#c.signal_connect('connection_event') do | c, s |
			#	if s.status == 0
					show_screenshot
			#	end
			#end
			#c.connect
		end
		@screenshot_button.sensitive = false
		@stats_button = Gtk::Button.new("Statistics")
		@stats_button.signal_connect( "button_press_event" ) do | w, e |
			#c = ConIc::Connection.new
			#c.signal_connect('connection_event') do | c, s |
			#	if s.status == 0
					show_statistics
			#	end
			#end
			#c.connect
		end
		@cancel_button = Gtk::Button.new("Cancel")
		@cancel_button.signal_connect( "button_press_event" ) do | w, e |
			cancel
		end
		@download_type = Gtk::ComboBox.new
		@download_type.append_text("Applications")
		@download_type.append_text("XKBD Layouts")
		@download_type.append_text("KB Mappers")
		@download_type.set_active(0)
		button_container.add(@download_type)
		button_container.add(@update_button)
		button_container.add(@download_button)
		button_container.add(@screenshot_button)
		button_container.add(@stats_button)
		button_container.add(@cancel_button)
		attach_defaults(button_container, 0,10,9,10)
	end
	
	def update_list
		@listelement.clear
		@buffer.text = ""
		@description.buffer = @buffer
		Thread.new do
			begin
				@downloading = true
				enable_controls(false)
				@download_button.sensitive = false
				pb = Gtk::ProgressBar.new
				progress = Hildon::Banner.show_progress(@rbox, pb, "Updating list.")
				data = @rbox.net.download_list(@download_type.active.to_s)
				if data && data.index("rbox")
					parser = XML::Parser.string(data)
					#parser.string = data
					doc = parser.parse
					index = 0
					items = doc.find('//rbox/game')
					amount = items.size.to_f
					items.each do | game |
						row = @listelement.append(row)
						row[2] = game.find('name').first.content
						row[3] = game.find('description').first.content
						row[4] = game.find('url').first.content
						row[5] = game.find('executable').first.content
						row[6] = game.find('screenshot').first.content
						row[7] = game.find('settings').first.content
						row[8] = game.find('type').first.content
						if row[7].to_i == 1
							row[0] = @settings_pixbuf
						end
						if row[6] && row[6].length > 0
							row[1] = @screenshot_pixbuf
						end
						index += 1
						pb.fraction = index.to_f / amount
						break if !@downloading
					end
				else
					Hildon::Banner.show_information(@rbox, "rbox", "Unable to fetch the list.")
				end
			rescue Exception => e
				puts e.message
			ensure
				progress.hide
				enable_controls(true)
				@downloading = false
			end
		end
	end

	def browse
		dialog = Gtk::FileChooserDialog.new("Select the target directory",
			@rbox,
			Gtk::FileChooser::ACTION_SELECT_FOLDER,
			nil,
			[Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL],
			[Gtk::Stock::OPEN, Gtk::Dialog::RESPONSE_ACCEPT])
		dialog.current_folder = @rbox.config["current_dir"] || "/media"
		if dialog.run == Gtk::Dialog::RESPONSE_ACCEPT
			@path.text = dialog.filename
			@current_dir = dialog.filename
			@rbox.config["current_dir"] = @current_dir
			@rbox.save_config
		end
		dialog.destroy
	end
	
	def show_statistics
		data = @rbox.net.statistics
		if data && data.index("rbox")
			doc = Document.new(data)
			dialog = Gtk::MessageDialog.new(@rbox, 
					Gtk::Dialog::DESTROY_WITH_PARENT,
					Gtk::MessageDialog::INFO,
					Gtk::MessageDialog::BUTTONS_CLOSE,
					"RubyBox statistics\n\nRegistered users: #{doc.root.elements[1].text}\nExported settings: #{doc.root.elements[2].text}\nDownloadable games: #{doc.root.elements[3].text}
					")
			dialog.run
			dialog.destroy
		else
			Hildon::Banner.show_information(@rbox, "rbox", "Unable to get the statistics.")
		end
	end

	def install_app
		if @list.selection.selected
			type = @list.selection.selected.get_value(8).to_i
			if @path.text.strip.length > 0 && File.readable?(@path.text)
				Thread.new do
					enable_controls(false)
					f = File.new(File.join(@path.text, "_rbox.zip"), "w")
					if download(@list.selection.selected.get_value(4), f)
						game_name = [CGI::escape(@list.selection.selected.get_value(2).downcase.gsub(" ", "_")).gsub("%", ""), ".xkbd_layouts", ".mappers"][type]
						target_dir = [File.join(@path.text, game_name), File.join(ENV["HOME"], ".rubybox", game_name), File.join(ENV["HOME"], ".rubybox", game_name)][type]
						FileUtils.mkdir_p(target_dir) if !File.exists?(target_dir)
						anim = Hildon::Banner.show_animation(@rbox,"Extracting", "Extracting.")
						@cancel_button.sensitive = false
						unzip = system("unzip -o -qq -d \"#{target_dir}\" \"#{f.path}\"")
						@cancel_button.sensitive = true
						anim.hide
						if type == 0
							if unzip
								executable = @list.selection.selected.get_value(5)
								exe = nil
								exes = Array.new
								Find.find(target_dir) do | file |
									if !executable || executable == ""
										if (File.extname(file.downcase) == ".exe" || File.extname(file.downcase) == ".com") && !file.downcase.index("setup") && !file.downcase.index("install")
											exes.push(file)
										end
									else
										if File.basename(file).downcase == executable.downcase
											exes.push(file)
										end
									end
								end
								exe = exes.sort[0] if exes.size > 0
								if exe
									ff = File.new(File.join(@rbox.prefsdir, "#{game_name}.conf"), "w")
									ff.write("# DosBox config created by RubyBox\n# #{@list.selection.selected.get_value(2)}\n# #{exe}\n")
									ff.close
									@rbox.net.import_game(@list.selection.selected.get_value(2), exe, File.join(@rbox.prefsdir, "#{game_name}.conf"), Digest::MD5.hexdigest(File.new(exe).read), false)
									@rbox.update_gamelist
									Hildon::Banner.show_information(@rbox, "rbox", "Installation succesful.")
								else
									Hildon::Banner.show_information(@rbox, "rbox","Game downloaded, but not installed.")
								end
							else
								Hildon::Banner.show_information(@rbox, "rbox", "Unable to extract.")
							end
						else
							
							Hildon::Banner.show_information(@rbox, "rbox", "Installation succesful.")
						end
					else
						Hildon::Banner.show_information(@rbox, "rbox", "Unable to download.")
					end
					FileUtils.rm(f.path) if File.exists?(f.path)
					enable_controls(true)
				end
			else
				Hildon::Banner.show_information(@rbox, "rbox", "Please select the target directory.")
			end			
		end
	end

	def download(uri_str, file, limit = 10)
		@downloading = true
		progress = nil
		begin
			raise ArgumentError, 'HTTP redirect too deep' if limit == 0
			Net::HTTP.get_response(URI.parse(uri_str)) do | response |
				case response
				when Net::HTTPSuccess
				        length =  response['content-length']
					pb = Gtk::ProgressBar.new
					progress = Hildon::Banner.show_progress(@rbox, pb, "Downloading (#{length ? "#{round(length.to_f / 1024 / 1024, 2)} mb" : "Unknown size"})")
				        received = 0
					data = String.new
				        response.read_body do | segment |
				                received += segment.length
						data += segment
				                if length
				                       pb.set_fraction(received.to_f / length.to_f)
				                end
						if data.length > 128000
					                file.write(data)
							data = String.new
						end
						break if !@downloading
				        end
					file.write(data)
					file.flush
				        file.close
					progress.hide
			        	return @downloading
				when Net::HTTPRedirection then download(response['location'], file, limit - 1)
				else
				        return false
				end
			end
		rescue Exception => e
			puts e.message
		ensure
			@downloading = false
			progress.hide if progress
		end
		return false
	end

	def enable_controls(sensitive)
		@stats_button.sensitive = sensitive
		@browse_button.sensitive = sensitive
		@update_button.sensitive = sensitive
		@screenshot_button.sensitive = sensitive
		@path.sensitive = sensitive
		@list.sensitive = sensitive
	end

	def cancel
		if !@downloading
			@rbox.page(0)
		else
			@downloading = false
		end
	end

	def round(float, num_of_decimal_places)
		exponent = num_of_decimal_places
		float = float*(10**exponent)
		float = float.round
		float = float / (10.0**exponent)
		return float
	end
	
	def show_screenshot
		if @list.selection.selected && @list.selection.selected.get_value(6) && @list.selection.selected.get_value(6).index("http")
			@rbox.screenshot.load_image(@list.selection.selected.get_value(6))
		end
	end

	def selection_changed
		if @list.selection.selected && @list.selection.selected.get_value(3)
			@buffer.text = @list.selection.selected.get_value(3)
			@description.buffer = @buffer
			@download_button.sensitive = true
			@screenshot_button.sensitive = @list.selection.selected && @list.selection.selected.get_value(6) && @list.selection.selected.get_value(6).index("http") ? true : false
			if @list.selection.selected.get_value(8).to_i == 0
				@settings.text = @settings_texts[@list.selection.selected.get_value(7).to_i]
			else
				@settings.text = ""
			end
		end
	end

end
