/*
Rubido, Created by Willems Davy - Willems Soft 2006

Rubido is freeware and may not be resold, you can not recompile this code
and place your name under it, it's for educational purposes only.

I'm fairly new to c++, so this code could look ugly, but i don't care
i'm happy if it works without problems. I also know i just place
everything in one big cpp file, that's because i haven't learned how
to use header files and include diffrent cpp files.
Anyway i thought this could be helpfull to some of us so i released it.
I've tried to place as many comments as possible.

If you use any part of this code don't forget to credit where it's due

Building using Devkitgp2x installed in c:\

comple with :
arm-linux-g++ -c main.cpp -o main.o -Ic:\devkitgp2x\include -Ic:\devkitgp2x\include\SDL -mcpu=arm920 -mtune=arm920t -O3 -fstrict-aliasing -fexpensive-optimizations -falign-functions -fweb -frename-registers -fomit-frame-pointer -ffast-math -finline -finline-functions -fno-builtin -fno-common -mstructure-size-boundary=8 -msoft-float
link with:
arm-linux-g++ -static -s main.o -o rubido.gpe -Lc:\devkitgp2x\lib -lSDLmain -lSDL_image -lpng -ljpeg -lz -lc -lm -lgcc -lSDL_ttf -lfreetype -lSDL_mixer -lvorbisidec -lmikmod -lSmpeg -lSDL -lpthread
strip with:
arm-linux-strip rubido.gpe

*/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <limits.h>
#include <SDL/SDL.h>
#include <SDL/SDL_ttf.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_mixer.h>
#include <SDL/SDL_gfxPrimitives.h>
#include <SDL/SDL_syswm.h>
#include <SDL/SDL_rotozoom.h>
#include <X11/Xutil.h>

#define SCALEFACTOR 2

using namespace std;

//the constants used in the game
const int NrOfRows = 9, // how many rows and columns of board parts (pegs) there could be, it's
		  NrOfCols = 9, // acutally to much but it's easier to use this as u'll see in the code
		  TileWidth = 24*SCALEFACTOR, // height and with af the board peg tile
		  TileHeight =24*SCALEFACTOR,
		  IDPeg = 1,
          XOffSet = 10*SCALEFACTOR, //offset where to start drawing the board tiles
          YOffSet = 11*SCALEFACTOR,
		  NrOfSounds=6, // Nr of sounds and sound identifiers.
		  SND_SELECT=0,
		  SND_GOOD=1,
		  SND_WRONG=2,
		  SND_START=3,
		  SND_WINNER=4,
		  SND_LOSER=5;

// The diffrent gameStates possible in the game
enum GameStates {GSQuit,GSGame,GSTitleScreen,GSDifficultySelect,GSCredits};

// The diffrent difficultys
enum SDifficulty {VeryEasy=0,Easy=1,Hard=2,VeryHard=3};

// A struct that holds x & y coordinate
struct SPoint
{
    int X,Y;
};

// Here i place global variables that will also be used inside the classes, they have to be declared
// before the classes in order to use them
SDL_Surface *IMGPeg,*IMGBackground;
SDifficulty Difficulty = VeryEasy;
Mix_Chunk *Sounds[NrOfSounds]; // array that will hold the sounds
char StartPath[PATH_MAX];


SDL_Surface* ScaleSurface(SDL_Surface* Surface,int ScaleFactor)
{
    return zoomSurface(Surface,ScaleFactor,ScaleFactor,0);
}


// Class for the main menu
class CMainMenu
{
    private:
        int Selection; //Holds what we currently selected in the main menu, 1 = new game, 2= credits, 3 = quit
        SDL_Surface *IMGCredits1,*IMGCredits2,*IMGNewGame1,*IMGNewGame2,*IMGQuit1,*IMGQuit2,*IMGTitle; // the surfaces needed for the graphics inside the game
    public:
        CMainMenu(); // constructor
        void Draw(SDL_Surface *Surface); //draw to a certain surface
        void NextItem(); //Select the next menuitem
        void PreviousItem(); //select the previous menuitem
        int GetMouseSelection(int X,int Y,SDL_Surface *Surface);
        int GetSelection() { return Selection; } // return the current selection
        ~CMainMenu(); // destructor
};

// Class for the selector, it will hold the previous selected coordinate of a peg and the current position
// of the board selector (the light blue square ingame)
class CSelector
{
    private:
        SPoint SelectedPoint,CurrentPoint; //variables to hold the current position and the selected position

    public:
        bool HasSelection;
        // constructor, parameters define the starting position
        CSelector(const int PlayFieldXin,const int PlayFieldYin)
        {
            SelectedPoint.X = 0; // there's no selection set it 0
            SelectedPoint.Y = 0;
            CurrentPoint.X = PlayFieldXin; // set current position
            CurrentPoint.Y = PlayFieldYin;
            HasSelection = false; // No selection when it's created
        }
        // Will set the position only if it layes within the board boundary
        void SetPosition(const int PlayFieldXin,const int PlayFieldYin)
        {
            // check if the new position is inside the board, if so set the new position as the currentposition
            if (((PlayFieldYin>=0) && (PlayFieldYin < 3) && (PlayFieldXin > 2) && (PlayFieldXin < 6)) ||
                ((PlayFieldYin > 2) && (PlayFieldYin<6) && (PlayFieldXin >=0) && (PlayFieldXin <NrOfCols)) ||
                ((PlayFieldYin > 5)&& (PlayFieldYin < NrOfRows) && (PlayFieldXin > 2) && (PlayFieldXin <6)))
                {
                    CurrentPoint.X = PlayFieldXin;
                    CurrentPoint.Y = PlayFieldYin;
                }
        }
        // Select will set the current position as the selected position
        void Select()
        {
            SelectedPoint.X = CurrentPoint.X;
            SelectedPoint.Y = CurrentPoint.Y;
            HasSelection = true;
        }
        // return the selected position
        SPoint GetSelection()
        {
            return SelectedPoint;
        }
        // return the current position
        SPoint GetPosition()
        {
            return CurrentPoint;
        }
        void DeSelect()
        {
            HasSelection = false;
        }
        // Draw the blue box on the current position, with the offsets in mind
        void Draw(SDL_Surface *Surface)
        {
            boxRGBA(Surface, XOffSet + CurrentPoint.X * (TileWidth), YOffSet+ CurrentPoint.Y * (TileHeight), XOffSet-(1) + (CurrentPoint.X +(1))* (TileWidth ), YOffSet-(1)+ (CurrentPoint.Y+(1)) * (TileHeight), 0, 0, 200, 125);
        }
        ~CSelector()
        {
        }
};

//define the Cboardpart class already since it will be used in the CBoardparts class, we will complete it later
class CBoardPart;

//Class that will hold all the current objects (pegs) on the board
class CBoardParts
{
 public:
 	CBoardPart *Items[NrOfRows*NrOfCols*3]; // array of Cboardparts
 	int ItemCount; //how many objects (pegs)
 	CBoardParts(); // constructor
 	void Add(CBoardPart *BoardPart); // Add a boardpart
 	void Draw(SDL_Surface *Surface); // Draw all boardparts
 	CBoardPart *GetPart(const int PlayFieldXin,const int PlayFieldYin); // return a boardpart given the coordinates
 	void RemoveAll(); // remove (free) all boardparts
	~CBoardParts();
};

//Base Class that defines a Cboardpart, it's only a peg
class CBoardPart
{
 protected:
 	int Type,X,Y,PlayFieldX,PlayFieldY,AnimPhase; //Animphase holds the current selected frame of the tile
 	SDL_Surface * Image;

 public:
 	CBoardParts *ParentList; // the parentlist, points to a CBoardParts class
 	CBoardPart(const int PlayFieldXin,const int PlayFieldYin) //Constructor, create a boardpart with the given location
 	{
 		PlayFieldX=PlayFieldXin; // Set the current playfield position
 		PlayFieldY=PlayFieldYin;
 		X=XOffSet + PlayFieldXin*TileWidth; //set the screen position (for drawing)
 		Y=YOffSet + PlayFieldYin*TileHeight;
 		Type=0; // type is 0
 		Image = NULL;
 		ParentList = 0;
 		AnimPhase=0;
 	}
 	int GetType() {return Type;}; // return the type
 	int GetX() {return X;} // get the screen x coordiante
 	int GetY() {return Y;} // get the screen y coordinate
 	int GetPlayFieldX() {return PlayFieldX;} // Get the playfield X coordinate
 	int GetPlayFieldY() {return PlayFieldY;} // Get The playfield Y Coordinate
 	int GetAnimPhase() {return AnimPhase;} // returns the current frame of the tile
 	void SetAnimPhase(int AnimPhaseIn) { AnimPhase = AnimPhaseIn;} // sets the current frame of the tile
 	void SetPosition(const int PlayFieldXin,const int PlayFieldYin) // change the position of the tile, it isn't used in this game but i left it in
 	{
 		if ((PlayFieldXin >= 0) && (PlayFieldXin < NrOfCols) && (PlayFieldYin >= 0) && (PlayFieldYin < NrOfRows))
 		{
 			PlayFieldX=PlayFieldXin;
 			PlayFieldY=PlayFieldYin;
 			X=XOffSet + PlayFieldXin*TileWidth;
 			Y=YOffSet + PlayFieldYin*TileHeight;
 		}
 	}
 	virtual bool CanMoveTo(const int PlayFieldXin,const int PlayFieldYin,bool erase) {return false;} // can we move to a certain point, base always returns false, must be redeclared in inherited classes
 	virtual void Draw(SDL_Surface* Surface) // drawing
 	{
 		//printf("Start draw type:%d\n",Type);
 		if (Image)
 		{

 			SDL_Rect SrcRect,DstRect;
			SrcRect.x = AnimPhase * TileWidth; // current frame * tilewidth is
			SrcRect.y = 0;
			SrcRect.w = TileWidth;
			SrcRect.h = TileHeight;
			DstRect.x = X;
			DstRect.y = Y;
			DstRect.w = TileWidth;
			DstRect.h = TileHeight;
			SDL_BlitSurface(Image,&SrcRect,Surface,&DstRect); // blit it to the specified surface
		}
    }
 	virtual ~CBoardPart()
 	{

 	}
};

// Cpeg is a class based on CBpoartPart
class CPeg : public CBoardPart
{
    public:
    // Constructor, just calls the base constructor of the base class with the same parameters
    // and sets some other parameters that are specific to CPeg
    CPeg(const int PlayFieldXin,const int PlayFieldYin) : CBoardPart(PlayFieldXin,PlayFieldYin)
    {
        Type = IDPeg; // Id, isn't actually used in the game but if u have diffrent boardparts, u can identify it by this
        Image = IMGPeg; // set the image
        AnimPhase = 0; // current frame = 0 (a red dot)
    }
    // can we move to the new playfield Coordinate
    bool CanMoveTo(const int PlayFieldXin,const int PlayFieldYin,bool erase)
    {
        bool temp;
        temp = true;
        float Xi,Yi;
        int LowX,LowY;
        // if there isn't a boardpart on the specified location
        if (!(ParentList->GetPart(PlayFieldXin,PlayFieldYin)))
            return false;
        else
        // if the current frame isn't either a red peg or a blue peg
        if (!(AnimPhase <2))
            return false;
        else
        //if the place we wan't to move to is an empty peg (animphase = 6)
        if (ParentList->GetPart(PlayFieldXin,PlayFieldYin)->GetAnimPhase() == 6)
        {
            //calculate the diffrence between the 2 points as a float
            Xi = (float)abs(PlayFieldXin - PlayFieldX)/2;
            Yi = (float)abs(PlayFieldYin - PlayFieldY)/2;

            if((Difficulty == VeryHard ) || (Difficulty == Hard))
                // here we see if xi, or yi quals 1 io movement is vertical or horintal and
                // xi or yi is 1. if it isn't 1 this means the new position isn't
                // exactly 2 pegs further away
                temp = temp &&  (((Xi == 0) && (Yi == 1)) || ((Xi ==1) && (Yi == 0)));
            else
                // same as above except we add a diagonal
                temp = temp && (((Xi == 0) && (Yi == 1)) || ((Xi ==1) && (Yi == 0)) || ((Xi==1) && (Yi == 1)));
            if (temp)
            {
                // calculate the lowest X & Y coordinate
                // will be used to find the middle peg (io the one we jumped over)
                if (PlayFieldXin <= PlayFieldX)
                    LowX = PlayFieldXin;
                else
                    LowX = PlayFieldX;
                if (PlayFieldYin <= PlayFieldY)
                    LowY = PlayFieldYin;
                else
                    LowY = PlayFieldY;
                // if the middle peg doesn't exists
                 if (!(ParentList->GetPart(LowX+(int)Xi,LowY+(int)Yi)))
                    return false;
                else
                // If the middle peg is either a blue (will never happen) or a red peg
                if (ParentList->GetPart(LowX+(int)Xi,LowY+(int)Yi)->GetAnimPhase() < 2)
                {
                    // simple hack to specify we want the middle peg to be emptied (animpahse = 6)
                    // i did this so i didn't need to do the above calcultions again in Game()
                    if (erase)
                        ParentList->GetPart(LowX+(int)Xi,LowY+(int)Yi)->SetAnimPhase(6);
                    return true;
                }
                else
                    return false;
            }
            else
                return false;
        }
        else
            return false;
    }
};

// constructor of main menu will Load the graphics and set the current selection to 1 (io newgame)
CMainMenu::CMainMenu()
{
    Selection = 1;
    SDL_Surface *Tmp,*Tmp2;
    char FileName[PATH_MAX+FILENAME_MAX];

	sprintf(FileName,"%sgraphics/titlescreen.png",StartPath);
    Tmp = IMG_Load(FileName);
    Tmp2 = ScaleSurface(Tmp,SCALEFACTOR);
    IMGTitle = SDL_DisplayFormat(Tmp2);
    SDL_FreeSurface(Tmp);
    SDL_FreeSurface(Tmp2);

    sprintf(FileName,"%sgraphics/newgame1.png",StartPath);
    Tmp = IMG_Load(FileName);
    Tmp2 = ScaleSurface(Tmp,SCALEFACTOR);
    IMGNewGame1 = SDL_DisplayFormat(Tmp2);
    SDL_SetColorKey(IMGNewGame1,(SDL_SRCCOLORKEY|SDL_RLEACCEL),SDL_MapRGB(IMGNewGame1->format,255,0,255));
    SDL_FreeSurface(Tmp);
    SDL_FreeSurface(Tmp2);

    sprintf(FileName,"%sgraphics/newgame2.png",StartPath);
    Tmp = IMG_Load(FileName);
    Tmp2 = ScaleSurface(Tmp,SCALEFACTOR);
    IMGNewGame2 = SDL_DisplayFormat(Tmp2);
    SDL_SetColorKey(IMGNewGame2,(SDL_SRCCOLORKEY|SDL_RLEACCEL),SDL_MapRGB(IMGNewGame2->format,255,0,255));
    SDL_FreeSurface(Tmp);
    SDL_FreeSurface(Tmp2);

    sprintf(FileName,"%sgraphics/credits1.png",StartPath);
    Tmp = IMG_Load(FileName);
    Tmp2 = ScaleSurface(Tmp,SCALEFACTOR);
    IMGCredits1 = SDL_DisplayFormat(Tmp2);
    SDL_SetColorKey(IMGCredits1,(SDL_SRCCOLORKEY|SDL_RLEACCEL),SDL_MapRGB(IMGCredits1->format,255,0,255));
    SDL_FreeSurface(Tmp);
    SDL_FreeSurface(Tmp2);

    sprintf(FileName,"%sgraphics/credits2.png",StartPath);
    Tmp = IMG_Load(FileName);
    Tmp2 = ScaleSurface(Tmp,SCALEFACTOR);
    IMGCredits2 = SDL_DisplayFormat(Tmp2);
    SDL_SetColorKey(IMGCredits2,(SDL_SRCCOLORKEY|SDL_RLEACCEL),SDL_MapRGB(IMGCredits2->format,255,0,255));
    SDL_FreeSurface(Tmp);
    SDL_FreeSurface(Tmp2);

    sprintf(FileName,"%sgraphics/quit1.png",StartPath);
    Tmp = IMG_Load(FileName);
    Tmp2 = ScaleSurface(Tmp,SCALEFACTOR);
    IMGQuit1 = SDL_DisplayFormat(Tmp2);
    SDL_SetColorKey(IMGQuit1,(SDL_SRCCOLORKEY|SDL_RLEACCEL),SDL_MapRGB(IMGQuit1->format,255,0,255));
    SDL_FreeSurface(Tmp);
    SDL_FreeSurface(Tmp2);

    sprintf(FileName,"%sgraphics/quit2.png",StartPath);
    Tmp = IMG_Load(FileName);
    Tmp2 = ScaleSurface(Tmp,SCALEFACTOR);
    IMGQuit2 = SDL_DisplayFormat(Tmp2);
    SDL_SetColorKey(IMGQuit2,(SDL_SRCCOLORKEY|SDL_RLEACCEL),SDL_MapRGB(IMGQuit2->format,255,0,255));
    SDL_FreeSurface(Tmp);
    SDL_FreeSurface(Tmp2);

}

// Destructor will free the surface images
CMainMenu::~CMainMenu()
{
    SDL_FreeSurface(IMGNewGame1);
    SDL_FreeSurface(IMGNewGame2);
    SDL_FreeSurface(IMGCredits1);
    SDL_FreeSurface(IMGCredits2);
    SDL_FreeSurface(IMGQuit1);
    SDL_FreeSurface(IMGQuit2);
    SDL_FreeSurface(IMGTitle);
}

// Increase the selection if it goes to far set i to the first selection
void CMainMenu::NextItem()
{
    Selection++;
    if (Selection == 4)
        Selection = 1;
    Mix_PlayChannel(-1,Sounds[SND_SELECT],0);
}

// decrease the selection if it goes to low set it to the last selection
void CMainMenu::PreviousItem()
{
    Selection--;
    if (Selection == 0)
        Selection = 3;
    Mix_PlayChannel(-1,Sounds[SND_SELECT],0);
}

int CMainMenu::GetMouseSelection(int X,int Y,SDL_Surface *Surface)
{
    if ((X > (Surface->w/2 - IMGNewGame1->w/2)  && (X < (Surface->w/2 - IMGNewGame1->w/2) + IMGNewGame1->w)) &&
        (Y > 77*SCALEFACTOR) && ( Y < (77*SCALEFACTOR) + IMGNewGame1->h))
        return 1;
    else
        if ((X > (Surface->w/2 - IMGCredits1->w/2)  && (X < (Surface->w/2 - IMGCredits1->w/2) + IMGCredits1->w)) &&
            (Y > 115*SCALEFACTOR) && ( Y < (115*SCALEFACTOR) + IMGCredits1->h))
            return 2;
        else
            if ((X > (Surface->w/2 - IMGQuit1->w/2)  && (X < (Surface->w/2 - IMGQuit1->w/2) + IMGQuit1->w)) &&
                (Y > 155*SCALEFACTOR) && ( Y < (155*SCALEFACTOR) + IMGQuit1->h))
                return 3;
            else
                return 0;
}

// Draw the main menu
void CMainMenu::Draw(SDL_Surface *Surface)
{
    SDL_Rect Dest;

    // draw the title screen background
    SDL_BlitSurface(IMGTitle,NULL,Surface,NULL);

    // if selection = newgame draw the purple new game image in the middle of the screen
    if (Selection == 1)
    {
        Dest.x = Surface->w/2 - IMGNewGame1->w/2;
        Dest.y = 77*SCALEFACTOR;
        Dest.w = IMGNewGame1->w;
        SDL_BlitSurface(IMGNewGame1,NULL,Surface,&Dest);
    }
    else
    // draw the blue one
    {
        Dest.x = Surface->w/2 - IMGNewGame2->w/2;
        Dest.y = 77*SCALEFACTOR;
        Dest.w = IMGNewGame2->w;
        SDL_BlitSurface(IMGNewGame2,NULL,Surface,&Dest);
    }

    if (Selection == 2) // = credits draw purpe
    {
        Dest.x = Surface->w/2 - IMGCredits1->w/2;
        Dest.y = 115*SCALEFACTOR;
        Dest.w = IMGCredits1->w;
        SDL_BlitSurface(IMGCredits1,NULL,Surface,&Dest);
    }
    else // blue
    {
        Dest.x = Surface->w/2 - IMGCredits2->w/2;
        Dest.y = 115*SCALEFACTOR;
        Dest.w = IMGCredits2->w;
        SDL_BlitSurface(IMGCredits2,NULL,Surface,&Dest);
    }


    if (Selection == 3) // = quit draw purple
    {
        Dest.x = Surface->w/2 - IMGQuit1->w/2;
        Dest.y = 155*SCALEFACTOR;
        Dest.w = IMGQuit1->w;
        SDL_BlitSurface(IMGQuit1,NULL,Surface,&Dest);
    }
    else // draw blue
    {
        Dest.x = Surface->w/2 - IMGQuit2->w/2;
        Dest.y = 155*SCALEFACTOR;
        Dest.w = IMGQuit2->w;
        SDL_BlitSurface(IMGQuit2,NULL,Surface,&Dest);
    }

}

//constructor of boardparts, we start with 0 items
CBoardParts::CBoardParts()
{
	ItemCount = 0;
}

// returns a boardpart if it's found with the same coordinate otherwise return null
CBoardPart* CBoardParts::GetPart(const int PlayFieldXin,const int PlayFieldYin)
{
    int Teller;
    for (Teller=0;Teller < ItemCount;Teller++)
        if((Items[Teller]->GetPlayFieldX() == PlayFieldXin) && (Items[Teller]->GetPlayFieldY() == PlayFieldYin))
            return Items[Teller];
    return NULL;
}

// Remove all board parts
void CBoardParts::RemoveAll()
{
	int Teller;
	for (Teller=0;Teller<ItemCount;Teller++)
	{
		delete Items[Teller];
		Items[Teller] = NULL;
	}
	ItemCount=0;
}

// Add a partboart, and set the boardparts parentlist to this (class/instance)
void CBoardParts::Add(CBoardPart *BoardPart)
{
	if( ItemCount < NrOfRows*NrOfCols*3 )
	{
		BoardPart->ParentList = this;
		Items[ItemCount] = BoardPart;
		ItemCount++;
	}
}

// draw all boarparts
void CBoardParts::Draw(SDL_Surface *Surface)
{
	int Teller;
	for (Teller=0;Teller<ItemCount;Teller++)
		Items[Teller]->Draw(Surface);
}

// destuctor does the same as remove all
CBoardParts::~CBoardParts()
{
	int Teller;
	for (Teller=0;Teller<ItemCount;Teller++)
	{
		delete Items[Teller];
		Items[Teller] = NULL;
	}
}

//-------------------------------------------------------------------------------------------------------------------
// Variables used in the game
CBoardParts BoardParts; // boardparts instance that will hold all the boardparts
GameStates GameState = GSTitleScreen; // the game state
TTF_Font *font,*bigfont;
SDL_Joystick *Joystick;
bool GlobalSoundEnabled = true,TvOutMode=false; // used to see if the sound was opened succesfully
Mix_Music *Music; // the music
SDL_Surface *Buffer,*Buffer1,*SDLScreen; // the screen and buffer surface, buffer is used since hardware drawing will be used
int Moves=0,Volume = 128,StartScreenX=0,StartScreenY=0,InitialStartScreenX=20,InitialStartScreenY=24;
int BestPegsLeft[4]; // array that holds the best amount of pegs left for each difficulty



// procedure i made to draw some text on the screen
void WriteText(SDL_Surface* Surface,TTF_Font* FontIn,char* Tekst,int NrOfChars,int X,int Y,int YSpacing,SDL_Color ColorIn)
{
	char List[100][255];
	int Lines,Teller,Chars;
	SDL_Rect DstRect;
	SDL_Surface* TmpSurface1,*TmpSurface2;
	Lines = 0;
	Chars = 0;
	for (Teller=0;Teller<NrOfChars;Teller++)
	{
		if(Lines > 100)
			break;
		if((Tekst[Teller] == '\n') || (Chars==255))
		{
			List[Lines][Chars]='\0';
			Lines++;
			Chars = 0;
		}
		else
		{
		 	List[Lines][Chars]=Tekst[Teller];
		 	Chars++;
		}
	}
	List[Lines][Chars] = '\0';
	for (Teller=0;Teller <= Lines;Teller++)
	{
		if(strlen(List[Teller]) > 0)
		{
			TmpSurface1 = TTF_RenderText_Blended(FontIn,List[Teller],ColorIn);
			DstRect.x = X;
			DstRect.y = Y + (Teller) * TTF_FontLineSkip(FontIn) + (Teller*YSpacing);
			DstRect.w = TmpSurface1->w;
			DstRect.h = TmpSurface1->h;
			SDL_BlitSurface(TmpSurface1,NULL,Surface,&DstRect);
			SDL_FreeSurface(TmpSurface1);
		}
	}
}

// set the volume of the music and both channels (left/right)
void SetVolume(const int VolumeIn)
{
	Mix_Volume(0,VolumeIn);
	Mix_Volume(1,VolumeIn);
	Mix_VolumeMusic(VolumeIn);
}

// increase the volume with 8
void IncVolume()
{
	if (Volume < 128)
	{
		Volume += 8;
		SetVolume(Volume);
	}
}

// decrease the volume with 8
void DecVolume()
{
	if (Volume > 0)
	{
		Volume-= 8;
		SetVolume(Volume);
	}
}

// procedure that calculates how many moves are possible in the current board state
// we can simply do this by checking all parts and see if they can move to all directions
// the canmoveto method in CPegs is does all the checking
int MovesLeft()
{
    CBoardPart *BoardPart ;
    int TmpMoves=0,Y,X;
    for (Y=0;Y<NrOfRows;Y++)
        for (X=0;X<NrOfCols;X++)
        {
            BoardPart = BoardParts.GetPart(X,Y);
            // if there is a boardpart on that X,Y Coordinate
            // check all direction if we can move to that if so increases the movesleft
            if (BoardPart)
            {
                if (BoardPart->CanMoveTo(X+2,Y,false))
                    TmpMoves++;
                if (BoardPart->CanMoveTo(X-2,Y,false))
                    TmpMoves++;
                if (BoardPart->CanMoveTo(X,Y-2,false))
                    TmpMoves++;
                if (BoardPart->CanMoveTo(X,Y+2,false))
                    TmpMoves++;
                if (BoardPart->CanMoveTo(X+2,Y-2,false))
                    TmpMoves++;
                if (BoardPart->CanMoveTo(X+2,Y+2,false))
                    TmpMoves++;
                if (BoardPart->CanMoveTo(X-2,Y+2,false))
                    TmpMoves++;
                if (BoardPart->CanMoveTo(X-2,Y-2,false))
                    TmpMoves++;
            }
        }
    return TmpMoves;
}

// Procedure that counts how many pegs are left on the board (animphase must be lower then 2 io a red or blue peg)
int PegsLeft()
{
    CBoardPart *BoardPart ;
    int Pegs=0,Y,X;
    for (Y=0;Y<NrOfRows;Y++)
        for (X=0;X<NrOfCols;X++)
        {
            BoardPart = BoardParts.GetPart(X,Y);
            if (BoardPart)
                if ((BoardPart->GetType() == IDPeg) && (BoardPart->GetAnimPhase() < 2))
                    Pegs++;
        }
    return Pegs;
}

// procedure that draws the board, boardparts info and a boxed message over the playfield
// and waits till the A button is pressed

void PrintForm(char *msg)
{
    SDL_Event Event;
    SDL_Rect Rect;
    char Msg[300];
    SDL_Color Color = {50,50,250,0};
    SDL_Color Color1 ={0,0,0,0};
    SDL_PollEvent(&Event);
    Rect.w = Buffer->w;
    Rect.h = Buffer->h;
    Rect.x = StartScreenX;
    Rect.y = StartScreenY;
	SDL_BlitSurface(IMGBackground,NULL,Buffer,NULL);
    sprintf(Msg,"Moves Left:%d",MovesLeft());
    WriteText(Buffer,font,Msg,strlen(Msg),242*SCALEFACTOR,37*SCALEFACTOR,0,Color1);
    sprintf(Msg,"Moves:%d",Moves);
    WriteText(Buffer,font,Msg,strlen(Msg),242*SCALEFACTOR,53*SCALEFACTOR,0,Color1);
    sprintf(Msg,"Pegs Left:%d",PegsLeft());
    WriteText(Buffer,font,Msg,strlen(Msg),242*SCALEFACTOR,69*SCALEFACTOR,0,Color1);
    if (BestPegsLeft[Difficulty] != 0)
    {
        sprintf(Msg,"Best Pegs:%d",BestPegsLeft[Difficulty]);
        WriteText(Buffer,font,Msg,strlen(Msg),242*SCALEFACTOR,85*SCALEFACTOR,0,Color1);
    }
	BoardParts.Draw(Buffer);
	boxRGBA(Buffer,16*SCALEFACTOR,80*SCALEFACTOR,221*SCALEFACTOR,160*SCALEFACTOR,152,152,255,255);
	rectangleRGBA(Buffer,16*SCALEFACTOR,80*SCALEFACTOR,221*SCALEFACTOR,160*SCALEFACTOR,50,50,255,255);
	rectangleRGBA(Buffer,17*SCALEFACTOR,81*SCALEFACTOR,220*SCALEFACTOR,159*SCALEFACTOR,50,50,255,255);
	WriteText(Buffer,font,msg,strlen(msg),21*SCALEFACTOR,85*SCALEFACTOR,2,Color);
	SDL_FillRect(Buffer1,NULL,SDL_MapRGB(Buffer1->format,0,0,0));
    SDL_BlitSurface(Buffer,NULL,Buffer1,&Rect);
    SDL_BlitSurface(Buffer1,NULL,SDLScreen,NULL);
    SDL_Flip(SDLScreen);
	SDL_PollEvent(&Event);
	{
		while (!((Event.type == SDL_MOUSEBUTTONUP) || (Event.type == SDL_KEYUP) ))
		{
			SDL_PollEvent(&Event);
		}
	}
}

// Loads the sounds in the sound array
void LoadSounds()
{
    char FileName[PATH_MAX+FILENAME_MAX];
	if (GlobalSoundEnabled)
	{
	    sprintf(FileName,"%ssound/start.wav",StartPath);
		Sounds[SND_START] = Mix_LoadWAV(FileName);
		sprintf(FileName,"%ssound/select.wav",StartPath);
		Sounds[SND_SELECT] = Mix_LoadWAV(FileName);
		sprintf(FileName,"%ssound/good.wav",StartPath);
		Sounds[SND_GOOD] = Mix_LoadWAV(FileName);
		sprintf(FileName,"%ssound/wrong.wav",StartPath);
		Sounds[SND_WRONG] = Mix_LoadWAV(FileName);
		sprintf(FileName,"%ssound/winner.wav",StartPath);
		Sounds[SND_WINNER] = Mix_LoadWAV(FileName);
		sprintf(FileName,"%ssound/loser.wav",StartPath);
		Sounds[SND_LOSER] = Mix_LoadWAV(FileName);
		sprintf(FileName,"%smusic/rubido.mod",StartPath);
		Music = Mix_LoadMUS(FileName);
	}
}

// unloads the sounds
void UnloadSounds()
{
	Mix_HaltMusic();
	int Teller;
	for (Teller=0;Teller<NrOfSounds;Teller++)
		if(Sounds[Teller])
			Mix_FreeChunk(Sounds[Teller]);
    Mix_FreeMusic(Music);
}

void LoadGraphics()
{
    char FileName[PATH_MAX+FILENAME_MAX];
    SDL_Surface *Tmp,*Tmp2;

    sprintf(FileName,"%sgraphics/background.png",StartPath);

    Tmp = IMG_Load(FileName);
    Tmp2 = ScaleSurface(Tmp,SCALEFACTOR);
    IMGBackground = SDL_DisplayFormat(Tmp2); // optimize image for screen
    SDL_FreeSurface(Tmp);
    SDL_FreeSurface(Tmp2);

    sprintf(FileName,"%sgraphics/peg.png",StartPath);
    Tmp = IMG_Load(FileName);
    Tmp2 = ScaleSurface(Tmp,SCALEFACTOR);
    IMGPeg = SDL_DisplayFormat(Tmp2); // optimize image for screen
    SDL_FreeSurface(Tmp);
    SDL_FreeSurface(Tmp2);

}

void UnLoadGraphics()
{
    if(IMGBackground)
        SDL_FreeSurface(IMGBackground);
    if(IMGPeg)
        SDL_FreeSurface(IMGPeg);
}

// this will ceate the initial board state, io a cross of pegs, with the middle on being empty (=animphase 6)
void InitBoard()
{
    int X,Y;
    for (Y=0;Y < NrOfRows;Y++)
        for (X=0;X < NrOfCols;X++)
        {
            if ((Y < 3) && (X > 2) && (X < 6))
                BoardParts.Add(new CPeg(X,Y));
             if ((Y > 2) && (Y <6))
                BoardParts.Add(new CPeg(X,Y));
            if ((Y > 5) && (X > 2) && (X <6))
                BoardParts.Add(new CPeg(X,Y));
        }
     BoardParts.GetPart(4,4)->SetAnimPhase(6);

}

// Checks if we won the game
bool IsWinningGame()
{
    if (PegsLeft() == 1) //must be 1 peg left
    {
        if ((Difficulty == VeryHard) || (Difficulty == Easy))
        {
            if(BoardParts.GetPart(4,4)->GetAnimPhase() < 2) // must be in the middle with veryhard or easy
                return true;
            else
                return false;
        }
        else
            return true;
    }
    else
        return false;
}

// The main Game Loop
void Game()
{
    SDL_Event Event;
    SDL_Rect Rect;
    SDL_Color Color1 = {0,0,0,255};
    //Uint32 start=0,end=0,fpscounter=0,fps=0;
    CPeg *tmpPeg ;
    CSelector *Selector;
    Selector = new CSelector(4,4);
    //char debug[100];
    char Msg[300];
    InitBoard();
    Moves = 0;
    if (GlobalSoundEnabled)
        Mix_PlayChannel(-1,Sounds[SND_START],0);
    Rect.w = Buffer->w;
    Rect.h = Buffer->h;
    Rect.x = StartScreenX;
    Rect.y = StartScreenY;
    while (GameState == GSGame)
    {
        SDL_BlitSurface(IMGBackground,NULL,Buffer,NULL);
       // sprintf(debug,"fps : %d",fps);
       // WriteText(Buffer,font,debug,strlen(debug),0,0,0,Color1);

      // Write some info to the screen
        sprintf(Msg,"Moves Left:%d",MovesLeft());
        WriteText(Buffer,font,Msg,strlen(Msg),242*SCALEFACTOR,37*SCALEFACTOR,0,Color1);
        sprintf(Msg,"Moves:%d",Moves);
        WriteText(Buffer,font,Msg,strlen(Msg),242*SCALEFACTOR,53*SCALEFACTOR,0,Color1);
        sprintf(Msg,"Pegs Left:%d",PegsLeft());
        WriteText(Buffer,font,Msg,strlen(Msg),242*SCALEFACTOR,69*SCALEFACTOR,0,Color1);
        // Only show best pegs if it isn't 0
        if (BestPegsLeft[Difficulty] != 0)
        {
            sprintf(Msg,"Best Pegs:%d",BestPegsLeft[Difficulty]);
            WriteText(Buffer,font,Msg,strlen(Msg),242*SCALEFACTOR,85*SCALEFACTOR,0,Color1);
        }
        sprintf(Msg,"QUIT");
        WriteText(Buffer,bigfont,Msg,strlen(Msg),242*SCALEFACTOR,200*SCALEFACTOR,0,Color1);

        BoardParts.Draw(Buffer);
        Selector->Draw(Buffer);
        SDL_FillRect(Buffer1,NULL,SDL_MapRGB(Buffer1->format,0,0,0));
        SDL_BlitSurface(Buffer,NULL,Buffer1,&Rect);
        SDL_BlitSurface(Buffer1,NULL,SDLScreen,NULL);
        SDL_Flip(SDLScreen);
        while (SDL_PollEvent(&Event))
        {
            if (Event.type == SDL_QUIT)
                GameState=GSQuit;

            if (Event.type == SDL_MOUSEBUTTONUP)
            {
                if ((Event.button.x -StartScreenX> 240*SCALEFACTOR) && (Event.button.x -StartScreenX < 290*SCALEFACTOR) &&
                     (Event.button.y -StartScreenY> 200*SCALEFACTOR) && (Event.button.y -StartScreenY< 230*SCALEFACTOR))
                        GameState = GSTitleScreen;

                WriteText(Buffer,bigfont,Msg,strlen(Msg),242*SCALEFACTOR,200*SCALEFACTOR,0,Color1);
                Selector->SetPosition( (Event.button.x - XOffSet -StartScreenX) / TileWidth, (Event.button.y - YOffSet - StartScreenY) / TileHeight);
                if (Selector->HasSelection) // if we have a selection
                {
                    // see if the selected boardpart can move to the current position
                    if (BoardParts.GetPart(Selector->GetSelection().X,Selector->GetSelection().Y)->CanMoveTo(Selector->GetPosition().X,Selector->GetPosition().Y,true))
                    {
                        if (GlobalSoundEnabled)
                            Mix_PlayChannel(-1,Sounds[SND_GOOD],0);
                        //if so play a sound, increase the moves, set the selected part to empty and the current part to red
                        Moves++;
                        BoardParts.GetPart(Selector->GetSelection().X,Selector->GetSelection().Y)->SetAnimPhase(6);
                        BoardParts.GetPart(Selector->GetPosition().X,Selector->GetPosition().Y)->SetAnimPhase(0);
                        // if no moves are left see if the best pegs left value for the current difficulty is
                        // greater if so set te new value
                        if (MovesLeft() == 0)
                        {
                            if (BestPegsLeft[Difficulty] != 0)
                            {
                                if (PegsLeft() < BestPegsLeft[Difficulty])
                                    BestPegsLeft[Difficulty] = PegsLeft();
                            }
                            else
                                BestPegsLeft[Difficulty] = PegsLeft();
                            // if it's the winning game play the winning sound and show the form with the winning message
                            if (IsWinningGame())
                            {
                                if (GlobalSoundEnabled)
                                    Mix_PlayChannel(-1,Sounds[SND_WINNER],0);
                                sprintf(Msg,"Congratulations you have solved\nthe puzzle! Try a new difficulty!\n\nPress to continue");
                                PrintForm(Msg);// this will not return until A has been pressed
                                GameState=GSTitleScreen;
                            }
                            else // show the loser messager, play loser sound
                            {
                                if (GlobalSoundEnabled)
                                    Mix_PlayChannel(-1,Sounds[SND_LOSER],0);
                                sprintf(Msg,"You could not solve the puzzle!\nDon't give up, try it again!\n\nPress to continue");
                                PrintForm(Msg); // this will not return until A has been pressed
                                GameState=GSTitleScreen;
                            }
                            // stop the music
                            Mix_HaltChannel(-1);
                        }

                    }
                    else // if we can't move to the spot, play the wrong move sound, and reset the selection to a red peg (instead of blue / selected)
                    {
                        BoardParts.GetPart(Selector->GetSelection().X,Selector->GetSelection().Y)->SetAnimPhase(0);
                        if (GlobalSoundEnabled)
                            Mix_PlayChannel(-1,Sounds[SND_WRONG],0);
                    }
                    Selector->DeSelect(); // deselect the selection
                }
                else // we didn't have a selection, set the new selection
                {
                    if (BoardParts.GetPart(Selector->GetPosition().X,Selector->GetPosition().Y)->GetAnimPhase() == 0)
                    {
                        if (GlobalSoundEnabled)
                            Mix_PlayChannel(-1,Sounds[SND_SELECT],0);
                        BoardParts.GetPart(Selector->GetPosition().X,Selector->GetPosition().Y)->SetAnimPhase(1);
                        Selector->Select();
                    }

                }
            }

            if (Event.type == SDL_KEYDOWN)
            {
                switch(Event.key.keysym.sym)
                {
                    case SDLK_PLUS:
						IncVolume();
						break;
					case SDLK_MINUS:
						DecVolume();
						break;
                    case SDLK_LEFT: // move the selector to the left io currentposition.x - 1
                        Selector->SetPosition(Selector->GetPosition().X -1,Selector->GetPosition().Y);
                        break;
                    case SDLK_RIGHT:
                        Selector->SetPosition(Selector->GetPosition().X +1,Selector->GetPosition().Y);
                        break;
                    case SDLK_UP:
                        Selector->SetPosition(Selector->GetPosition().X,Selector->GetPosition().Y-1);
                        break;
                    case SDLK_DOWN:
                        Selector->SetPosition(Selector->GetPosition().X,Selector->GetPosition().Y+1);
                        break;
                    case SDLK_SPACE: // deselect selection
                        if (Selector->HasSelection)
                        {
                            BoardParts.GetPart(Selector->GetSelection().X,Selector->GetSelection().Y)->SetAnimPhase(0);
                            Selector->DeSelect();
                        }
                        break;
                    case SDLK_ESCAPE: // select = quit to title
                        Mix_HaltChannel(-1);
                        GameState = GSTitleScreen;
                        break;
                    case SDLK_RETURN:
                        if (Selector->HasSelection) // if we have a selection
                        {
                            // see if the selected boardpart can move to the current position
                            if (BoardParts.GetPart(Selector->GetSelection().X,Selector->GetSelection().Y)->CanMoveTo(Selector->GetPosition().X,Selector->GetPosition().Y,true))
                            {
                                if (GlobalSoundEnabled)
                                    Mix_PlayChannel(-1,Sounds[SND_GOOD],0);
                                //if so play a sound, increase the moves, set the selected part to empty and the current part to red
                                Moves++;
                                BoardParts.GetPart(Selector->GetSelection().X,Selector->GetSelection().Y)->SetAnimPhase(6);
                                BoardParts.GetPart(Selector->GetPosition().X,Selector->GetPosition().Y)->SetAnimPhase(0);
                                // if no moves are left see if the best pegs left value for the current difficulty is
                                // greater if so set te new value
                                if (MovesLeft() == 0)
                                {
                                    if (BestPegsLeft[Difficulty] != 0)
                                    {
                                        if (PegsLeft() < BestPegsLeft[Difficulty])
                                            BestPegsLeft[Difficulty] = PegsLeft();
                                    }
                                    else
                                        BestPegsLeft[Difficulty] = PegsLeft();
                                    // if it's the winning game play the winning sound and show the form with the winning message
                                    if (IsWinningGame())
                                    {
                                        if (GlobalSoundEnabled)
                                            Mix_PlayChannel(-1,Sounds[SND_WINNER],0);
                                        sprintf(Msg,"Congratulations you have solved\nthe puzzle! Try a new difficulty!\n\nPress to continue");
                                        PrintForm(Msg);// this will not return until A has been pressed
                                        GameState=GSTitleScreen;
                                    }
                                    else // show the loser messager, play loser sound
                                    {
                                        if (GlobalSoundEnabled)
                                            Mix_PlayChannel(-1,Sounds[SND_LOSER],0);
                                        sprintf(Msg,"You could not solve the puzzle!\nDon't give up, try it again!\n\nPress to continue");
                                        PrintForm(Msg); // this will not return until A has been pressed
                                        GameState=GSTitleScreen;
                                    }
                                    // stop the music
                                    Mix_HaltChannel(-1);
                                }

                            }
                            else // if we can't move to the spot, play the wrong move sound, and reset the selection to a red peg (instead of blue / selected)
                            {
                                BoardParts.GetPart(Selector->GetSelection().X,Selector->GetSelection().Y)->SetAnimPhase(0);
                                if (GlobalSoundEnabled)
                                    Mix_PlayChannel(-1,Sounds[SND_WRONG],0);
                            }
                            Selector->DeSelect(); // deselect the selection
                        }
                        else // we didn't have a selection, set the new selection
                        {
                            if (BoardParts.GetPart(Selector->GetPosition().X,Selector->GetPosition().Y)->GetAnimPhase() == 0)
                            {
                                if (GlobalSoundEnabled)
                                    Mix_PlayChannel(-1,Sounds[SND_SELECT],0);
                                BoardParts.GetPart(Selector->GetPosition().X,Selector->GetPosition().Y)->SetAnimPhase(1);
                                Selector->Select();
                            }

                        }
                        break;
                    default:
                        break;
                }
            }
        }
      /*  fpscounter++;
        if (SDL_GetTicks() - start >=1000)
        {
            fps = fpscounter;
            fpscounter = 0;
            start = SDL_GetTicks();
        }
        */
    }
    // when the game has finished we remove all board parts
    BoardParts.RemoveAll();
    delete Selector;
}

// main title screen loop
void TitleScreen()
{
    SDL_Event Event;
    SDL_Rect Rect;
    bool RPressed=false;
    CMainMenu *Menu = new CMainMenu();
    // if a music hasn't started start the music in an endless loop (-1 as last parameter)
    if (GlobalSoundEnabled)
    {
        if (!Mix_PlayingMusic())
            Mix_PlayMusic(Music,-1);
    }
    while (GameState == GSTitleScreen)
    {
        while (SDL_PollEvent(&Event))
        {
            if (Event.type == SDL_MOUSEBUTTONUP)
            {
                switch(Menu->GetMouseSelection(Event.button.x-StartScreenX,Event.button.y-StartScreenY,Buffer))
                {
                    case 1:
                        GameState = GSDifficultySelect;
                        break;
                    case 2:
                        GameState = GSCredits;
                        break;
                    case 3:
                        GameState = GSQuit;
                        break;
                }
            }

            if (Event.type == SDL_QUIT)
                GameState=GSQuit;

            if (Event.type == SDL_KEYDOWN)
            {
                switch (Event.key.keysym.sym)
                {
                    case SDLK_PLUS:
						IncVolume();
						break;
					case SDLK_MINUS:
						DecVolume();
						break;
                    case SDLK_DOWN:
                        Menu->NextItem();
                        break;
                    case SDLK_UP:
                        Menu->PreviousItem();
                        break;
                    case SDLK_RETURN:
                        // set the gamestate according to the menu selection
                        Mix_PlayChannel(-1,Sounds[SND_GOOD],0);
                        switch(Menu->GetSelection())
                        {
                            case 1:
                                GameState = GSDifficultySelect;
                                break;
                            case 2:
                                GameState = GSCredits;
                             break;
                            case 3:
                                GameState = GSQuit;
                        }
                        break;
                    case SDLK_ESCAPE:
                        GameState = GSQuit;
                        break;
                    default:
                        break;
                }
            }
        }
        Menu->Draw(Buffer);
        Rect.w = Buffer->w;
        Rect.h = Buffer->h;
        Rect.x = StartScreenX;
        Rect.y = StartScreenY;
        SDL_FillRect(Buffer1,NULL,SDL_MapRGB(Buffer1->format,0,0,0));
        SDL_BlitSurface(Buffer,NULL,Buffer1,&Rect);
        SDL_BlitSurface(Buffer1,NULL,SDLScreen,NULL);
        SDL_Flip(SDLScreen);
    }
    delete Menu;
}

// Main difficulty select loop
void DifficultySelect()
{
    SDL_Surface *Tmp,*Tmp2,*IMGVeryEasy1,*IMGEasy1,*IMGHard1,*IMGVeryHard1,*IMGEasyInfo,*IMGVeryEasyInfo,*IMGHardInfo,*IMGVeryHardInfo;
    SDL_Event Event;
    SDL_Rect Dest,Rect;
    SDL_Color color = {255,255,255,255};
    char Text[512];
    char FileName[PATH_MAX+FILENAME_MAX];

    // Load the images
    sprintf(FileName,"%sgraphics/infoveryeasy.png",StartPath);
    Tmp = IMG_Load(FileName);
    Tmp2 = ScaleSurface(Tmp,SCALEFACTOR);
    IMGVeryEasyInfo = SDL_DisplayFormat(Tmp2);
    SDL_FreeSurface(Tmp);
    SDL_FreeSurface(Tmp2);

    sprintf(FileName,"%sgraphics/infoeasy.png",StartPath);
    Tmp = IMG_Load(FileName);
    Tmp2 = ScaleSurface(Tmp,SCALEFACTOR);
    IMGEasyInfo = SDL_DisplayFormat(Tmp2);
    SDL_FreeSurface(Tmp);
    SDL_FreeSurface(Tmp2);

    sprintf(FileName,"%sgraphics/infohard.png",StartPath);
    Tmp = IMG_Load(FileName);
    Tmp2 = ScaleSurface(Tmp,SCALEFACTOR);
    IMGHardInfo = SDL_DisplayFormat(Tmp2);
    SDL_FreeSurface(Tmp);
    SDL_FreeSurface(Tmp2);

    sprintf(FileName,"%sgraphics/infoveryhard.png",StartPath);
    Tmp = IMG_Load(FileName);
    Tmp2 = ScaleSurface(Tmp,SCALEFACTOR);
    IMGVeryHardInfo = SDL_DisplayFormat(Tmp2);
    SDL_FreeSurface(Tmp);
    SDL_FreeSurface(Tmp2);

    sprintf(FileName,"%sgraphics/veryeasy1.png",StartPath);
    Tmp = IMG_Load(FileName);
    Tmp2 = ScaleSurface(Tmp,SCALEFACTOR);
    IMGVeryEasy1 = SDL_DisplayFormat(Tmp2);
    SDL_SetColorKey(IMGVeryEasy1,(SDL_SRCCOLORKEY|SDL_RLEACCEL),SDL_MapRGB(IMGVeryEasy1->format,255,0,255));
    SDL_FreeSurface(Tmp);
    SDL_FreeSurface(Tmp2);

    sprintf(FileName,"%sgraphics/easy1.png",StartPath);
    Tmp = IMG_Load(FileName);
    Tmp2 = ScaleSurface(Tmp,SCALEFACTOR);
    IMGEasy1 = SDL_DisplayFormat(Tmp2);
    SDL_SetColorKey(IMGEasy1,(SDL_SRCCOLORKEY|SDL_RLEACCEL),SDL_MapRGB(IMGEasy1->format,255,0,255));
    SDL_FreeSurface(Tmp);
    SDL_FreeSurface(Tmp2);

    sprintf(FileName,"%sgraphics/hard1.png",StartPath);
    Tmp = IMG_Load(FileName);
    Tmp2 = ScaleSurface(Tmp,SCALEFACTOR);
    IMGHard1 = SDL_DisplayFormat(Tmp2);
    SDL_SetColorKey(IMGHard1,(SDL_SRCCOLORKEY|SDL_RLEACCEL),SDL_MapRGB(IMGHard1->format,255,0,255));
    SDL_FreeSurface(Tmp);
    SDL_FreeSurface(Tmp2);

    sprintf(FileName,"%sgraphics/veryhard1.png",StartPath);
    Tmp = IMG_Load(FileName);
    Tmp2 = ScaleSurface(Tmp,SCALEFACTOR);
    IMGVeryHard1 = SDL_DisplayFormat(Tmp2);
    SDL_SetColorKey(IMGVeryHard1,(SDL_SRCCOLORKEY|SDL_RLEACCEL),SDL_MapRGB(IMGVeryHard1->format,255,0,255));
    SDL_FreeSurface(Tmp);
    SDL_FreeSurface(Tmp2);

    Rect.w = Buffer->w;
    Rect.h = Buffer->h;
    Rect.x = StartScreenX;
    Rect.y = StartScreenY;
    while (GameState == GSDifficultySelect)
    {
        while (SDL_PollEvent(&Event))
        {
            if (Event.type == SDL_QUIT)
                GameState=GSQuit;

            if (Event.type == SDL_MOUSEBUTTONUP)
            {
                if((Event.button.x - StartScreenX>13*SCALEFACTOR) && (Event.button.x - StartScreenX< 313*SCALEFACTOR) &&
                   (Event.button.y - StartScreenY> 34*SCALEFACTOR) && (Event.button.y - StartScreenY< 64*SCALEFACTOR))
                    if(Difficulty == VeryEasy)
                    {
                        Difficulty = Easy;
                    }
                    else
                        if(Difficulty == Easy)
                        {
                            Difficulty = Hard;
                        }
                        else
                            if(Difficulty == Hard)
                            {
                                Difficulty = VeryHard;
                            }
                            else
                                if(Difficulty == VeryHard)
                                    Difficulty = VeryEasy;

                if((Event.button.x - StartScreenX> 128*SCALEFACTOR) && (Event.button.x - StartScreenX< 196*SCALEFACTOR) &&
                   (Event.button.y - StartScreenY> 127*SCALEFACTOR) && (Event.button.y - StartScreenY< 151*SCALEFACTOR))
                    GameState = GSGame;
            }


            if (Event.type == SDL_KEYDOWN)
                switch (Event.key.keysym.sym)
                {
                    case SDLK_PLUS:
						IncVolume();
						break;
					case SDLK_MINUS:
						DecVolume();
						break;
                    case SDLK_ESCAPE:
                        GameState = GSTitleScreen;
                        break;
                    case SDLK_RETURN:
                        GameState = GSGame;
                        break;
                    case SDLK_LEFT: // Change difficluly one lower if we pressed left
                        if(Difficulty == VeryHard)
                        {
                            Difficulty = Hard;
                        }
                        else
                            if(Difficulty == Hard)
                            {
                                Difficulty = Easy;
                            }
                            else
                                if(Difficulty == Easy)
                                {
                                    Difficulty = VeryEasy;
                                }
                                else
                                    if(Difficulty == VeryEasy)
                                        Difficulty = VeryHard;
                        break;
                    case SDLK_RIGHT: // change difficulty one higher
                        if(Difficulty == VeryEasy)
                        {
                            Difficulty = Easy;
                        }
                        else
                            if(Difficulty == Easy)
                            {
                                Difficulty = Hard;
                            }
                            else
                                if(Difficulty == Hard)
                                {
                                    Difficulty = VeryHard;
                                }
                                else
                                    if(Difficulty == VeryHard)
                                        Difficulty = VeryEasy;
                        break;
                    default:
                        break;
                }
        }
        // decide what we draw to the buffer based on the difficuly
        switch(Difficulty)
        {
            case VeryEasy:
                SDL_BlitSurface(IMGVeryEasyInfo,NULL,Buffer,NULL);
                Dest.x = Buffer->w/2 - IMGVeryEasy1->w/2;
                Dest.y = 35*SCALEFACTOR;
                Dest.w = IMGVeryEasy1->w;
                SDL_BlitSurface(IMGVeryEasy1,NULL,Buffer,&Dest);
                break;
            case Easy:
                SDL_BlitSurface(IMGEasyInfo,NULL,Buffer,NULL);
                Dest.x = Buffer->w/2 - IMGEasy1->w/2;
                Dest.y = 35*SCALEFACTOR;
                Dest.w = IMGEasy1->w;
                SDL_BlitSurface(IMGEasy1,NULL,Buffer,&Dest);
                break;
            case Hard:
                SDL_BlitSurface(IMGHardInfo,NULL,Buffer,NULL);
                Dest.x = Buffer->w/2 - IMGHard1->w/2;
                Dest.y = 35*SCALEFACTOR;
                Dest.w = IMGHard1->w;
                SDL_BlitSurface(IMGHard1,NULL,Buffer,&Dest);
                break;
            case VeryHard:
                SDL_BlitSurface(IMGVeryHardInfo,NULL,Buffer,NULL);
                Dest.x = Buffer->w/2 - IMGVeryHard1->w/2;
                Dest.y = 35*SCALEFACTOR;
                Dest.w = IMGVeryHard1->w;
                SDL_BlitSurface(IMGVeryHard1,NULL,Buffer,&Dest);
                break;

        }
        sprintf(Text,"PLAY");
        WriteText(Buffer,bigfont,Text,strlen(Text),138*SCALEFACTOR,127*SCALEFACTOR,0,color);
        // blit the buffer to the screen and flip the screen
        SDL_FillRect(Buffer1,NULL,SDL_MapRGB(Buffer1->format,0,0,0));
        SDL_BlitSurface(Buffer,NULL,Buffer1,&Rect);
        SDL_BlitSurface(Buffer1,NULL,SDLScreen,NULL);
        SDL_Flip(SDLScreen);
    }
    // Unload the images
    SDL_FreeSurface(IMGVeryEasy1);
    SDL_FreeSurface(IMGEasy1);
    SDL_FreeSurface(IMGHard1);
    SDL_FreeSurface(IMGVeryHard1);
    SDL_FreeSurface(IMGVeryEasyInfo);
    SDL_FreeSurface(IMGEasyInfo);
    SDL_FreeSurface(IMGHardInfo);
    SDL_FreeSurface(IMGVeryHardInfo);
}

// Load the settings, if there isn't a settings file, set some initial values
void LoadSettings()
{
 	FILE *SettingsFile;
 	char Filename[PATH_MAX+FILENAME_MAX];
 	int Value=1;
 	sprintf(Filename,"%s/.rubidosettings.dat",getenv("HOME"));
 	SettingsFile = fopen(Filename,"r");
 	if(SettingsFile)
 	{
		fscanf(SettingsFile,"Volume=%d\n",&Volume);
		SetVolume(Volume);
		fscanf(SettingsFile,"Best0=%d\n",&BestPegsLeft[VeryEasy]);
		fscanf(SettingsFile,"Best1=%d\n",&BestPegsLeft[Easy]);
		fscanf(SettingsFile,"Best2=%d\n",&BestPegsLeft[Hard]);
		fscanf(SettingsFile,"Best3=%d\n",&BestPegsLeft[VeryHard]);
        fscanf(SettingsFile,"StartScreenX=%d\n",&StartScreenX);
        fscanf(SettingsFile,"StartScreenY=%d\n",&StartScreenY);
		fclose(SettingsFile);
 	}
 	else
 	{
		SetVolume(128);
		BestPegsLeft[VeryEasy] = 0;
		BestPegsLeft[Easy] = 0;
		BestPegsLeft[Hard] = 0;
		BestPegsLeft[VeryHard] = 0;
		StartScreenX = (SDLScreen->w - Buffer->w) / 2;
        StartScreenY = (SDLScreen->h - Buffer->h) / 2;
	}
}

// Save the settings
void SaveSettings()
{
 	FILE *SettingsFile;
 	char Filename[PATH_MAX+FILENAME_MAX];
 	sprintf(Filename,"%s/.rubidosettings.dat",getenv("HOME"));
 	SettingsFile = fopen(Filename,"w");
 	if(SettingsFile)
 	{
		fprintf(SettingsFile,"Volume=%d\n",Volume);
		fprintf(SettingsFile,"Best0=%d\n",BestPegsLeft[VeryEasy]);
		fprintf(SettingsFile,"Best1=%d\n",BestPegsLeft[Easy]);
		fprintf(SettingsFile,"Best2=%d\n",BestPegsLeft[Hard]);
		fprintf(SettingsFile,"Best3=%d\n",BestPegsLeft[VeryHard]);
        fprintf(SettingsFile,"StartScreenX=%d\n",StartScreenX);
        fprintf(SettingsFile,"StartScreenY=%d\n",StartScreenY);
		fclose(SettingsFile);
		sync();
 	}
}

//Main Credits loop, will just show an image and wait for a button to be pressed
void Credits()
{
    SDL_Surface *Tmp,*IMGCredits,*Tmp2;
    SDL_Event Event;
    SDL_Rect Rect;
    char FileName[PATH_MAX+FILENAME_MAX];

    sprintf(FileName,"%sgraphics/credits.png",StartPath);
    Tmp = IMG_Load(FileName);
    Tmp2 = ScaleSurface(Tmp,SCALEFACTOR);
    IMGCredits = SDL_DisplayFormat(Tmp2);
    SDL_FreeSurface(Tmp);
    SDL_FreeSurface(Tmp2);

    Rect.w = Buffer->w;
    Rect.h = Buffer->h;
    Rect.x = StartScreenX;
    Rect.y = StartScreenY;
    while (GameState == GSCredits)
    {
        while (SDL_PollEvent(&Event))
        {
            if (Event.type == SDL_QUIT)
                GameState=GSQuit;

            if (Event.type == SDL_MOUSEBUTTONUP)
            {
                GameState = GSTitleScreen;
            }

            if (Event.type == SDL_KEYDOWN)
                switch (Event.jbutton.button)
                {
                    case SDLK_PLUS:
						IncVolume();
						break;
					case SDLK_MINUS:
						DecVolume();
						break;
                    default:
                        GameState = GSTitleScreen;
                        break;
                }
        }

        SDL_FillRect(Buffer1,NULL,SDL_MapRGB(Buffer1->format,0,0,0));
        SDL_BlitSurface(IMGCredits,NULL,Buffer,NULL);
        SDL_BlitSurface(Buffer,NULL,Buffer1,&Rect);
        SDL_BlitSurface(Buffer1,NULL,SDLScreen,NULL);
        SDL_Flip(SDLScreen);
    }
    SDL_FreeSurface(IMGCredits);
}

void GetFilePath(char *InputFile,char *result)
{
    int Teller,Pos=0;
    for(Teller=strlen(InputFile)-1;Teller>=0;Teller--)
        if(InputFile[Teller] == '/')
        {
            Pos = Teller+1;
            break;
        }
    memcpy(result,InputFile,Pos);
}

// Start of the program, should be obvious what happens here
int main(int argc, char **argv)
{
    putenv("SDL_VIDEO_X11_WMCLASS=rubido");
    SDL_Rect Rect;
    char title[50];
	title[49] = '\0';
    SDL_Surface *Tmp;
	char Filename[PATH_MAX+FILENAME_MAX];
	GetFilePath(argv[0],StartPath);
	printf("%s -> %s\n",argv[0],StartPath);
	if (SDL_Init(SDL_INIT_VIDEO | SDL_INIT_AUDIO ) == 0)
	{
		printf("SDL Succesfully initialized\n");
        SDLScreen = SDL_SetVideoMode( 800, 480,16, SDL_HWSURFACE | SDL_FULLSCREEN);
        if(SDLScreen)
		{
		    SDL_WM_SetCaption("Rubido","Rubido");
		    char *caption;
			SDL_WM_GetCaption(&caption, NULL);
            strncpy(title,caption,49);
            SDL_SysWMinfo info;
            SDL_VERSION(&info.version);
            if ( SDL_GetWMInfo(&info) )
            {
                Display *dpy = info.info.x11.display;
                Window win;
				win = info.info.x11.fswindow;
                XStoreName(dpy, win, title);
            }


		    printf("Succesfully Set %dx%dx16\n",800,480);
		    Tmp = SDL_CreateRGBSurface(SDL_SWSURFACE,640,480,16,SDLScreen->format->Rmask,SDLScreen->format->Gmask,SDLScreen->format->Bmask,SDLScreen->format->Amask);
			Buffer = SDL_DisplayFormat(Tmp);
			SDL_FreeSurface(Tmp);
		    Tmp = SDL_CreateRGBSurface(SDL_SWSURFACE,800,480,16,SDLScreen->format->Rmask,SDLScreen->format->Gmask,SDLScreen->format->Bmask,SDLScreen->format->Amask);
			Buffer1 = SDL_DisplayFormat(Tmp);
			SDL_FreeSurface(Tmp);
			if (Buffer && Buffer1)
			{
                printf("Succesfully Created Buffer\n");
                SDL_ShowCursor(SDL_DISABLE);
                    if (Mix_OpenAudio(22050,AUDIO_S16,MIX_DEFAULT_CHANNELS,64) < 0)
                    {
                        GlobalSoundEnabled = false;
                        printf("Failed to initialise sound!\n");
                        printf("%s\n",Mix_GetError());
                    }
                    else
                    {
                        printf("Audio Succesfully initialised!\n");
                    }
                    if (TTF_Init() == 0)
                    {
                        printf("Succesfully initialized TTF\n");
                        sprintf(Filename,"%sdata/font.ttf",StartPath);
                        font = TTF_OpenFont(Filename,15*SCALEFACTOR);
                        bigfont = TTF_OpenFont(Filename,30*SCALEFACTOR);
                        if (font && bigfont)
                        {
                            printf("Succesfully Loaded fonts\n");
                            TTF_SetFontStyle(font,TTF_STYLE_NORMAL);
                            LoadSounds();
                            LoadGraphics();
                            LoadSettings();
                            // Main game loop that loops untile the gamestate = GSQuit
                            // and calls the procedure according to the gamestate.
                            while (GameState != GSQuit)
                            {
                                switch(GameState)
                                {
                                    case GSGame :
                                        Game();
                                        break;
                                    case GSTitleScreen:
                                        TitleScreen();
                                        break;
                                    case GSDifficultySelect:
                                        DifficultySelect();
                                        break;
                                    case GSCredits:
                                        Credits();
                                        break;
                                }
                            }
                            SaveSettings();
                            UnLoadGraphics();
                            UnloadSounds();
                            Mix_CloseAudio();
                            TTF_CloseFont(font);
                            font=NULL;
                            TTF_CloseFont(bigfont);
                            bigfont=NULL;
                        }
                        else
                        {
                            printf("Failed to Load fonts\n");
                        }
                        TTF_Quit();
                    }
                    else
                    {
                        printf("Failed to initialize TTF\n");
                    }

                SDL_FreeSurface(Buffer);
                Buffer=NULL;
			}
			else
                printf("Failed To Create Buffer\n");
            SDL_FreeSurface(SDLScreen);
            SDLScreen=NULL;
		}
		else
		{
			printf("Failed to Set Videomode %dx%dx16\n",800, 600);
		}
		SDL_Quit();
	}
	else
	{
		printf("Couldn't initialise SDL!\n");
	}
	// Shouldn't be needed but i just placed it again to be sure all the boardparts are free
	BoardParts.RemoveAll();

	return 0;

}
