/*
* PeLib.h - Part of the PeLib library.
*
* Copyright (c) 2004 - 2005 Sebastian Porst (webmaster@the-interweb.com)
* All rights reserved.
*
* This software is licensed under the zlib/libpng License.
* For more details see http://www.opensource.org/licenses/zlib-license.php
* or the license information file (license.htm) in the root directory 
* of PeLib.
*/


/** \mainpage PeLib - An open-source C++ library to modify PE files.
*
* \section intro Introduction
*
* <b>What is PeLib?</b><br>
* PeLib is an open source C++ library with the purpose to ease the access and modification of PE (Portable executable) files. This is done through a multitude of classes which represent all important PE header and directory structures and which provide the necessary functions to read, modify and write these structures. As this library is fully ISO C++ compliant it should compile with all popular compilers for the Windows platform. For people who don't use C++ in their projects a dynamic link library is provided which encapsulates all of PeLib's functionality so that projects using programming languages as diverse as Win32 assembler, C# or Delphi can still benefit from PeLib's power
*/

#ifndef PELIB_H
#define PELIB_H

#include "PeFile.h"

#endif
