/***************************************************************************
 *             __________               __   ___.
 *   Open      \______   \ ____   ____ |  | _\_ |__   _______  ___
 *   Source     |       _//  _ \_/ ___\|  |/ /| __ \ /  _ \  \/  /
 *   Jukebox    |    |   (  <_> )  \___|    < | \_\ (  <_> > <  <
 *   Firmware   |____|_  /\____/ \___  >__|_ \|___  /\____/__/\_ \
 *                     \/            \/     \/    \/            \/
 * $Id$
 *
 * Copyright (C) 2004 Matthias Wientapper
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
 * KIND, either express or implied.
 *
 ****************************************************************************/
#include "plugin.h"
#include "lib/pluginlib_actions.h"
#include "lib/pluginlib_exit.h"



#if CONFIG_CODEC != SWCODEC
/* tick sound from a metronome */
static unsigned char sound[] = {
255,251, 80,196,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 73,110,102,111,  0,  0,  0, 15,  0,  0,  0,  4,  0,  0,  4, 19,  0, 64, 64,
 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
 64, 64, 64,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
128,128,128,128,128,128,128,128,192,192,192,192,192,192,192,192,192,192,192,192,
192,192,192,192,192,192,192,192,192,192,192,192,192,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,  0,  0,  0,
 58, 76, 65, 77, 69, 51, 46, 57, 50, 32,  1,137,  0,  0,  0,  0,  0,  0,  0,  0,
  2, 64, 36,  5,191, 65,  0,  0,  0,  0,  0,  4, 19,168,187,153, 93,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,255,251, 80,196,  0,  0, 10, 81, 57, 65,184,120,
128,  1, 95,159,239,191,144, 96,  0,  0,128,  0,  0,  0,  0,  0,  0, 48, 24, 12,
  0,  0, 15,175,185,222, 39,  7,126, 46, 50,191,243,197,255,247, 62, 92,111,252,
115, 15, 27,140,153,159,247,242,124, 44, 92,164,177, 57,175,255,236, 79,164, 98,
 68,205, 69,160, 64, 15,251,127,128,168, 38, 92,138, 17, 67,196, 80,184,223,255,
255,161,117, 33, 55, 83,191,255,193,240, 33, 57,114, 17,  0,  2,  0,  0,  0, 10,
191, 10,  8,196,209, 75, 55,236,177,115,238,223,203, 61,176, 89, 78,101,219,118,
118, 65,154,126,187,239,241,127,247,245, 59, 18,219, 94,105,245,221,161,173, 91,
191, 27,255,247, 18,124, 71,117,139,133,170,221,227,251,135,110,236,255,183,219,
100, 78,184,125,212,131, 65, 95,212,245,145, 67, 77, 10,153,250,132,195,  4,138,
224,  0,  0,  0,158,107, 42, 65,227,185, 90,158, 86,  6,155, 77,255,251, 82,196,
  8,  0, 10,136,185,103,  4, 61, 48, 65,118,173, 44, 60,147, 10,152,107, 49, 74,
 18,208, 91, 23,178,196,220, 25, 64,233,230, 36,170,  0,210,219,131, 40,165, 22,
 86,195, 23,145, 33, 16,138, 99,109,117,245, 71,162, 69, 42,220,164, 91, 72,165,
 26, 69,146,150,199,222, 73,102,148, 29, 19,  5, 65, 86,  6,150,120,180, 26, 88,
 75, 18,191,255,250,171,  4,  8,132,140,  0,  0, 20,186,242,162, 66,100, 62, 86,
206, 86,255, 26,203,201,255,255,141,128,166,196,175,133,  9, 70,188,146,175,133,
 60, 17,217,229, 90, 27, 87, 93, 34, 76,113,185, 84,213, 56, 17,170, 83, 75,180,
203,116,101, 93, 90, 99, 35,174,230, 42,125, 12,128, 79, 93, 81,234, 67, 66,137,
105,157,157, 23, 71, 53, 40,250,204,105, 89,203,107,250, 63,174, 89,133, 81,140,
  0, 52, 17, 16,  0,  0, 18,111, 20, 92, 32,213, 48,179, 50, 26,244,179, 27,230,
154, 34,133,177, 88,255,251, 82,196, 13,  0, 10,125, 65, 85,244, 85,  0,  1,210,
172,231,  7, 31, 32,  0, 37, 11, 68, 69, 13, 37, 48,210, 23, 69, 36,122,143,148,
211,141, 44, 76,135, 72,148,195,135,174, 84,149,167, 30,198,183,255,213,111, 61,
 27,155,191,177,207,246,163,255,230, 30,137,219,255,182,186,185,239, 52,148,171,
 75, 63,167, 44,  0,  2, 81,190, 41,253,248,182,180, 23, 43,127,217,161, 41,191,
 36,199, 40,153,108, 66,224,131,192,217, 12, 67,217,  6,218,240,108,112, 63, 33,
 93, 12,  8, 43, 66, 42, 74, 12,215,135,100,172, 33, 65,172, 29, 98,  4, 83, 34,
 40, 17,111,133,255, 18,145, 60, 59,136,145, 92,106,144, 34,185, 58, 76,154,254,
146,144,115,  4, 84,180,142,178, 38, 79,253, 34,237,105, 31,106, 70, 73, 36,138,
 73,164,181,127,253,182, 82,217, 26,245,117,163,255,219, 50,115,223,245, 92,198,
165,173,  0, 15,249,132, 50, 19,157, 85,121,153,245, 51,255,251, 82,196,  6,131,
 74, 96,134,156, 92, 19,  0,  8,  0,  0, 52,128,  0,  0,  0, 60,226, 73, 57, 26,
249,253,122,211,128, 65, 86, 10,  1,  9,195,128, 36, 72,225,196,146,115, 73, 18,
 75, 65, 77,  9,  5,200, 43, 16,163,129, 77,  9,  5,200,110, 39,127,255,255,255,
255,255,255,255,252, 83, 66,142,140, 21,136, 46, 64,166,133, 28, 12, 21,136, 46,
 64,166,133, 21,  6, 76, 65, 77, 69, 51, 46, 57, 50, 85, 85, 85, 85, 85, 85, 85,
 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85,
 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85,
 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85,
 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85,
 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85,
    85, 85, 85};
#else
static signed short sound[] = {
     1,    -1,     1,    -1,     0,     0,     0,     1,    -1,     0,     0,
     0,    -1,     2,    -2,     2,    -1,     0,     0,     0,     0,     1,
    -1,     0,    -1,     1,     0,     0,     0,     1,    -1,     1,    -2,
     1,    -1,     1,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,    -1,     2,    -2,     2,    -1,     0,     1,    -1,     1,
    -1,     0,     0,     0,     0,     1,    -2,     2,    -2,     1,     0,
     1,    -1,     0,     1,    -1,     0,     1,    -2,     2,    -1,     0,
     0,     0,    -1,     1,     0,     0,     0,     0,     0,     0,     0,
     0,    -1,     1,    -1,     2,    -2,     2,    -2,     2,    -2,     1,
     0,     0,     0,     1,    -2,     2,    -2,     1,     0,     0,     0,
     0,     0,     0,    -1,     1,     0,    -1,     2,    -2,     2,    -1,
     0,     0,     0,    -1,     1,    -1,     1,    -1,     2,    -2,     1,
     0,    -1,     2,    -2,     2,    -2,     1,     0,     0,     0,     0,
     0,     0,     0,     0,     1,    -1,     0,     0,    -1,     1,     0,
     0,     1,    -1,     0,     0,     0,     0,     0,     0,     0,     0,
     1,    -2,     2,    -1,     0,     0,     0,     0,     0,     1,    -2,
     1,     0,     0,     0,     0,     0,     1,    -1,     0,     0,    -1,
     2,    -2,     2,    -2,     2,    -1,     0,     0,    -1,     1,    -1,
     1,    -1,     1,    -1,     1,    -1,     1,     0,     0,    -1,     2,
    -2,     1,     0,     0,     0,     0,     0,     1,    -1,     0,     0,
    -1,     1,     0,     0,     0,     0,     0,     0,     1,    -2,     2,
    -2,     2,    -1,     1,    -1,     1,    -2,     2,    -2,     2,    -2,
     2,    -2,     2,    -2,     2,    -1,     0,     0,     0,    -1,     2,
    -2,     2,    -1,     1,    -1,     1,    -2,     2,    -2,     1,     0,
     1,    -1,     1,    -2,     1,    -1,     1,     0,     0,     0,     0,
     0,     0,     0,     0,    -1,     1,     0,    -1,     2,    -1,     0,
     0,    -1,     1,     0,    -1,     2,    -2,     1,     0,     0,     0,
     0,     0,     0,    -1,     2,    -1,     1,    -1,     0,     0,     1,
    -2,     2,    -1,     1,    -1,     0,     1,    -1,     0,     0,     0,
     0,     0,     0,    -1,     1,     0,     0,     0,     0,    -1,     2,
    -2,     2,    -1,     0,     1,    -1,     0,     0,     0,     0,     0,
     0,     0,     0,     1,    -1,     1,    -1,     0,     0,     0,     0,
     0,     1,    -1,     1,    -1,     0,     1,    -2,     2,    -1,     0,
     1,    -2,     2,    -2,     2,    -2,     2,    -1,     0,     1,    -1,
     0,     1,    -1,     0,     0,     0,     0,     0,     0,     1,    -2,
     2,    -2,     1,     0,    -1,     2,    -2,     1,     0,     0,     0,
     0,    -1,     1,     0,     0,     1,    -1,     0,     0,     0,     0,
     0,     0,     0,     1,    -1,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,    -1,     1,
    -1,     1,     0,     0,     0,     0,     0,     0,    -1,     2,    -1,
     0,     0,     0,     0,     1,    -1,     0,     0,     1,    -2,     2,
    -1,     0,     0,     0,     0,    -1,     1,     0,     0,    -1,     2,
    -2,     1,     0,    -1,     1,    -1,     2,    -2,     2,    -2,     2,
    -1,     0,     0,     0,     0,     0,     1,    -1,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    -1,     1,     0,     1,    -2,
     2,    -1,     0,     1,    -1,     0,     0,     0,     0,     0,     0,
    -1,     2,    -2,     2,    -2,     2,    -1,     0,     0,     0,    -1,
     1,     0,    -1,     1,     0,     0,     0,     0,     0,     0,     1,
    -1,     0,     0,    -1,     1,     0,     0,     0,     0,     0,     0,
     1,    -2,     2,    -2,     1,     0,     0,     0,     0,     0,     0,
     0,     1,    -1,     0,     1,    -1,     1,    -1,     0,    -1,     2,
    -1,     0,     0,     0,    -1,     1,    -1,     1,     0,     1,    -1,
     1,    -2,     1,     0,     0,     1,    -2,     2,    -2,     2,    -2,
     2,    -2,     2,    -1,     0,     0,     0,     0,     0,    -1,     2,
    -2,     2,    -1,     0,     0,     0,     1,    -1,     0,     0,     0,
     0,    -1,     1,    -1,     1,     0,     0,     0,     1,    -2,     1,
     0,    -1,     2,    -2,     1,    -1,     0,     2,    -2,     2,     0,
    -1,     0,     0,     0,    -1,     2,    -2,     2,    -2,     2,    -2,
     2,    -1,     0,     1,    -2,     2,    -1,     0,     0,     0,     0,
     1,    -1,     0,     0,     0,     0,     0,     0,     0,     1,    -2,
     1,     0,     0,     0,     0,     0,     0,    -1,     1,    -1,     1,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    -1,
     1,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,    -1,     1,     0,    -1,
     2,    -2,     1,     0,     0,     0,     0,     0,    -1,     2,    -2,
     2,    -1,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,    -1,     2,    -1,     0,     0,    -1,     1,     0,
     0,     0,     0,     0,     1,    -1,     0,     0,    -1,     1,     0,
     0,     0,     0,    -1,     1,     0,    -1,     2,    -1,     0,     0,
     0,     1,    -2,     2,    -1,     0,     0,     0,    -1,     1,    -1,
     1,     0,     0,     0,     0,     0,     0,     1,    -1,     1,    -1,
     0,     0,    -1,     2,    -2,     1,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    -1,     1,    -1,     1,     0,
    -1,     2,    -2,     1,     1,    -1,     0,     0,    -1,     1,     0,
     0,     0,     1,    -2,     2,    -2,     1,     0,     1,    -2,     2,
    -1,     0,     0,     0,    -1,     2,    -1,     0,     0,     0,     0,
     0,     0,     0,     0,    -1,     2,    -2,     2,    -1,     0,     0,
     0,    -1,     1,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,    -1,     2,    -2,     2,    -1,     0,     1,
    -1,     0,     0,     0,     0,     0,     0,     0,     0,     1,    -2,
     2,    -1,     0,     0,     0,    -1,     2,    -2,     2,    -2,     1,
     0,    -1,     1,     0,    -1,     1,     0,     0,     0,     0,     0,
    -1,     1,    -1,     2,    -2,     2,    -1,     1,    -1,     0,     0,
     0,     0,     1,    -1,     0,     0,     0,     0,     1,    -2,     2,
    -2,     1,     1,    -1,     1,    -1,     1,    -2,     2,    -2,     1,
    -1,     2,    -2,     1,     0,     0,     0,     0,     0,    -1,     2,
    -2,     2,    -1,    -1,     1,    -1,     1,    -1,     2,    -2,     2,
    -1,     0,     0,     1,    -2,     2,    -2,     1,     0,     0,     0,
     0,     1,    -2,     1,    -1,     1,    -1,     1,     0,     0,     0,
     0,     0,    -1,     1,     0,     0,     0,    -1,     1,     0,     0,
     1,    -2,     2,    -2,     1,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     1,    -1,     1,    -2,     1,     0,     0,
     0,     0,     0,     0,    -1,     1,     0,     0,     0,    -1,     1,
     0,     0,     0,     0,     0,     0,     1,    -2,     2,    -1,     0,
     0,     0,     0,     0,     0,     1,    -2,     2,    -1,     1,    -1,
     0,     0,     0,     1,    -1,     0,     0,    -1,     2,    -1,     0,
     1,    -1,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,    -1,     1,     0,     0,     0,     0,     0,     0,     1,
    -1,     0,     0,     0,     0,     0,     0,    -1,     2,    -2,     2,
    -1,     1,    -1,     0,     0,    -1,     2,    -1,     1,    -1,     1,
    -2,     2,    -2,     2,    -2,     2,    -1,     0,     0,     0,     0,
     0,     0,     0,     0,     1,    -1,     0,     0,     1,    -2,     2,
    -1,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -1,     1,     0,     0,     0,    -1,     1,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,    -1,     2,    -2,     2,    -1,     0,     1,
    -2,     1,     0,     0,     1,    -2,     2,    -2,     2,    -1,    -1,
     2,    -2,     1,     0,     0,     0,     1,    -2,     2,    -1,     0,
     0,     0,     0,     0,     0,     0,    -1,     1,    -1,     2,    -1,
     0,     0,     0,     0,     0,     0,     0,     0,     0,    -1,     2,
    -1,     0,     0,     0,     0,     0,     0,     0,     0,     0,    -1,
     1,     0,     0,     1,    -1,     1,    -1,     0,     0,    -1,     2,
    -2,     2,    -1,     0,     0,     0,     1,    -1,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,    -1,     1,     0,
     0,     0,     0,     0,     0,     0,     0,     1,    -1,     0,     0,
     0,    -1,     2,    -2,     1,     0,    -1,     1,     0,     0,     1,
    -1,     0,     0,    -1,     2,    -2,     1,     0,    -1,     2,    -1,
     0,     0,     0,     0,     0,     0,     0,    -1,     1,     0,     0,
     1,    -2,     2,    -2,     1,     0,     0,     0,     0,    -1,     1,
     0,     0,     1,    -1,     0,     0,     0,     0,     0,     0,     0,
    -1,     1,     0,     0,     0,     1,    -1,     0,     0,     0,     0,
     1,    -1,     0,     1,    -1,     0,    -1,     1,     0,    -1,     2,
    -2,     1,     0,     0,     0,    -1,     2,    -2,     1,     0,     0,
     1,    -2,     2,    -1,     0,     1,    -1,     0,     0,     0,    -1,
     1,    -1,     1,     0,     0,     0,     0,     0,     0,     0,     0,
     0,    -1,     1,     0,    -1,     2,    -2,     1,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,    -1,     2,    -2,
     1,    -1,     1,    -1,     2,    -2,     1,     0,    -1,     2,    -2,
     2,    -1,     0,     0,     0,    -1,     1,     0,     0,     0,     1,
    -2,     2,    -2,     2,    -2,     1,     0,     0,     0,     0,     1,
    -1,     1,    -1,     0,     0,     0,     0,     0,     0,     1,    -1,
     0,     0,     0,     0,     1,    -1,     0,     0,     0,    -1,     2,
    -2,     2,    -1,     0,     1,    -2,     1,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,    -1,     2,    -2,
     2,    -2,     1,     0,     0,     0,     0,     0,     0,    -1,     2,
    -2,     2,    -1,     0,     1,    -1,     0,     0,     0,     0,     0,
     0,     1,    -1,     0,     1,    -2,     1,     0,    -1,     1,     0,
    -1,     1,     0,     0,     0,     0,     1,    -1,     0,     0,     0,
     0,     0,    -1,     2,    -2,     2,    -2,     2,    -2,     1,     0,
     0,     0,     0,     1,    -2,     2,    -2,     2,    -1,     0,     1,
    -2,     2,    -2,     1,     0,     0,     0,     1,    -1,     0,     0,
    -1,     1,     0,     0,     0,     0,    -1,     2,    -2,     2,    -1,
     0,     0,     0,    -1,     2,    -1,     0,     1,    -1,     0,     0,
     0,     0,     1,    -2,     2,    -1,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     1,    -1,     0,     0,     0,     0,     0,
     0,     0,     0,     0,    -1,     1,     0,     0,     0,     0,     0,
     0,     1,    -1,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,    -1,     1,     0,     0,    -1,     1,    -1,     2,
    -2,     2,    -2,     2,    -1,     0,     0,    -1,     1,    -1,     1,
     0,    -1,     2,    -2,     2,    -1,     0,     0,     0,     0,     0,
     0,     0,     1,    -2,     2,    -2,     1,     0,     0,     0,    -1,
     2,    -2,     1,     0,     1,    -1,     0,     0,     1,    -1,     1,
    -2,     1,     0,     0,     0,    -1,     1,    -1,     2,    -2,     2,
    -1,     0,     0,     0,     0,     0,     0,     0,     0,     1,    -1,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     1,    -2,     2,    -1,     0,     1,    -2,     2,    -1,     0,     0,
     0,     0,     1,    -1,     1,    -1,     0,    -1,     2,    -2,     2,
    -2,     2,    -1,     0,     0,     0,     0,     0,     0,     0,     1,
    -1,     0,     0,     0,    -1,     2,    -2,     1,     1,    -2,     2,
    -1,     0,     1,    -2,     1,     0,     0,     0,     0,     1,    -1,
     0,     1,    -1,     0,     0,    -1,     2,    -2,     2,    -2,     2,
    -2,     2,    -2,     2,    -2,     2,    -2,     2,    -1,     1,    -1,
     1,    -1,     1,     0,    -1,     1,    -1,     1,     0,     0,    -1,
     0,     1,     0,     1,    -2,     2,    -2,     1,     1,    -2,     1,
     0,     0,     0,     0,     0,     0,     0,    -1,     2,    -1,     0,
     0,    -1,     1,     0,     0,     0,    -1,     0,     1,     0,     1,
    -2,     0,    -1,     1,     0,     1,     0,    -1,     0,     0,     1,
    -1,     1,    -2,     1,     1,    -1,     1,    -1,    -1,     0,     1,
     0,     1,    -1,     0,    -1,     0,     1,     1,    -2,     1,    -1,
     1,     1,     0,    -1,     0,     0,     1,     1,     1,    -1,     0,
    -1,     0,     1,    -1,     1,    -2,     2,     0,     0,     1,    -2,
    -1,     0,     0,     1,    -1,     0,    -1,     1,     0,     0,     0,
     0,     0,     0,     0,    -1,     1,    -1,     1,     0,     2,     1,
    -1,     0,     0,     0,     1,     1,     1,    -1,     1,     1,     0,
     1,    -2,     1,    -1,     2,     2,     0,    -1,    -1,    -1,     0,
     1,    -1,     1,    -1,     1,     1,     1,     1,    -3,     0,     3,
     0,     0,    -4,    -2,     4,     5,     4,    -3,    -1,     1,    -3,
    -2,    -5,    -6,    -1,     5,     2,     1,    -3,    -2,    -5,     1,
    -4,    -5,     3,     5,     0,     1,     2,     0,    -5,    -1,     3,
     5,     2,     1,     1,     6,     5,     3,    -1,     0,     2,     5,
    10,     8,     4,     2,    -5,    -5,     3,    11,     8,    -4,    -8,
    -2,     2,    -1,    -1,     5,    -6,   -12,   -11,    -5,    -9,    -5,
    10,     6,     3,    -4,    -3,    -9,    -8,   -18,    -9,     5,    13,
     7,    13,    29,    17,    -1,    -1,    15,    21,    15,    -9,   -29,
   -15,    10,    10,   -15,   -31,   -48,   -49,   -30,    -7,    -1,    -8,
    -6,    15,    39,    43,    24,    16,    27,    28,     9,   -16,    -6,
    34,    60,    41,    15,    11,    26,    14,   -28,   -77,   -83,   -60,
   -32,     1,    10,   -11,   -59,   -83,   -49,    27,    93,    82,    11,
   -27,    -8,     9,     1,    12,    22,     6,   -22,   -15,     4,     8,
   -19,   -23,    49,   143,   139,    39,   -31,   -56,  -101,  -145,  -102,
   -10,    20,   -61,  -196,  -258,  -136,    70,   172,   112,    43,    55,
    75,    12,   -69,   -33,    89,   114,   -26,  -137,   -14,   239,   335,
   202,    68,   115,   231,   169,  -131,  -459,  -540,  -338,   -72,    43,
    20,   -53,  -174,  -290,  -195,   192,   593,   628,   322,    95,   159,
   264,   163,   -50,  -202,  -229,  -114,    18,   -31,  -212,  -264,   -36,
   432,   807,   619,   -52,  -483,  -452,  -414,  -404,   -98,   228,    -3,
  -760, -1444, -1414,  -458,   624,   732,    35,  -209,   476,  1113,   586,
  -785, -1405,  -480,   753,   881,   280,    81,   441,   753,   687,   711,
  1440,  2140,  1110, -1470, -2963, -1770,   607,  1427,  -399, -3146, -3899,
 -2064,    28,   715,   874,  1442,  1606,   394, -1483, -2014,  -354,  1531,
  1156,  -984, -2108,  -821,  1635,  3003,  2087,   186,  -155,  1569,  3328,
  3463,  2110,     9, -2200, -3876, -4298, -2871,  -266,  1039,  -393, -2357,
 -1809,  1079,  4019,  5685,  5742,  4435,  3098,  2963,  3181,  2018,  -691,
 -3919, -6922, -9001, -8935, -6374, -3215, -1862, -2089, -1508,   731,  3186,
  4763,  5160,  3629,   706,  -712,   739,  2391,  1570, -1015, -3502, -4979,
 -4798, -2615,   420,  2178,  1457,  -602, -1287,   741,  3741,  5018,  3687,
   934,  -757,   497,  3094,  3163,   113, -2188, -1194,   911,   998,  -254,
   484,  3643,  4907,  1023, -4718, -6191, -1911,  3621,  4508,  -687, -6491,
 -6309, -1015,  3007,  3184,  1911,   471, -1763, -4048, -4414, -2046,  1179,
  1513, -1919, -4522, -2259,  2368,  4547,  3613,  2320,  2847,  5035,  6432,
  4390,  -835, -5857, -7419, -5497, -2768, -1012,   -27,  -294, -2444, -3889,
 -1911,   942,  1212,   859,  2879,  5141,  4107,   108, -3768, -4853, -2787,
  -162,   142, -1594, -2490,  -498,  3349,  5670,  4368,  1089, -1548, -3118,
 -3936, -3319, -1583,  -547,  -360,   985,  3125,  2273, -1728, -2291,  4071,
 10390,  9283,  3620,    79,   -90,  1293,  1968, -2030,-10963,-16320,-10631,
  1236,  8206,  6740,  2418,  1132,  3007,  3504, -1371, -8877, -9321,  2657,
 17866, 22245, 14739,  4801, -2737, -7071, -2808, 12289, 25609, 19526, -6479,
-30563,-29780, -6434, 13879, 13263,    83, -8239, -7874, -6445, -8032, -9180,
 -7691, -7914,-12368,-13982, -7090, -1018, -8154,-21862,-22142, -3867, 14327,
 14436,  1712, -5853, -2462,  3311,  4605,  1731, -3832,-11191,-17673,-17400,
 -4049, 17643, 27851, 14373, -7582,-15759, -9573, -1277,  5996, 13903, 17168,
 11276,  1603, -4763, -7550, -7537, -2186,  6709, 10980,  6990, -1127, -9765,
-16805,-19102,-18420,-18687,-13775,  3373, 21405, 23456, 12651,  3319, -1287,
 -4637, -3954,  3883, 11849,  8344, -6853,-17292, -7204, 16901, 31089, 21726,
  1084, -7875,  1459, 15092, 20527, 18496, 10594, -3296,-12835, -6081,  9842,
 15942,  3977,-16959,-26888,-12200, 13260, 20645,  6239, -5950, -2526,  6054,
  8073,  3123, -4656,-11949,-15611,-12153, -2236,  4314, -2887,-19936,-30928,
-23846, -1429, 17759, 15264, -1868, -7505,  5991, 19737, 18946,  8185,  -600,
    44,  6127,  5321, -4750,-11829, -8743, -1330,  3689,  3252, -3513,-11859,
-14753,-10198,    72, 10949, 13370,  5735,  -564,  2639,  9903, 13145, 11045,
  6754,  3123,  -724, -6600,-10509, -8340, -6244,-12133,-21055,-20385, -5186,
 15105, 23034, 11762, -3750, -5737,  2612,  6060,    33, -7014, -4975,  7697,
 18684, 12606, -7934,-23083,-20429, -7355,  2345,  4875,  7094, 14569, 22636,
 22509, 13749,  4800,  2246,  4805,  7497,  7404,  4042, -3207,-13334,-19292,
-12274,  5051, 15820,  7212,-12051,-20991,-11633,  3886, 11417, 10491,  8967,
  9849,  9995,  8305,  7497,  7731,  5549,   -49, -6582,-12286,-16545,-19489,
-22478,-23536,-16116,  -123, 14039, 19014, 16964, 11024,  3746,  1174,  5696,
 10510,  9283,  3833, -1113, -4247, -7485,-11448,-12665, -9329, -7052,-10656,
-14627,-10081,  3317, 16454, 18316,  6990, -6264,-10409, -7182, -2463,  3812,
 10794, 12717,  7460,   215, -2353,   676,   983, -9207,-21161,-17629,   361,
 11731,  2863,-15895,-22726, -8619, 11663, 17157,  7331,  -255,  4522, 15016,
 20742, 18465, 12205,  6509,   836, -6050,-10016, -8310, -6482, -9596,-13628,
-12443, -6667, -1745,  -487,   633,  6363, 14319, 17428, 14246,  9598,  6752,
  5527,  5289,  5673,  6272,  5900,  2123, -5034,-10908,-12352,-12153,-13371,
-14974,-15335,-14089, -9874, -1589,  8285, 14571, 13761,  7383,  1668,  1519,
  4509,  3987, -1719, -7872,-10985,-12263,-12864,-11713, -9423, -8944,-10937,
-12477,-11078, -6884, -1052,  5798, 13303, 20195, 23473, 20387, 12863,  7217,
  6080,  4059, -3737,-13190,-17239,-15342,-11071, -5970,  -543,  4259,  7968,
  8781,  4097, -3427, -7041, -5374, -2595,    70,  4218,  8042,  8534,  7403,
  8758, 12712, 15141, 12739,  6198,  -414, -2420,   331,   780, -7211,-18274,
-21587,-15771, -7472,   733,  9880, 17443, 19723, 16661, 10520,  4467,  1343,
   308, -1550, -3368, -1921,  1564,  1426, -5086,-13434,-16483,-12675, -6499,
 -2040,  -586, -2374, -5424, -5786, -2131,  3305,  7892,  9432,  7024,  3000,
   410,  -274,   396,  1514,   785, -2873, -7609,-11931,-15458,-16897,-15275,
-10823, -3469,  5396, 11785, 13505, 11686,  7478,  2801,  1972,  6978, 13591,
 14815,  7016, -6127,-15851,-17122,-13183, -9425, -7273, -5029, -1087,  3485,
  5516,  4834,  5156,  7648,  9472,  9387,  8481,  7313,  6847,  7922,  8488,
  6309,  2375, -1821, -6179, -9633,-10798,-10521,-10565,-11165,-11055, -8661,
 -3781,  1960,  6819,  9680,  9920,  8944,  9396, 10975, 10715,  7182,   861,
 -7005,-13267,-15283,-15034,-15703,-15867,-12193, -5329,   829,  3996,  5377,
  7152,  9312, 10386, 10275, 10167, 10500, 10694,  9601,  6318,  2012, -1381,
 -4917,-10834,-17053,-18962,-15907,-11261, -7518, -4754, -2399,   -32,  2969,
  6930, 10871, 13043, 13087, 12045, 10546,  9003,  8103,  6739,  2241, -5153,
-11768,-15213,-15636,-13473, -9655, -6045, -3220,  -430,  2055,  3835,  6558,
 11429, 15904, 16225, 12337,  7477,  3631,  -122, -4854, -9898,-13734,-15118,
-13861,-11287, -8854, -6458, -3768, -1724,  -385,  2105,  5993,  8742,  9121,
  8765,  8415,  6764,  3536,   104, -2912, -5635, -7580, -8217, -7502, -5362,
 -2617, -1366, -2262, -3363, -3163, -2137,  -589,  1870,  4595,  6301,  6764,
  6718,  6520,  5842,  4638,  3882,  4279,  4700,  3357,   183, -2935, -3952,
 -2906, -2493, -4469, -6460, -5616, -2932,  -231,  3057,  6959,  9364,  9069,
  6831,  4078,  2556,  2602,  2068,  -153, -1834, -1310,  -248,  -795, -2717,
 -4126, -3995, -3695, -4963, -6850, -7066, -5258, -2772,  -846,   139,  1073,
  2821,  4490,  5430,  6971,  8941,  8259,  3626, -2713, -8358,-12049,-13228,
-12856,-12123,-10333, -7012, -3862, -1844,   527,  4263,  8105, 10304, 10453,
  9346,  7786,  5793,  3181,    40, -3553, -7164, -9520, -9740, -8339, -6135,
 -3335,    16,  3345,  5455,  5356,  3793,  2943,  3715,  4965,  5638,  6024,
  6657,  7270,  6829,  4385,   593, -2392, -3644, -4633, -6185, -6575, -4682,
 -2249, -1081,  -648,   222,  1873,  4273,  6609,  7328,  6269,  5017,  4332,
  3500,  2200,   704, -1135, -3367, -5373, -6705, -7346, -7055, -5618, -3596,
 -1716,   117,  2133,  3576,  3514,  2437,  1568,  1147,   588,  -490, -1976,
 -3125, -2983, -1979, -1775, -2637, -2993, -2327, -2013, -2843, -4077, -4841,
 -4778, -3915, -2756, -1663,   -78,  2401,  4777,  5910,  6074,  5858,  4886,
  2889,   688,  -970, -2010, -2413, -2357, -2511, -3033, -3218, -2983, -2783,
 -2022,   315,  3490,  5687,  6228,  5642,  4405,  3006,  2065,  1656,  1592,
  2141,  3191,  3485,  2147,  -131, -2437, -4663, -6289, -6118, -3991, -1098,
  1550,  3446,  4204,  4186,  4379,  4801,  4654,  3956,  3267,  2297,   512,
 -1660, -3571, -5057, -5713, -5051, -3695, -2719, -2075, -1180,  -306,    43,
   201,   527,   896,  1415,  2085,  2103,  1018,  -171,  -613,  -825, -1316,
 -1701, -1787, -1766, -1462,  -922,  -997, -1987, -2857, -2699, -1736,  -514,
   484,   696,   221,    24,   316,    48,  -973, -1304,   -49,  1921,  3426,
  4026,  3875,  3529,  3327,  2659,  1002,  -723, -1568, -2055, -2862, -3247,
 -2368,  -873,    62,   184,    58,   315,  1196,  2204,  2563,  2494,  2945,
  3730,  3479,  1991,   500,  -527, -1710, -3069, -4146, -4921, -5126, -4168,
 -2410,  -881,   287,  1399,  2210,  2737,  3559,  4435,  4390,  3402,  2338,
  1278,  -271, -1954, -2896, -3007, -2752, -2482, -2724, -3874, -5145, -5390,
 -4613, -3122,  -402,  3217,  5859,  6536,  6136,  5381,  4239,  3021,  1905,
   465, -1127, -2074, -2588, -3532, -4652, -5131, -4876, -4054, -2586,  -848,
   525,  1727,  3291,  4715,  5094,  4595,  3990,  3426,  2642,  1618,   196,
 -1676, -3238, -3809, -3789, -3482, -2326,  -697,  -239, -1207, -1820,  -939,
   863,  2740,  4260,  5221,  5856,  6299,  5671,  3229,   -23, -2465, -3892,
 -4948, -5454, -5047, -4443, -4355, -4055, -2592,  -469,  1194,  2038,  2285,
  2563,  3653,  5162,  5484,  4235,  2697,  1473,    27, -1754, -3674, -5673,
 -6983, -6577, -4808, -2747,  -690,  1257,  2527,  3071,  3338,  3313,  2895,
  2726,  3203,  3522,  2793,  1295,  -325, -2074, -3850, -4855, -4744, -4000,
 -2801, -1095,   473,  1418,  2150,  2712,  2651,  2407,  2619,  2775,  2513,
  2523,  2737,  2113,   659,  -598, -1376, -2019, -2413, -2377, -2143, -1792,
 -1119,  -403,  -404,  -963,  -894,   215,  1579,  2770,  3868,  4081,  2660,
   398, -1501, -2862, -3573, -3200, -2109, -1097,  -276,   295,    45, -1024,
 -1953, -2120, -1736,  -971,   274,  1597,  2369,  2667,  2840,  2417,   947,
  -823, -1912, -2224, -1940, -1203,  -452,   127,   811,  1272,   788,  -366,
 -1342, -1806, -1746, -1161,  -266,   928,  2469,  3661,  3707,  2956,  2179,
  1379,   340,  -690, -1418, -1852, -2028, -1928, -1591, -1202,  -864,  -267,
   806,  1949,  2658,  2868,  2653,  2202,  1866,  1534,   768,  -230, -1027,
 -1800, -2455, -2301, -1394,  -707,  -605,  -610,  -403,   -39,   282,   371,
   423,   917,  1881,  2543,  1980,   235, -1335, -1767, -1786, -2298, -2787,
 -2689, -2421, -2133, -1460,  -694,  -214,   424,  1435,  2307,  2819,  3041,
  2652,  1573,   324,  -754, -1729, -2520, -2956, -2933, -2321, -1260,  -306,
   165,   305,   416,   646,   985,  1362,  1745,  2076,  2245,  2234,  1930,
  1150,   -10, -1337, -2785, -3969, -4138, -3350, -2371, -1256,   303,  1810,
  2722,  3265,  3605,  3559,  3246,  2772,  1942,   766,  -553, -1923, -2939,
 -3124, -2592, -1721,  -657,   340,  1033,  1514,  1616,  1076,   417,   322,
   591,   787,   929,  1058,  1046,   827,   255,  -548, -1069, -1232, -1508,
 -1928, -2066, -1828, -1384,  -836,  -313,   165,   570,   710,   593,   549,
   566,   338,   -42,  -215,   -86,    93,   -71,  -692, -1242, -1361, -1405,
 -1612, -1705, -1546, -1012,    64,  1202,  1774,  2110,  2444,  2028,   747,
  -280,  -586,  -712,  -687,  -214,   222,    21,  -651, -1402, -2075, -2301,
 -1607,  -374,   420,   528,   623,   906,   895,   646,   748,  1155,  1401,
  1471,  1569,  1443,   829,  -102, -1009, -1730, -2195, -2295, -1957, -1121,
   235,  1663,  2296,  1932,  1429,  1359,  1289,  1045,  1074,  1308,  1229,
   771,    13, -1126, -2275, -2863, -2931, -2658, -1849,  -660,   316,   931,
  1418,  1586,  1154,   592,   633,  1166,  1428,  1169,   759,   275,  -489,
 -1425, -2208, -2714, -2705, -2029, -1090,  -367,   236,   886,  1413,  1728,
  1903,  1867,  1576,  1097,   393,  -463, -1157, -1465, -1417, -1112,  -615,
    82,   923,  1390,   889,  -291, -1250, -1686, -1756, -1338,  -411,   577,
  1291,  1751,  1854,  1480,   897,   393,   -43,  -439,  -733,  -924,  -979,
  -751,  -354,   -58,   122,   314,   418,   311,   171,   225,   428,   678,
  1000,  1304,  1263,   748,    37,  -586, -1042, -1237, -1070,  -664,  -243,
    97,   262,   167,  -128,  -402,  -445,  -184,   202,   446,   534,   519,
   323,   -11,  -258,  -385,  -468,  -463,  -350,  -191,   -36,    -2,  -163,
  -207,    82,   406,   588,   861,  1087,   900,   461,    73,  -396,  -872,
  -917,  -514,   -44,   332,   667,   771,   490,   -59,  -620, -1123, -1495,
 -1448,  -811,    63,   751,  1214,  1446,  1336,  1005,   611,    60,  -531,
  -828,  -837,  -740,  -478,  -139,   -25,   -63,    30,   245,   481,   790,
  1033,  1002,   750,   462,   140,  -197,  -433,  -516,  -516,  -578,  -715,
  -818,  -821,  -742,  -548,  -228,    77,   233,   247,   183,   100,    60,
    91,   155,   208,   257,   275,   154,  -136,  -387,  -429,  -428,  -486,
  -396,   -72,   259,   435,   450,   397,   400,   373,   153,   -57,    23,
   181,   231,   390,   496,    87,  -627, -1036, -1047,  -785,  -216,   465,
   823,   761,   501,   269,   197,   282,   395,   502,   597,   684,   687,
   440,   -91,  -581,  -803,  -853,  -677,  -155,   367,   520,   472,   351,
   -35,  -523,  -708,  -585,  -312,   103,   471,   530,   378,   226,    51,
  -164,  -377,  -542,  -582,  -404,  -134,    42,    91,     4,  -205,  -400,
  -488,  -528,  -548,  -453,  -157,   305,   794,  1106,  1134,   866,   307,
  -368,  -839,  -979,  -916,  -721,  -436,  -226,  -164,   -84,    26,    32,
    27,   249,   614,   889,  1016,  1036,   931,   663,   248,  -235,  -632,
  -864,  -967,  -997,  -965,  -800,  -394,   150,   614,   919,  1096,  1049,
   791,   514,   271,    19,  -107,   -93,  -145,  -295,  -384,  -365,  -257,
   -96,   -26,  -115,  -232,  -332,  -437,  -400,  -167,   106,   387,   655,
   726,   536,   231,  -134,  -519,  -793,  -961, -1068, -1019,  -800,  -555,
  -275,    62,   333,   543,   777,   937,   940,   888,   784,   519,   133,
  -278,  -630,  -849,  -905,  -836,  -598,  -266,   -41,   129,   370,   501,
   401,   294,   265,   159,   100,   253,   410,   336,   166,    11,  -162,
  -313,  -295,  -159,   -70,   -82,  -123,  -159,  -195,  -141,   128,   547,
   900,  1123,  1218,  1047,   565,   -14,  -513,  -944, -1193, -1088,  -735,
  -411,  -189,   -17,    62,    33,    33,   114,   218,   335,   449,   434,
   244,   -53,  -414,  -720,  -786,  -594,  -314,  -119,  -107,  -289,  -515,
  -670,  -755,  -661,  -218,   419,   945,  1257,  1343,  1140,   688,   146,
  -364,  -747,  -941,  -997,  -923,  -669,  -334,   -74,    97,   267,   439,
   594,   715,   741,   715,   739,   823,   817,   615,   225,  -241,  -642,
  -911, -1033,  -958,  -683,  -356,   -53,   232,   432,   478,   491,   616,
   782,   862,   863,   794,   586,   230,  -181,  -534,  -750,  -738,  -528,
  -311,  -238,  -262,  -256,  -227,  -207,  -107,    83,   179,   121,    79,
   115,   135,   168,   205,   147,    48,    78,   104,   -77,  -367,  -617,
  -883, -1084, -1016,  -718,  -373,   -15,   361,   660,   801,   781,   677,
   554,   320,   -73,  -437,  -617,  -681,  -645,  -434,  -130,   113,   293,
   396,   325,   127,   -74,  -166,   -76,   183,   416,   509,   518,   451,
   293,   114,   -37,  -135,  -139,   -66,     9,    69,   133,   172,   213,
   302,   407,   464,   465,   362,   169,   -59,  -340,  -635,  -779,  -688,
  -447,   -84,   362,   661,   681,   514,   221,  -144,  -386,  -357,  -167,
   107,   375,   463,   237,  -179,  -650, -1045, -1222, -1130,  -842,  -392,
   138,   538,   675,   607,   418,   190,    41,   -18,   -35,   -35,   -32,
   -96,  -207,  -325,  -456,  -537,  -470,  -334,  -214,   -45,   183,   298,
   318,   354,   397,   377,   383,   478,   558,   567,   484,   302,    21,
  -283,  -518,  -634,  -630,  -538,  -323,   -11,   257,   390,   440,   384,
   210,   120,   251,   418,   464,   415,   286,    41,  -216,  -388,  -514,
  -519,  -335,   -65,    96,   139,   108,   -19,  -217,  -360,  -319,   -84,
   209,   472,   622,   599,   404,   185,    16,  -167,  -362,  -491,  -580,
  -659,  -617,  -457,  -316,  -190,    29,   245,   336,   321,   250,   116,
     2,   -41,   -39,    27,   143,   200,   119,   -28,  -153,  -219,  -211,
  -152,  -101,   -31,    29,    24,   -42,  -109,  -150,  -121,    -8,    81,
   114,   185,   282,   308,   280,   243,   149,    11,   -54,   -87,  -184,
  -283,  -303,  -254,  -123,    83,   232,   239,   165,    62,   -49,  -140,
  -173,  -148,   -67,    24,    67,    84,    92,    54,   -41,  -121,  -154,
  -114,   -23,    33,   -42,  -166,  -268,  -347,  -412,  -399,  -276,   -56,
   203,   449,   635,   747,   724,   565,   367,   166,   -64,  -263,  -360,
  -406,  -447,  -446,  -403,  -362,  -295,  -156,   -16,    98,   230,   381,
   493,   512,   456,   390,   345,   296,   223,   156,    56,  -121,  -320,
  -500,  -665,  -754,  -680,  -487,  -234,    79,   378,   518,   528,   469,
   319,   127,    35,    48,    65,   106,   170,   121,   -91,  -334,  -506,
  -625,  -686,  -636,  -473,  -258,   -40,   168,   349,   443,   477,   509,
   514,   432,   311,   186,    -4,  -269,  -460,  -541,  -600,  -629,  -558,
  -432,  -326,  -227,  -105,    34,   209,   394,   534,   582,   577,   524,
   403,   246,   118,    23,   -71,  -157,  -166,   -96,   -30,   -27,   -54,
   -75,   -74,   -38,   -12,   -25,    -9,   103,   245,   354,   449,   504,
   459,   321,   148,   -52,  -248,  -357,  -383,  -369,  -327,  -281,  -274,
  -281,  -215,   -56,   146,   351,   547,   692,   699,   525,   253,     5,
  -185,  -301,  -328,  -280,  -255,  -260,  -282,  -372,  -505,  -535,  -391,
  -184,    26,   233,   392,   410,   313,   173,    39,   -67,  -108,   -93,
   -70,   -85,  -151,  -261,  -381,  -475,  -495,  -443,  -313,   -91,   211,
   503,   688,   732,   648,   464,   220,   -12,  -159,  -211,  -226,  -273,
  -324,  -329,  -267,  -147,    -8,   120,   253,   422,   558,   570,   491,
   394,   269,   115,     6,   -26,   -46,  -102,  -183,  -263,  -295,  -279,
  -200,   -55,   104,   181,   191,   229,   264,   234,   170,   120,    23,
   -99,  -169,  -217,  -323,  -368,  -285,  -173,  -113,   -33,    59,    81,
    15,   -85,  -169,  -191,  -127,     0,   127,   178,   111,    -6,   -94,
  -130,  -110,   -20,    82,    87,    38,     1,   -73,  -175,  -203,  -108,
    24,   142,   243,   255,   154,    20,   -64,   -99,   -88,   -26,    73,
   178,   230,   191,    70,   -70,  -165,  -187,  -142,   -52,    49,   163,
   267,   320,   304,   230,   146,    70,     6,   -38,   -84,  -144,  -224,
  -289,  -349,  -368,  -291,   -88,   163,   372,   491,   466,   307,    89,
  -105,  -254,  -332,  -311,  -217,  -111,   -19,    -4,   -66,  -132,  -161,
  -159,  -125,   -50,   -13,   -36,   -42,    14,   105,   212,   311,   353,
   331,   264,   120,  -101,  -320,  -487,  -564,  -501,  -331,  -168,   -22,
   130,   249,   281,   288,   283,   239,   225,   267,   268,   198,   126,
    28,  -139,  -302,  -389,  -442,  -438,  -302,   -96,   102,   291,   438,
   476,   423,   334,   223,   106,    14,   -82,  -191,  -290,  -397,  -494,
  -518,  -425,  -238,   -23,   164,   270,   324,   355,   319,   215,    89,
   -27,  -147,  -236,  -288,  -347,  -395,  -360,  -243,  -125,   -43,    25,
    75,    85,    82,   119,   160,   166,   148,   130,    82,     8,   -29,
   -63,  -124,  -173,  -166,  -121,   -63,    16,    87,   163,   235,   250,
   217,   191,   187,   142,    76,    12,   -71,  -137,  -169,  -189,  -183,
  -106,     8,    87,   134,   154,    99,    45,    84,   178,   241,   277,
   270,   209,   125,    50,   -62,  -190,  -254,  -235,  -179,  -106,   -18,
    33,    46,    32,     9,   -22,   -35,   -13,    22,    64,    78,    29,
   -63,  -133,  -169,  -189,  -166,  -121,   -98,   -67,    -3,    15,     5,
    44,   100,   108,   108,   114,    64,   -46,  -141,  -245,  -316,  -233,
   -59,    21,   -10,   -20,    -6,    -7,    -6,     7,    -3,    -2,     9,
    -2,   -25,   -17,    -1,     1,    -8,    -1,    -5,   -11,   -13,   -10,
   -14,   -12,    -3,    11,     6,     2,     1,    -9,   -13,     0,    11,
    12,    16,    17,     9,    -4,    -9,   -13,   -11,     1,     7,     2,
    13,    13,    -3,     0,    10,     9,     3,     6,     4,    -4,    -9,
    -7,    -2,     6,     5,   -14,   -19,    -9,   -11,   -10,    -5,   -16,
   -22,    -4,    17,    16,     1,   -14,   -17,    -6,     6,     3,    -2,
    -5,   -10,   -11,    -1,    -2,   -12,   -12,    -4,     9,    14,    15,
     6,     9,    13,     7,    -6,    -5,     5,     3,    -6,   -10,   -14,
   -11,    -4,     4,     3,    -1,     3,    -1,   -12,   -13,     2,     9,
    -1,    -7,    -1,     1,     1,    12,     7,     2,    -1,     3,     3,
     7,     7,     3,    -1,     4,     8,     3,     6,     6,     2,    -3,
    -2,    -5,    -6,     1,    -2,    -6,    -9,   -10,    -7,    -5,     3,
    -4,   -10,    -7,     5,     7,     1,     0,     0,    -8,    -7,    -5,
    -1,     2,     4,     6,    -1,    -2,     5,     5,     0,    -1,     0,
     1,    -8,    -8,   -12,    -9,    -4,    -2,    -3,    -4,    -1,     2,
     3,     3,    -3,    -4,    -5,     3,     6,    -1,    -5,   -14,   -13,
   -12,   -13,   -11,     0,     9,    13,    10,     9,     7,     1,     1,
    -2,     1,     3,     3,     2,     0,    -2,     0,     0,     3,     1,
     4,     2,     4,     0,     1,    -1,    -1,    -1,     0,    -2,    -2,
    -1,    -2,     2,    -1,     1,     0,     1,     2,     2,     1,     1,
     1,     0,    -1,    -1,     0,    -1,     1,    -2,     2,     0,     1,
     0,    -1,    -1,    -1,     1,     0,     0,    -1,    -2,    -2,    -1,
    -2,    -1,     2,     1,     3,     0,     3,     0,    -1,     1,    -1,
     1,     0,     1,     0,    -1,     1,    -2,     2,    -1,     1,     0,
     1,     0,     0,     0,     0,     0,    -1,     1,    -2,     1,    -1,
     1,     0,     0,     0,     0,     0,     0,     1,    -1,     1,     0,
     0,     0,    -1,     0,     0,     0,     0,     0,     0,     0,    -1,
     0,     0,     1,     0,     0,     0,    -1,     0,    -1,     1,    -1,
     1,     0,    -1,     2,    -1,     1,    -1,     1,    -1,     0,     1,
    -1,     0,     1,    -1,     2,    -2,     1,    -1,     1,    -1,     0,
     1,    -1,     1,     0,    -1,     1,     0,    -1,     1,    -1,     0,
     1,    -1,     1,     0,    -1,     1,    -1,     0,     0,     1,    -1,
     1,    -1,     1,     0,    -1,     1,    -1,     1,     0,    -1,     1,
    -1,     1,    -1,     0,     1,    -1,     1,    -1,     1,    -2,     2,
    -1,     0,     1,    -1,     0,     1,    -1,     1,     0,     0,     0,
     0,     0,     0,    -1,     1,    -1,     1,    -1,     1,    -1,     1,
    -1,     1,    -1,     0,     1,    -2,     2,    -1,     0,     0,     1,
    -1,     1,     0,    -1,     0,     0,     1,    -2,     2,    -1,     0,
     1,    -1,     0,     1,    -1,     1,    -1,     1,    -1,     1,    -1,
     1,    -1,     0,     1,    -1,     1,     0,    -1,     0,     0,     1,
    -1,     0,     0,     1,    -1,     0,     0,     0,     1,    -1,     1,
    -1,     0,     1,    -1,     1,    -1,     0,     0,     0,     1,    -1,
     1,    -1,     1,    -1,     1,     0,     0,     0,    -1,     0,     1,
    -1,     1,    -1,     0,     0,     0,     0,     1,    -1,     1,    -1,
     1,    -1,     1,    -1,     1,    -1,     1,    -1,     1,    -1,     1,
    -1,     0,     1,    -1,     1,     0,    -1,     1,     0,    -1,     1,
    -1,     1,    -1,     1,    -1,     1,    -1,     0,     1,    -2,     2,
     0,    -1,     1,    -1,     1,    -1,     1,     0,    -1,     1,    -1,
     0,     1,    -2,     2,    -1,     1,     0,     0,     0,    -1,     1,
    -1,     1,    -1,     0,     0,     0,     1,    -1,     1,     0,    -1,
     1,    -1,     0,     1,    -1,     1,    -1,     1,    -1,     0,     1,
    -1,     1,    -1,     0,     0,     1,    -1,     1,    -1,     0,     1,
    -2,     2,    -1,     0,     1,    -2,     2,     0,     0,     0,    -1,
     1,    -1,     0,     1,    -1,     1,    -1,     1,    -1,     1,    -1,
     0,     1,    -1,     1,    -1,     0,     0,     1,    -1,     1,    -2,
     2,    -2,     3,    -3,     3,    -2,     0,     1,    -1,     0,     0,
     1,    -1,     1,    -1,     0,     1,    -1,     0,     0,     0,     1,
    -1,     0,     1,    -1,     1,    -1,     0,     0,     0,     1,    -1,
     0,     0,     0,     0,     1,    -1,     1,    -1,     0,     1,    -1,
     1,    -1,     1,     0,    -1,     1,     0,    -1,     1,    -1,     0,
     1,    -1,     1,    -1,     1,     0,    -1,     1,    -1,     0,     1,
    -1,     1,     0,     0,     0,    -1,     1,    -1,     0,     0,     0,
     0,     1,    -1,     1,     0,    -1,     0,     1,    -1,     0,     1,
    -1,     1,    -1,     1,    -1,     0,     1,    -2,     2,    -1,     0,
     0,     0,     1,    -1,     1,    -1,     1,    -1,     1,    -1,     1,
    -1,     0,     1,    -1,     1,    -1,     1,     0,     0,    -1,     1,
    -1,     0,     0,     0,     0,     1,    -1,     1,    -1,     0,     1,
    -1,     0,     1,    -1,     1,    -1,     1,    -1,     0,     1,    -1,
     0,     1,    -1,     1,     0,    -1,     1,    -1,     0,     1,    -2,
     2,    -1,     0,     0,     0,     1,    -1,     1,    -1,     1,     0,
    -1,     1,    -1,     0,     1,    -2,     2,    -1,     0,     0,     0,
     1,    -1,     0,     0,     1,    -1,     1,     0,    -1,     0,     1,
    -2,     2,    -1,     1,     0,    -1,     0,     1,    -2,     3,    -2,
     1,    -1,     1,    -2,     2,    -2,     2,    -1,     1,    -1,     1,
    -1,     1,    -1,     1,    -1,     1,    -1,     1,    -1,     1,    -1,
     0,     0,     1,    -1,     1,    -2,     2,    -1,     1,    -1,     1,
    -1,     0,     1,    -2,     2,    -1,     1,    -1,     0,     0,     0,
     0,     1,    -1,     1,    -1,     1,    -2,     2,    -1,     1,     0,
    -1,     1,    -1,     1,    -1,     0,     0,     0,     0,     0,     0,
     1,    -1,     1,    -1,     1,    -1,     0,     0,     0,     1,     0,
    -1,     1,     0,    -1,     1,    -2,     2,    -2,     2,    -1,     0,
     0,     0,     1,    -1,     1,    -1,     1,    -1,     1,    -1,     1,
     0,     0,    -1,     1,    -1,     1,    -1,     1,    -1,     0,     0,
     0,     0,     1,    -1,     1,     0,    -1,     0,     0,     0,     1,
    -1,     1,    -1,     0,     1,    -1,     0
};
#endif

#if (CONFIG_KEYPAD == IRIVER_H100_PAD) || (CONFIG_KEYPAD == IRIVER_H300_PAD) \
 || (CONFIG_KEYPAD == SANSA_E200_PAD) || (CONFIG_KEYPAD == SAMSUNG_YH_PAD)
#define MET_SYNC
#endif

#define METRONOME_QUIT          PLA_EXIT

#ifdef HAVE_SCROLLWHEEL
#define METRONOME_VOL_UP        PLA_SCROLL_FWD
#define METRONOME_VOL_UP_REP    PLA_SCROLL_FWD_REPEAT
#define METRONOME_VOL_DOWN      PLA_SCROLL_BACK
#define METRONOME_VOL_DOWN_REP  PLA_SCROLL_BACK_REPEAT
#else
#define METRONOME_VOL_UP        PLA_UP
#define METRONOME_VOL_DOWN      PLA_DOWN
#define METRONOME_VOL_UP_REP    PLA_UP_REPEAT
#define METRONOME_VOL_DOWN_REP  PLA_DOWN_REPEAT
#endif
#define METRONOME_LEFT          PLA_LEFT
#define METRONOME_RIGHT         PLA_RIGHT
#define METRONOME_LEFT_REP      PLA_LEFT_REPEAT
#define METRONOME_RIGHT_REP     PLA_RIGHT_REPEAT
#define METRONOME_TAP           PLA_SELECT_REL
#define METRONOME_PAUSE         PLA_CANCEL
#define METRONOME_PLAY          PLA_SELECT_REPEAT

#if defined(MET_SYNC)
enum {
    METRONOME_SYNC  = LAST_PLUGINLIB_ACTION+1,
};
#endif /* IRIVER_H100_PAD||IRIVER_H300_PAD */


#define METRONOME_MSG_START     "start: hold select"
#define METRONOME_MSG_STOP      "stop : cancel"

#ifdef MET_SYNC
static const struct button_mapping iriver_syncaction[] =
{
    {METRONOME_SYNC, BUTTON_REC, BUTTON_NONE },
    LAST_ITEM_IN_LIST__NEXTLIST(CONTEXT_PLUGIN)
};
#endif /* IRIVER_H100_PAD||IRIVER_H300_PAD */

const struct button_mapping *plugin_contexts[] =
{
    pla_main_ctx,
#if defined(MET_SYNC)
    iriver_syncaction,
#endif
};
#define PLA_ARRAY_COUNT sizeof(plugin_contexts)/sizeof(plugin_contexts[0])

static int bpm      = 120;
static int period   = 0;
static int minitick = 0;

static bool sound_active = false;
static bool sound_paused = true;

static char buffer[30];

static bool reset_tap = false;
static int tap_count    = 0;
static int tap_time     = 0;
static int tap_timeout  = 0;

int bpm_step_counter = 0;

#if CONFIG_CODEC != SWCODEC

#define MET_IS_PLAYING rb->mp3_is_playing()
#define MET_PLAY_STOP rb->mp3_play_stop()

void callback(unsigned char** start, size_t* size)
{
    (void)start; /* unused parameter, avoid warning */
    *size = 0; /* end of data */
    sound_active = false;
    rb->led(0);
}

void play_tock(void)
{
    sound_active = true;
    rb->led(1);
    rb->mp3_play_data(sound, sizeof(sound), callback);
    rb->mp3_play_pause(true); /* kickoff audio */ 
}

#else /*  CONFIG_CODEC == SWCODEC */

#define MET_IS_PLAYING rb->pcm_is_playing()
#define MET_PLAY_STOP rb->audio_stop()


bool need_to_play = false;

short sndbuf[sizeof(sound)*2];

/* Convert the mono "tock" sample to interleaved stereo */
static void prepare_tock(void)
{
    int i;
    for(i = 0;i < (int)sizeof(sound)/2;i++) {
        sndbuf[i*2] = sound[i];
        sndbuf[i*2+1] = sound[i];
    }
}

static void play_tock(void)
{
    rb->pcm_play_data(NULL,(unsigned char *)sndbuf,sizeof(sndbuf));
}

#endif /* CONFIG_CODEC != SWCODEC */

static void calc_period(void)
{
    period =  61440/bpm-1; /* (60*1024)/bpm; */
}


static void metronome_draw(struct screen* display)
{
    display->clear_display();

#ifdef HAVE_LCD_BITMAP 
    display->setfont(FONT_SYSFIXED);
    display->puts(0, 0, "Metronome");
    if(display->screen_type==SCREEN_MAIN)
    {
        display->puts(0, 5, "Select to TAP");
        display->puts(0, 6, "Rec to SYNC");
    }
#ifdef HAVE_REMOTE_LCD
    else
    {
        display->puts(0, 5, "Rec to TAP");
        display->puts(0, 6, "Mode to SYNC");
    }
#endif
#endif /* HAVE_LCD_BITMAP */

    rb->snprintf(buffer, sizeof(buffer), "BPM: %d ",bpm);
#ifdef HAVE_LCD_BITMAP
    display->puts(0,3, buffer);
#else
    display->puts(0,0, buffer);
#endif /* HAVE_LCD_BITMAP */

    rb->snprintf(buffer, sizeof(buffer), "Vol: %d",
                 rb->global_settings->volume);
#ifdef HAVE_LCD_BITMAP
    display->puts(10, 3, buffer);
#else
    display->puts(0,1, buffer);
#endif /* HAVE_LCD_BITMAP */

#ifdef HAVE_LCD_BITMAP
    display->hline(0, 111, 12);
    if(sound_paused)
        display->puts(0,2,METRONOME_MSG_START);
    else
        display->puts(0,2,METRONOME_MSG_STOP);
    display->setfont(FONT_UI);
#endif /* HAVE_LCD_BITMAP */
    display->update();
}

static void draw_display(void)
{
    FOR_NB_SCREENS(i)
        metronome_draw(rb->screens[i]);
}

/* helper function to change the volume by a certain amount, +/-
   ripped from video.c */
static void change_volume(int delta)
{
    int minvol = rb->sound_min(SOUND_VOLUME);
    int maxvol = rb->sound_max(SOUND_VOLUME);
    int vol = rb->global_settings->volume + delta;

    if (vol > maxvol) vol = maxvol;
    else if (vol < minvol) vol = minvol;
    if (vol != rb->global_settings->volume) {
        rb->sound_set(SOUND_VOLUME, vol);
        rb->global_settings->volume = vol;
        draw_display();
    }
}

/*function to accelerate bpm change*/
static void change_bpm(int direction)
{
    if((bpm_step_counter < 20)
            || (bpm > 389)
            || (bpm < 10))
        bpm = bpm + direction;
    else if (bpm_step_counter < 60)
        bpm = bpm + direction * 2;
    else
        bpm = bpm + direction * 9; 

    if (bpm > 400) bpm = 400;
    if (bpm < 1) bpm = 1;
    calc_period();
    draw_display();
    bpm_step_counter++;
}

static void timer_callback(void)
{
    if(minitick >= period){
        minitick = 0;
        if(!sound_active && !sound_paused && !tap_count) {
#if CONFIG_CODEC == SWCODEC
            /* On SWCODEC we can't call play_tock() directly from an ISR. */
            need_to_play = true;
#else
            play_tock();
#endif
            rb->reset_poweroff_timer();
        }
    }
    else {
        minitick++;
    }

    if (tap_count) {
        tap_time++;
        if (tap_count > 1 && tap_time > tap_timeout)
            tap_count = 0;
    }
}

static void cleanup(void)
{
    rb->timer_unregister();
    MET_PLAY_STOP; /* stop audio ISR */
    rb->led(0);
#if CONFIG_CODEC == SWCODEC
    rb->pcm_set_frequency(HW_SAMPR_DEFAULT);
#endif
}

static void tap(void)
{
    if (tap_count == 0 || tap_time < tap_count) {
        tap_time = 0;
    } 
    else {
        if (tap_time > 0) {
            bpm = 61440/(tap_time/tap_count);

            if (bpm > 400)
                bpm = 400;
        }

        calc_period();
        draw_display();

        tap_timeout = (tap_count+2)*tap_time/tap_count;
    }

    tap_count++;
    minitick = 0;  /* sync tock to tapping */
    play_tock();

    reset_tap = false;
}

enum plugin_status plugin_start(const void* parameter)
{
    int button;
    static int last_button = BUTTON_NONE;

    (void)parameter;
    atexit(cleanup);

    if (MET_IS_PLAYING)
        MET_PLAY_STOP; /* stop audio IS */

#if CONFIG_CODEC != SWCODEC
    rb->bitswap(sound, sizeof(sound));
#else
    prepare_tock();
#if INPUT_SRC_CAPS != 0
    /* Select playback */
    rb->audio_set_input_source(AUDIO_SRC_PLAYBACK, SRCF_PLAYBACK);
    rb->audio_set_output_source(AUDIO_SRC_PLAYBACK);
#endif
    rb->pcm_set_frequency(SAMPR_44);
#endif /* CONFIG_CODEC != SWCODEC */

    calc_period();
    rb->timer_register(1, NULL, TIMER_FREQ/1024, timer_callback IF_COP(, CPU));

    draw_display();

    /* main loop */
    while (true){
        reset_tap = true;
#if CONFIG_CODEC == SWCODEC
        button = pluginlib_getaction(TIMEOUT_NOBLOCK,plugin_contexts,PLA_ARRAY_COUNT);
        if (need_to_play)
        {
            need_to_play = false;
            play_tock();
        }
#else
        button = pluginlib_getaction(TIMEOUT_BLOCK,
                                     plugin_contexts,PLA_ARRAY_COUNT);
#endif /* SWCODEC */
        switch (button) {

            case METRONOME_QUIT:
                /* get out of here */
                return PLUGIN_OK;

            case METRONOME_PAUSE:
                if(!sound_paused)
                {
                    sound_paused = true;
                    draw_display();
                }
                break;
            case METRONOME_PLAY:
                if(sound_paused)
                {
                    sound_paused = false;
                    calc_period();
                    draw_display();
                }
                break;
            case METRONOME_TAP:
                if (last_button != METRONOME_PLAY)
                    tap();
                break;
            case METRONOME_VOL_UP:
            case METRONOME_VOL_UP_REP:
                change_volume(1);
                calc_period();
                break;

            case METRONOME_VOL_DOWN:
            case METRONOME_VOL_DOWN_REP:
                change_volume(-1);
                calc_period();
                break;

            case METRONOME_LEFT:
                bpm_step_counter = 0;
            case METRONOME_LEFT_REP:
                change_bpm(-1);
                break;

            case METRONOME_RIGHT:
                bpm_step_counter = 0;
            case METRONOME_RIGHT_REP:
                change_bpm(1);
                break;

#ifdef MET_SYNC
            case METRONOME_SYNC:
                minitick = period;
                break;
#endif

            default:
                exit_on_usb(button);
                reset_tap = false;
                break;

        }
        if (button)
            last_button = button;
        if (reset_tap) {
            tap_count = 0;
        }
        rb->yield();
    }
}

