/***************************************************************************
 *             __________               __   ___.
 *   Open      \______   \ ____   ____ |  | _\_ |__   _______  ___
 *   Source     |       _//  _ \_/ ___\|  |/ /| __ \ /  _ \  \/  /
 *   Jukebox    |    |   (  <_> )  \___|    < | \_\ (  <_> > <  <
 *   Firmware   |____|_  /\____/ \___  >__|_ \|___  /\____/__/\_ \
 *                     \/            \/     \/    \/            \/
 * $Id$
 *
 * Copyright (c) 2010 Michael Sevakis
 *
 * i.MX31 IOMUXC helper routines
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
 * KIND, either express or implied.
 *
 ****************************************************************************/
#ifndef _IOMUXC_IMX31_H_
#define _IOMUXC_IMX31_H_

enum IMX31_IOMUXC_PINS
{
    IOMUXC_TTM_PAD       =   0,
    IOMUXC_CSPI3_SPI_RDY =   1,
    IOMUXC_CSPI3_SCLK    =   2,
    IOMUXC_CSPI3_MISO    =   3,
    IOMUXC_CSPI3_MOSI    =   4,
    IOMUXC_CLKSS         =   5,
    IOMUXC_CE_CONTROL    =   6,
    IOMUXC_ATA_RST_B     =   7,
    IOMUXC_ATA_DMACK     =   8,
    IOMUXC_ATA_DIOW      =   9,
    IOMUXC_ATA_DIOR      =  10,
    IOMUXC_ATA_CS1       =  11,
    IOMUXC_ATA_CS0       =  12,
    IOMUXC_SD1_DATA3     =  13,
    IOMUXC_SD1_DATA2     =  14,
    IOMUXC_SD1_DATA1     =  15,
    IOMUXC_SD1_DATA0     =  16,
    IOMUXC_SD1_CLK       =  17,
    IOMUXC_SD1_CMD       =  18,
    IOMUXC_D3_SPL        =  19,
    IOMUXC_D3_CLS        =  20,
    IOMUXC_D3_REV        =  21,
    IOMUXC_CONTRAST      =  22,
    IOMUXC_VSYNC3        =  23,
    IOMUXC_READ          =  24,
    IOMUXC_WRITE         =  25,
    IOMUXC_PAR_RS        =  26,
    IOMUXC_SER_RS        =  27,
    IOMUXC_LCS1          =  28,
    IOMUXC_LCS0          =  29,
    IOMUXC_SD_D_CLK      =  30,
    IOMUXC_SD_D_IO       =  31,
    IOMUXC_SD_D_I        =  32,
    IOMUXC_DRDY0         =  33,
    IOMUXC_FPSHIFT       =  34,
    IOMUXC_HSYNC         =  35,
    IOMUXC_VSYNC0        =  36,
    IOMUXC_LD17          =  37,
    IOMUXC_LD16          =  38,
    IOMUXC_LD15          =  39,
    IOMUXC_LD14          =  40,
    IOMUXC_LD13          =  41,
    IOMUXC_LD12          =  42,
    IOMUXC_LD11          =  43,
    IOMUXC_LD10          =  44,
    IOMUXC_LD9           =  45,
    IOMUXC_LD8           =  46,
    IOMUXC_LD7           =  47,
    IOMUXC_LD6           =  48,
    IOMUXC_LD5           =  49,
    IOMUXC_LD4           =  50,
    IOMUXC_LD3           =  51,
    IOMUXC_LD2           =  52,
    IOMUXC_LD1           =  53,
    IOMUXC_LD0           =  54,
    IOMUXC_USBH2_DATA1   =  55,
    IOMUXC_USBH2_DATA0   =  56,
    IOMUXC_USBH2_NXT     =  57,
    IOMUXC_USBH2_STP     =  58,
    IOMUXC_USBH2_DIR     =  59,
    IOMUXC_USBH2_CLK     =  60,
    IOMUXC_USBOTG_DATA7  =  61,
    IOMUXC_USBOTG_DATA6  =  62,
    IOMUXC_USBOTG_DATA5  =  63,
    IOMUXC_USBOTG_DATA4  =  64,
    IOMUXC_USBOTG_DATA3  =  65,
    IOMUXC_USBOTG_DATA2  =  66,
    IOMUXC_USBOTG_DATA1  =  67,
    IOMUXC_USBOTG_DATA0  =  68,
    IOMUXC_USBOTG_NXT    =  69,
    IOMUXC_USBOTG_STP    =  70,
    IOMUXC_USBOTG_DIR    =  71,
    IOMUXC_USBOTG_CLK    =  72,
    IOMUXC_USB_BYP       =  73,
    IOMUXC_USB_OC        =  74,
    IOMUXC_USB_PWR       =  75,
    IOMUXC_SJC_MOD       =  76,
    IOMUXC_DE_B          =  77,
    IOMUXC_TRSTB         =  78,
    IOMUXC_TDO           =  79,
    IOMUXC_TDI           =  80,
    IOMUXC_TMS           =  81,
    IOMUXC_TCK           =  82,
    IOMUXC_RTCK          =  83,
    IOMUXC_KEY_COL7      =  84,
    IOMUXC_KEY_COL6      =  85,
    IOMUXC_KEY_COL5      =  86,
    IOMUXC_KEY_COL4      =  87,
    IOMUXC_KEY_COL3      =  88,
    IOMUXC_KEY_COL2      =  89,
    IOMUXC_KEY_COL1      =  90,
    IOMUXC_KEY_COL0      =  91,
    IOMUXC_KEY_ROW7      =  92,
    IOMUXC_KEY_ROW6      =  93,
    IOMUXC_KEY_ROW5      =  94,
    IOMUXC_KEY_ROW4      =  95,
    IOMUXC_KEY_ROW3      =  96,
    IOMUXC_KEY_ROW2      =  97,
    IOMUXC_KEY_ROW1      =  98,
    IOMUXC_KEY_ROW0      =  99,
    IOMUXC_BATT_LINE     = 100,
    IOMUXC_CTS2          = 101,
    IOMUXC_RTS2          = 102,
    IOMUXC_TXD2          = 103,
    IOMUXC_RXD2          = 104,
    IOMUXC_DTR_DCE2      = 105,
    IOMUXC_DCD_DTE1      = 106,
    IOMUXC_RI_DTE1       = 107,
    IOMUXC_DSR_DTE1      = 108,
    IOMUXC_DTR_DTE1      = 109,
    IOMUXC_DCD_DCE1      = 110,
    IOMUXC_RI_DCE1       = 111,
    IOMUXC_DSR_DCE1      = 112,
    IOMUXC_DTR_DCE1      = 113,
    IOMUXC_CTS1          = 114,
    IOMUXC_RTS1          = 115,
    IOMUXC_TXD1          = 116,
    IOMUXC_RXD1          = 117,
    IOMUXC_CSPI2_SPI_RDY = 118,
    IOMUXC_CSPI2_SCLK    = 119,
    IOMUXC_CSPI2_SS2     = 120,
    IOMUXC_CSPI2_SS1     = 121,
    IOMUXC_CSPI2_SS0     = 122,
    IOMUXC_CSPI2_MISO    = 123,
    IOMUXC_CSPI2_MOSI    = 124,
    IOMUXC_CSPI1_SPI_RDY = 125,
    IOMUXC_CSPI1_SCLK    = 126,
    IOMUXC_CSPI1_SS2     = 127,
    IOMUXC_CSPI1_SS1     = 128,
    IOMUXC_CSPI1_SS0     = 129,
    IOMUXC_CSPI1_MISO    = 130,
    IOMUXC_CSPI1_MOSI    = 131,
    IOMUXC_SFS6          = 132,
    IOMUXC_SCK6          = 133,
    IOMUXC_SRXD6         = 134,
    IOMUXC_STXD6         = 135,
    IOMUXC_SFS5          = 136,
    IOMUXC_SCK5          = 137,
    IOMUXC_SRXD5         = 138,
    IOMUXC_STXD5         = 139,
    IOMUXC_SFS4          = 140,
    IOMUXC_SCK4          = 141,
    IOMUXC_SRXD4         = 142,
    IOMUXC_STXD4         = 143,
    IOMUXC_SFS3          = 144,
    IOMUXC_SCK3          = 145,
    IOMUXC_SRXD3         = 146,
    IOMUXC_STXD3         = 147,
    IOMUXC_I2C_DAT       = 148,
    IOMUXC_I2C_CLK       = 149,
    IOMUXC_CSI_PIXCLK    = 150,
    IOMUXC_CSI_HSYNC     = 151,
    IOMUXC_CSI_VSYNC     = 152,
    IOMUXC_CSI_MCLK      = 153,
    IOMUXC_CSI_D15       = 154,
    IOMUXC_CSI_D14       = 155,
    IOMUXC_CSI_D13       = 156,
    IOMUXC_CSI_D12       = 157,
    IOMUXC_CSI_D11       = 158,
    IOMUXC_CSI_D10       = 159,
    IOMUXC_CSI_D9        = 160,
    IOMUXC_CSI_D8        = 161,
    IOMUXC_CSI_D7        = 162,
    IOMUXC_CSI_D6        = 163,
    IOMUXC_CSI_D5        = 164,
    IOMUXC_CSI_D4        = 165,
    IOMUXC_M_GRANT       = 166,
    IOMUXC_M_REQUEST     = 167,
    IOMUXC_PC_POE        = 168,
    IOMUXC_PC_RW_B       = 169,
    IOMUXC_IOIS16        = 170,
    IOMUXC_PC_RST        = 171,
    IOMUXC_PC_BVD2       = 172,
    IOMUXC_PC_BVD1       = 173,
    IOMUXC_PC_VS2        = 174,
    IOMUXC_PC_VS1        = 175,
    IOMUXC_PC_PWRON      = 176,
    IOMUXC_PC_READY      = 177,
    IOMUXC_PC_WAIT_B     = 178,
    IOMUXC_PC_CD2_B      = 179,
    IOMUXC_PC_CD1_B      = 180,
    IOMUXC_D0            = 181,
    IOMUXC_D1            = 182,
    IOMUXC_D2            = 183,
    IOMUXC_D3            = 184,
    IOMUXC_D4            = 185,
    IOMUXC_D5            = 186,
    IOMUXC_D6            = 187,
    IOMUXC_D7            = 188,
    IOMUXC_D8            = 189,
    IOMUXC_D9            = 190,
    IOMUXC_D10           = 191,
    IOMUXC_D11           = 192,
    IOMUXC_D12           = 193,
    IOMUXC_D13           = 194,
    IOMUXC_D14           = 195,
    IOMUXC_D15           = 196,
    IOMUXC_NFRB          = 197,
    IOMUXC_NFCE_B        = 198,
    IOMUXC_NFWP_B        = 199,
    IOMUXC_NFCLE         = 200,
    IOMUXC_NFALE         = 201,
    IOMUXC_NFRE_B        = 202,
    IOMUXC_NFWE_B        = 203,
    IOMUXC_SDQS3         = 204,
    IOMUXC_SDQS2         = 205,
    IOMUXC_SDQS1         = 206,
    IOMUXC_SDQS0         = 207,
    IOMUXC_RESERVED0     = 208,
    IOMUXC_SDCLK         = 209,
    IOMUXC_SDCKE1        = 210,
    IOMUXC_SDCKE0        = 211,
    IOMUXC_SDWE          = 212,
    IOMUXC_CAS           = 213,
    IOMUXC_RAS           = 214,
    IOMUXC_RW            = 215,
    IOMUXC_BCLK          = 216,
    IOMUXC_LBA           = 217,
    IOMUXC_ECB           = 218,
    IOMUXC_CS5           = 219,
    IOMUXC_CS4           = 220,
    IOMUXC_CS3           = 221,
    IOMUXC_CS2           = 222,
    IOMUXC_CS1           = 223,
    IOMUXC_CS0           = 224,
    IOMUXC_OE            = 225,
    IOMUXC_EB1           = 226,
    IOMUXC_EB0           = 227,
    IOMUXC_DQM3          = 228,
    IOMUXC_DQM2          = 229,
    IOMUXC_DQM1          = 230,
    IOMUXC_DQM0          = 231,
    IOMUXC_SD31          = 232,
    IOMUXC_SD30          = 233,
    IOMUXC_SD29          = 234,
    IOMUXC_SD28          = 235,
    IOMUXC_SD27          = 236,
    IOMUXC_SD26          = 237,
    IOMUXC_SD25          = 238,
    IOMUXC_SD24          = 239,
    IOMUXC_SD23          = 240,
    IOMUXC_SD22          = 241,
    IOMUXC_SD21          = 242,
    IOMUXC_SD20          = 243,
    IOMUXC_SD19          = 244,
    IOMUXC_SD18          = 245,
    IOMUXC_SD17          = 246,
    IOMUXC_SD16          = 247,
    IOMUXC_SD15          = 248,
    IOMUXC_SD14          = 249,
    IOMUXC_SD13          = 250,
    IOMUXC_SD12          = 251,
    IOMUXC_SD11          = 252,
    IOMUXC_SD10          = 253,
    IOMUXC_SD9           = 254,
    IOMUXC_SD8           = 255,
    IOMUXC_SD7           = 256,
    IOMUXC_SD6           = 257,
    IOMUXC_SD5           = 258,
    IOMUXC_SD4           = 259,
    IOMUXC_SD3           = 260,
    IOMUXC_SD2           = 261,
    IOMUXC_SD1           = 262,
    IOMUXC_SD0           = 263,
    IOMUXC_SDBA0         = 264,
    IOMUXC_SDBA1         = 265,
    IOMUXC_A25           = 266,
    IOMUXC_A24           = 267,
    IOMUXC_A23           = 268,
    IOMUXC_A22           = 269,
    IOMUXC_A21           = 270,
    IOMUXC_A20           = 271,
    IOMUXC_A19           = 272,
    IOMUXC_A18           = 273,
    IOMUXC_A17           = 274,
    IOMUXC_A16           = 275,
    IOMUXC_A15           = 276,
    IOMUXC_A14           = 277,
    IOMUXC_A13           = 278,
    IOMUXC_A12           = 279,
    IOMUXC_A11           = 280,
    IOMUXC_MA10          = 281,
    IOMUXC_A10           = 282,
    IOMUXC_A9            = 283,
    IOMUXC_A8            = 284,
    IOMUXC_A7            = 285,
    IOMUXC_A6            = 286,
    IOMUXC_A5            = 287,
    IOMUXC_A4            = 288,
    IOMUXC_A3            = 289,
    IOMUXC_A2            = 290,
    IOMUXC_A1            = 291,
    IOMUXC_A0            = 292,
    IOMUXC_VPG1          = 293,
    IOMUXC_VPG0          = 294,
    IOMUXC_DVFS1         = 295,
    IOMUXC_DVFS0         = 296,
    IOMUXC_VSTBY         = 297,
    IOMUXC_POWER_FAIL    = 298,
    IOMUXC_CKIL          = 299,
    IOMUXC_BOOT_MODE4    = 300,
    IOMUXC_BOOT_MODE3    = 301,
    IOMUXC_BOOT_MODE2    = 302,
    IOMUXC_BOOT_MODE1    = 303,
    IOMUXC_BOOT_MODE0    = 304,
    IOMUXC_CLKO          = 305,
    IOMUXC_POR_B         = 306,
    IOMUXC_RESET_IN_B    = 307,
    IOMUXC_CKIH          = 308,
    IOMUXC_SIMPD0        = 309,
    IOMUXC_SRX0          = 310,
    IOMUXC_STX0          = 311,
    IOMUXC_SVEN0         = 312,
    IOMUXC_SRST0         = 313,
    IOMUXC_SCLK0         = 314,
    IOMUXC_GPIO3_1       = 315,
    IOMUXC_GPIO3_0       = 316,
    IOMUXC_GPIO1_6       = 317,
    IOMUXC_GPIO1_5       = 318,
    IOMUXC_GPIO1_4       = 319,
    IOMUXC_GPIO1_3       = 320,
    IOMUXC_GPIO1_2       = 321,
    IOMUXC_GPIO1_1       = 322,
    IOMUXC_GPIO1_0       = 323,
    IOMUXC_PWMO          = 324,
    IOMUXC_WATCHDOG_RST  = 325,
    IOMUXC_COMPARE       = 326,
    IOMUXC_CAPTURE       = 327,
};

/* Set the pin multiplexing configuration (functional, GPIO, etc.) */
void iomuxc_set_pin_mux(enum IMX31_IOMUXC_PINS pin, unsigned long mux);

/* Set the pin pad configuration (keeper, drive strength, etc.) */
void iomuxc_set_pad_config(enum IMX31_IOMUXC_PINS pin, unsigned long config);

#endif /* _IOMUXC_IMX31_H_ */
