/*
 * COOK compatible decoder fixed point data types and constants
 * Copyright (c) 2007 Ian Braithwaite
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 */

/**
 * @file cookdata_fixpoint.h
 * Cook AKA RealAudio G2 compatible decoder
 * fixed point data types and constants
 */

#include <inttypes.h>
typedef int32_t FIXP;           /* Fixed point variable type */
typedef uint16_t FIXPU;         /* Fixed point fraction 0<=x<1 */

typedef FIXP REAL_T;


/* No additional variables in COOKContext
 * for fixed point routines
 */
typedef struct {
} realvars_t;

static const FIXPU pow128_tab[128] = {
    /* x_i = 2^(15+i/128) */
    0x8000, 0x80b2, 0x8165, 0x8219, 0x82ce, 0x8383, 0x843a, 0x84f2, 0x85ab,
    0x8665, 0x871f, 0x87db, 0x8898, 0x8956, 0x8a15, 0x8ad5, 0x8b96, 0x8c58,
    0x8d1b, 0x8ddf, 0x8ea4, 0x8f6b, 0x9032, 0x90fa, 0x91c4, 0x928e, 0x935a,
    0x9427, 0x94f5, 0x95c4, 0x9694, 0x9765, 0x9838, 0x990c, 0x99e0, 0x9ab6,
    0x9b8d, 0x9c65, 0x9d3f, 0x9e19, 0x9ef5, 0x9fd2, 0xa0b0, 0xa190, 0xa270,
    0xa352, 0xa435, 0xa519, 0xa5ff, 0xa6e6, 0xa7ce, 0xa8b7, 0xa9a1, 0xaa8d,
    0xab7a, 0xac69, 0xad58, 0xae49, 0xaf3b, 0xb02f, 0xb124, 0xb21a, 0xb312,
    0xb40b, 0xb505, 0xb601, 0xb6fe, 0xb7fc, 0xb8fc, 0xb9fd, 0xbaff, 0xbc03,
    0xbd09, 0xbe0f, 0xbf18, 0xc021, 0xc12c, 0xc239, 0xc347, 0xc456, 0xc567,
    0xc67a, 0xc78d, 0xc8a3, 0xc9ba, 0xcad2, 0xcbec, 0xcd08, 0xce25, 0xcf43,
    0xd063, 0xd185, 0xd2a8, 0xd3cd, 0xd4f3, 0xd61b, 0xd745, 0xd870, 0xd99d,
    0xdacc, 0xdbfc, 0xdd2e, 0xde61, 0xdf96, 0xe0cd, 0xe205, 0xe340, 0xe47b,
    0xe5b9, 0xe6f8, 0xe839, 0xe97c, 0xeac1, 0xec07, 0xed4f, 0xee99, 0xefe5,
    0xf132, 0xf281, 0xf3d3, 0xf525, 0xf67a, 0xf7d1, 0xf929, 0xfa84, 0xfbe0,
    0xfd3e, 0xfe9e
};



/* dither_table and quant_centroid_table.
 * Index 1: [0] - scaled by 2^13, [1] - scaled by 2^13 / sqrt(2)
 * Index 2: [0..7] - category
 * Index 3: [0] - dither_table, [1..13] - quant_centroid_table
 */
static const FIXP quant_tables[2][8][14] ICONST_ATTR = {{{
    0x00000000, 0x0645a1cb, 0x0c2d0e56, 0x11eb851f, 0x17a1cac1, 0x1d4fdf3b,
    0x22ed9168, 0x28a7ef9e, 0x2e49ba5e, 0x33eb851f, 0x39916873, 0x3f126e98,
    0x449ba5e3, 0x4b958106
},{
    0x00000000, 0x08b43958, 0x10f5c28f, 0x19020c4a, 0x2116872b, 0x2922d0e5,
    0x3126e979, 0x38fdf3b6, 0x411eb852, 0x49eb851f, 0x00000000, 0x00000000,
    0x00000000, 0x00000000
},{
    0x00000000, 0x0bef9db2, 0x176c8b44, 0x22e147ae, 0x2e1cac08, 0x39581062,
    0x450e5604, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000
},{
    0x00000000, 0x10189375, 0x20000000, 0x2fe353f8, 0x3fc28f5c, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000
},{
    0x00000000, 0x1522d0e5, 0x2b3f7cee, 0x3fba5e35, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000
},{
    0x02d413cd, 0x1a83126f, 0x37db22d1, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000
},{
    0x04000000, 0x1f6c8b44, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000
},{
    0x0b504f33, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000
}},{{
    0x00000000, 0x046f5a70, 0x089c1768, 0x0cabddd3, 0x10b5d955, 0x14ba09ed,
    0x18b2a4b4, 0x1cbf85aa, 0x20bb05e5, 0x24b68620, 0x28b4ebcf, 0x2c994066,
    0x30835fe6, 0x35722a5e
},{
    0x00000000, 0x062797a1, 0x0bfe1683, 0x11aeee7a, 0x1765915b, 0x1d166952,
    0x22c17660, 0x284ca76c, 0x2e0bfaaa, 0x3444f306, 0x00000000, 0x00000000,
    0x00000000, 0x00000000
},{
    0x00000000, 0x0870a594, 0x1090326a, 0x18a9f456, 0x209b29e3, 0x288c5f70,
    0x30d478a5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000
},{
    0x00000000, 0x0b61afee, 0x16a09e66, 0x21dca76a, 0x2d15caf9, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000
},{
    0x00000000, 0x0ef20652, 0x1e94b968, 0x2d100010, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000
},{
    0x02000000, 0x12bf2f44, 0x277f041b, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000
},{
    0x02d413cd, 0x16385a03, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000
},{
    0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000
}}};

static const FIXPU cplscale2[3] = {
    /* 2^16 C_ij */
    0xf3f9, 0xb505, 0x4d8b
};
static const FIXPU cplscale3[7] = {
    /* 2^16 C_ij */
    0xfb35, 0xefdf, 0xe03d, 0xb505, 0x7b81, 0x596e, 0x314d
};
static const FIXPU cplscale4[15] = {
    /* 2^16 C_ij */
    0xfdd2, 0xf927, 0xf3f9, 0xee1d, 0xe749, 0xdee9, 0xd381, 0xb505, 0x903b,
    0x7de2, 0x6dbe, 0x5e02, 0x4d8b, 0x3ad1, 0x2155
};
static const FIXPU cplscale5[31] = {
    /* 2^16 C_ij */
    0xfef5, 0xfcce, 0xfa8e, 0xf832, 0xf5b5, 0xf314, 0xf049, 0xed4c, 0xea12,
    0xe68e, 0xe2ab, 0xde4b, 0xd938, 0xd30b, 0xcab6, 0xb505, 0x9c59, 0x90e8,
    0x8778, 0x7ef9, 0x76fc, 0x6f45, 0x67ab, 0x600e, 0x5850, 0x504d, 0x47db,
    0x3ebd, 0x3486, 0x2853, 0x1715
};
static const FIXPU cplscale6[63] = {
    /* 2^16 C_ij */
    0xff7d, 0xfe74, 0xfd65, 0xfc50, 0xfb35, 0xfa14, 0xf8eb, 0xf7bb, 0xf683,
    0xf543, 0xf3f9, 0xf2a6, 0xf148, 0xefdf, 0xee6a, 0xece6, 0xeb54, 0xe9b2,
    0xe7fd, 0xe634, 0xe453, 0xe258, 0xe03d, 0xddff, 0xdb94, 0xd8f4, 0xd610,
    0xd2d2, 0xcf13, 0xca8c, 0xc47c, 0xb505, 0xa41a, 0x9c90, 0x9685, 0x913a,
    0x8c67, 0x87e5, 0x839c, 0x7f7e, 0x7b81, 0x779b, 0x73c7, 0x6fff, 0x6c3f,
    0x6883, 0x64c7, 0x6107, 0x5d40, 0x596e, 0x558d, 0x5198, 0x4d8b, 0x495f,
    0x450d, 0x408b, 0x3bcd, 0x36c1, 0x314d, 0x2b4a, 0x246e, 0x1c1a, 0x1029
};

