/***************************************************************************
 *             __________               __   ___.
 *   Open      \______   \ ____   ____ |  | _\_ |__   _______  ___
 *   Source     |       _//  _ \_/ ___\|  |/ /| __ \ /  _ \  \/  /
 *   Jukebox    |    |   (  <_> )  \___|    < | \_\ (  <_> > <  <
 *   Firmware   |____|_  /\____/ \___  >__|_ \|___  /\____/__/\_ \
 *                     \/            \/     \/    \/            \/
 * $Id: skin_buffer.c 25962 2010-05-12 09:31:40Z jdgordon $
 *
 * Copyright (C) 2002 by Linus Nielsen Feltzing
 * Copyright (C) 2009 Jonathan Gordon
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
 * KIND, either express or implied.
 *
 ****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#ifndef _SKIN_BUFFFER_H_
#define _SKIN_BUFFFER_H_
void skin_buffer_init(char* buffer, size_t size);
/* Allocate size bytes from the buffer */
void* skin_buffer_alloc(size_t size);

/* get the number of bytes currently being used */
size_t skin_buffer_usage(void);
size_t skin_buffer_freespace(void);

/* save and restore a buffer position incase a skin fails to load */
void skin_buffer_save_position(void);
void skin_buffer_restore_position(void);
#endif
