/* getmaps_osm_start.c - helper utilities for OpenStreetMap maps
 *
 * Copyright 2008 Charles Werbick
 * This file is part of Roadmap for Maemo (among others, see below ;-)
 *
 * LICENSE:
 *
 *   Copyright 2007 Paul G. Fox
 *
 *   This file is part of RoadMap.
 *
 *   RoadMap is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   RoadMap is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with RoadMap; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * SYNOPSYS:
 *
 * These functions are used to get maps from OSM
 *
 * 
 */
#ifndef INCLUDE__GETMAPS_OSM_START__H
#define INCLUDE__GETMAPS_OSM_START__H
#include <gtk/gtk.h>

struct GetMapsData {
   gdouble lat1;
   gdouble lat2;
   gdouble lon1;
   gdouble lon2;
   gint radius;
   gint osm_bits;
   gboolean replace_maps;
   gboolean radius_mode;
   gchar *maps;
   gchar *source;
   gchar *class;

};

int getmaps (int osm_bits, int replace, char *maps, char *source, char* class, char *latlonarg );


#endif /* INCLUDE__GETMAPS_OSM_START__H */
