#!/usr/bin/python2.5
# rapier: a small bible reader for maemo.
# Copyright 2007 Pierre Amadio 
# pierre.amadio@libertysurf.fr
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 2.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""
http://developer.gnome.org/doc/API/gnome-vfs/
"""
import Sword
from gnome import gnomevfs
import os
import tarfile
import re
import osso
from gnome import gconf
import sys


debugFile="/tmp/rapier-debug.txt"

def debug(snt):
    gconf_client=gconf.client_get_default()
    if not gconf_client.get_bool('/apps/osso/rapier/debug/enabled'):
        return
    f=open(debugFile,'a')
    snt=str(snt)
    f.write(snt+'\n')
    f.close()
    
    
def get_manager(*args):
    data_path = get_data_path()
    mgr = Sword.SWMgr(*args)
    if data_path:
        mgr.prefixPath = data_path
        mgr.configPath = "%s/mods.d" % data_path
        mgr.augmentModules(data_path)
    return mgr

def get_data_path():
    gconf_client=gconf.client_get_default()
    return gconf_client.get_string("/apps/osso/rapier/data_path")

def get_config():
    sword_mgr=Sword.SWMgr()
    sword_conf_path=sword_mgr.globalConfPath
    uri=gnomevfs.URI(sword_conf_path)
    sword_conf=gnomevfs.Handle(uri,open_mode=gnomevfs.OPEN_READ)
    size=sword_conf.get_file_info().size
    content=sword_conf.read(size)
    sword_conf.close()
    return content

def set_DataPath(value):
    sword_conf_path = "%s/sword.conf" % value

    uri=gnomevfs.URI(sword_conf_path)
    try:
        sword_conf=gnomevfs.create(uri,open_mode=gnomevfs.OPEN_WRITE)
    except gnomevfs.Error,fault:
        print "ouuups, probelm setting conf to %s: %s" % (uri, fault)
        return fault
    
    sword_conf.write("[Install]\nDataPath=%s"%value)
    sword_conf.close()

def has_clucene_index(mgr, modName):
    a=mgr.getModule(modName)
    return a.isSearchOptimallySupported('plop',-4,1,Sword.VerseKey())

def has_strong_number(mgr,modName):
    mod=mgr.getModule(modName)
    if mod.getConfigEntry("Feature")=="StrongsNumbers":
        return True
    else:
        return False
    
        

class InstallMgr:
    """
    The sword swing binding does not seems to make InstallMgr
    available, so here comes a small class to handle installation
    of remote Sword modules.
    """

    def __init__(self,dataPath,location='ftp://crosswire.org/pub/sword/raw',\
                 osso_context=False):
        self.mgr=get_manager()
        self.rep_location=location
        self.data_path = dataPath
        self.tmpDir=dataPath+"/tmp"
        self.osso_context=osso_context
        if not os.path.isdir(self.tmpDir):
            os.mkdir(self.tmpDir)


    def system_info(self,msg):
        sysnote=osso.SystemNote(self.osso_context)
        sysnote.system_note_infoprint(msg)


    def remove_index(self,mod):
        self.system_info("Removing index for %s"%mod)
        swmod=self.mgr.getModule(mod)
        swmod.deleteSearchFramework()
        self.mgr=Sword.SWMgr()
        return True


    def create_index(self,mod):
        #cmd="/scratchbox/tools/bin/strace /usr/bin/mkfastmod %s 1>/tmp/1.log 2>/tmp/2.log"%mod
        #cmd="cd /home/melmoth ;run-standalone.sh /usr/bin/strace /usr/bin/mkfastmod %s 1>/tmp/1.log 2>/tmp/2.log"%mod

        '''
        This segfault
        cmd="/usr/bin/mkfastmod %s"%mod
        '''
        cmd="cd /home;SWORD_PATH=%s /usr/bin/mkfastmod %s"%\
             (get_data_path(),mod)
        
        #cmd="ls /tmp"
        debug("cmd='%s'"%cmd)
        self.system_info("Creating index for %s"%mod)
        try:
            pipe=os.popen(cmd,'r')
            data=pipe.read()
            error=pipe.close()
        except:
            debug("Oy, creating index failed.")
            return False
        
        self.mgr=get_manager()
        debug("data='%s'"%data)
        if error:
            debug("There was an error:'%i'"%error)
            self.system_info("Error when creating the index !")
            return False

        self.system_info("Index created")
        debug("Index created !")
        return True

    def remove_module(self,mod):
        print "Let's remove '%s'"%mod
        data_path=get_data_path()
        self.system_info("Removing %s module."%mod)
        cmd="SWORD_PATH=%s /usr/bin/installmgr -u '%s'"%(data_path,mod)
        pipe=os.popen(cmd,'r')
        pipe.close()
        self.mgr=Sword.SWMgr()
        return True

        
    def install_module(self,dataPath,conf_file):
        """
        dataPath ./modules/texts/ztext/sparv/
        conf file sparv.conf

        Return True if installation succeed.
        Return False otherwise.
        
        """

        self.system_info("Installing %s"%conf_file)
        debug("install_module(self,'%s','%s')"%(dataPath,conf_file))


        self.mgr=Sword.SWMgr()
        modDirNameReg=re.compile("^.*/(\w+)/?\s*$")
        if modDirNameReg.search(dataPath):
            modDirName=modDirNameReg.search(dataPath).group(1)
            debug("modDirName='%s'"%modDirName)
        else:
            debug("Problem finding a directory for: %s"%dataPath)


        
        #local_data_path=self.mgr.globalConfPath

        remote_conf=self.rep_location+"/mods.d/"+conf_file
        remote_conf_uri=gnomevfs.URI(remote_conf)

        remote_mod=self.rep_location+"/"+dataPath
        """
        I dont know why, but the dataPath set in the mods.s/kjv is not
        exactly the same as with a dictionary book. With the dictionnary
        the name of the module appears twice:

        DataPath=./modules/lexdict/rawld/strongsgreek/strongsgreek
        compare with
        DataPath=./modules/texts/ztext/kjv/

        In case of dictionnary, lets remove the last stuff...
        
        """
        if modDirName=='strongsgreek':
            remote_mod=self.rep_location+"/modules/lexdict/rawld/strongsgreek"
        if modDirName=="strongshebrew":
            remote_mod=self.rep_location+"/modules/lexdict/rawld/strongshebrew"
            
        remote_mod_uri=gnomevfs.URI(remote_mod)


        

        tmp_conf=self.tmpDir+"/"+conf_file
        tmp_conf_uri=gnomevfs.URI(tmp_conf)
        tmp_mod=self.tmpDir+"/"+modDirName
        tmp_mod_uri=gnomevfs.URI(tmp_mod)


        dst_conf = self.data_path+"/mods.d/"+conf_file
        dst_conf_uri = gnomevfs.URI(dst_conf)
        dst_module = self.data_path+"/"+dataPath

        if modDirName=='strongsgreek':
            dst_module=self.data_path+"/modules/lexdict/rawld/strongsgreek"
        if modDirName=="strongshebrew":
            dst_module=self.data_path+"/modules/lexdict/rawld/strongshebrew"
        
        dst_module_uri = gnomevfs.URI(dst_module)

        #print "dst_conf='%s'"%dst_conf
        #print "dst_module='%s'"%dst_module

        if not os.path.isdir(dst_module):
            os.makedirs(dst_module)

            
        if os.path.isdir(tmp_mod):
            pipe=os.popen("rm -rf %s"%tmp_mod,'r')
            pipe.close()
        if os.path.isfile(tmp_conf):
            os.remove(tmp_conf)
        problem=False


        """
        Copying in a temporary location.
        """
        self.system_info("Copying %s locally:"%conf_file)
        debug("donwloading conf file:'%s','%s'"%\
              (remote_conf,tmp_conf))
        try:
            gnomevfs.xfer_uri(remote_conf_uri,tmp_conf_uri,
                              gnomevfs.XFER_DEFAULT,\
                              gnomevfs.XFER_ERROR_ACTION_ABORT,\
                              gnomevfs.XFER_OVERWRITE_ACTION_REPLACE_ALL\
                              )

        except:
            debug("Exception occured:%s"%sys.exc_info()[0])
            problem=True

        #print "donwloading module itself"
        debug("downloading module:%s %s"%(remote_mod,tmp_mod))
        self.system_info("Copying %s locally:"%dataPath)
        try:
            gnomevfs.xfer_uri(remote_mod_uri,tmp_mod_uri,
                              gnomevfs.XFER_DEFAULT,\
                              gnomevfs.XFER_ERROR_ACTION_ABORT,\
                              gnomevfs.XFER_OVERWRITE_ACTION_REPLACE_ALL\
                              )
            
        except:
            debug("Exception occured:%s"%sys.exc_info()[0])
            problem=True


        if  problem:
            debug("Coping with problems")
            if os.path.isdir(tmp_mod):
                debug("Removing '%s' dir"%tmp_mod)
                pipe=os.popen("rm -rf %s"%tmp_mod,'r')
                pipe.close()
            if os.path.isfile(tmp_conf):
                debug("removing '%s' file"%tmp_conf)
                os.remove(tmp_conf)
            return False

        """
        Copying from the temporary location to the real one.
        """

        self.system_info("Copying data in their final location")

        debug("Copying from tmp location to real one:'%s','%s'"%\
              (tmp_mod,dst_module))

        try:
            gnomevfs.xfer_uri(tmp_mod_uri,dst_module_uri,
                              gnomevfs.XFER_DEFAULT+gnomevfs.XFER_NEW_UNIQUE_DIRECTORY,\
                              gnomevfs.XFER_ERROR_ACTION_ABORT,\
                              gnomevfs.XFER_OVERWRITE_ACTION_REPLACE_ALL\
                              )
        except:
            debug("Exception occured:%s"%sys.exc_info()[0])
            problem=True


        debug("Copying conf file from tmp to dst:'%s','%s'"%\
              (tmp_conf,dst_conf))
        try:
            gnomevfs.xfer_uri(tmp_conf_uri,dst_conf_uri,
                              gnomevfs.XFER_DEFAULT,\
                              gnomevfs.XFER_ERROR_ACTION_ABORT,\
                              gnomevfs.XFER_OVERWRITE_ACTION_REPLACE_ALL\
                              )
        except:
            problem=True
            debug("Exception occured:"%sys.exc_info()[0])

        debug("Copying stuff is over, let s remove tmp stuff.")
        self.system_info("Removing temporary files")
        if os.path.isdir(tmp_mod):
            pipe=os.popen("rm -rf %s"%tmp_mod,'r')
            pipe.close()
        if os.path.isfile(tmp_conf):
            os.remove(tmp_conf)

        self.mgr=Sword.SWMgr()
        return not problem
        
    def download_mods_list (self,src_uri,dst_uri):
        debug("download_mods_list(self,'%s','%s')"%\
              (src_uri,dst_uri))
        try:
            test=gnomevfs.Handle(src_uri,open_mode=gnomevfs.OPEN_READ)
            plop=test.get_file_info()
        except gnomevfs.Error,fault:
            debug("problem getting a file Handle='%s'"%fault)
            return False
        except :
            debug("Something is borked")

            return False


        debug("Copying the list of module localy")
        try:
            gnomevfs.xfer_uri(src_uri,dst_uri,
                              gnomevfs.XFER_DEFAULT,\
                              gnomevfs.XFER_ERROR_ACTION_ABORT,\
                              gnomevfs.XFER_OVERWRITE_ACTION_REPLACE_ALL)

        except:
            debug("Exception occured:%s"%sys.exc_info()[0])
            return False
        debug("Everything looks all right")
        return True

    def untar_mods_list(self,dst):
        debug("Let s untar '%s'"%dst)
        isTarfile=False
        try:
            isTarfile=tarfile.is_tarfile(dst)
        except :
            isTarfile=False

        if isTarfile:
            tar=tarfile.open(dst,'r')
            for tarinfo in tar:
                tar.extract(tarinfo,self.tmpDir)
        else:
            debug("'%s' is not a tarfile"%dst)
            return False

        tar.close()
        return True

    def get_module_info(self,dir,conf):
        filename="%s/%s"%(dir,conf.name)
        uri=gnomevfs.URI(filename)
        curFile=gnomevfs.Handle(uri,open_mode=gnomevfs.OPEN_READ)
        size=curFile.get_file_info().size
        content=curFile.read(size)
        curFile.close()
        lines=content.splitlines()
        namereg=re.compile("^\[(.*)\]\s?$")
        out={}
        curName=False
        for l in lines:
            kvreg=re.compile("^(.*)=(.*)$")
            if kvreg.search(l):
                curKey=kvreg.search(l).group(1)
                curValue=kvreg.search(l).group(2)
                out[curKey]=curValue

            if namereg.search(l):
                curName=namereg.search(l).group(1)

        if not curName:
            debug("Problem finding module name for '%s'"%conf.name)

        out['Name']=curName        
        return out
        
    def get_remote_modules_list(self):
        #self.system_info('fetching remote module list')
        tarfile_location=self.rep_location+"/mods.d.tar.gz"
        #tarfile_location="/etc/passwd"
        dst=self.tmpDir+"/mods.d.tar.gz"
        src_uri=gnomevfs.URI(tarfile_location)
        dst_uri=gnomevfs.URI(dst)

        all_modules=[]
        if not self.download_mods_list(src_uri,dst_uri):
            debug("download module list did not work")
            self.system_info("Remote module list not available")
            return []


        if not self.untar_mods_list(dst):
            debug("problem untarring modules list")
            self.system_info("Problem untarring modules list")
            return []

        self.system_info("Processing remote modules list")

        modules_dir_uri=gnomevfs.URI(self.tmpDir+"/mods.d")
        modules_dir=gnomevfs.DirectoryHandle(modules_dir_uri)
        while True:
            try:
                curFileInfo=modules_dir.next()
                if not re.compile(".*conf$").search(curFileInfo.name):
                    continue
                
                cur_info=self.get_module_info(self.tmpDir+"/mods.d",\
                                              curFileInfo)
                cur_info['conf_file_name']=curFileInfo.name
                cur_uri=gnomevfs.URI(self.tmpDir+"/mods.d/"+curFileInfo.name)
                gnomevfs.unlink(cur_uri)

                if cur_info['Name']=='StrongsHebrew'\
                   or cur_info['Name']=='StrongsGreek':
                    all_modules.append(cur_info)
                    continue
                                

                """Don't need  commentary or non bible books"""
                if cur_info.has_key('Category'):
                    continue

                if cur_info.has_key('LCSH'):
                    snt=cur_info['LCSH']
                    if re.compile('Commentaries').search(snt):
                        continue


                    if re.compile('Dictionary').search(snt):
                        continue
                    
                    if re.compile('Dictionaries').search(snt):
                        continue
                    
                    if re.compile('Indexes').search(snt):
                        continue
                
                all_modules.append(cur_info)

            except StopIteration:
                break
            except:
                debug("We should not be here !!!")
                raise


        gnomevfs.unlink(dst_uri)
        newDirUri=gnomevfs.URI(self.tmpDir+"/mods.d")
        gnomevfs.remove_directory(newDirUri)

        return all_modules
