#include <qpainter.h>
#include "toolpanel.h"
#include "skinmanager.h"
#include "skin.h"
#include "skinnedbutton.h"
#include "skinnedlabel.h"
#include "seekbar.h"

ToolPanel::ToolPanel(const SkinManager *skinmgr, QWidget *parent, const char *name)
	: SkinPanel(Skin::ToolBackground, skinmgr, parent, name)
{
	timer_ = new QTimer(this);
	connect(timer_, SIGNAL(timeout()), this, SLOT(timerTimedOut()));
	
	infoLabel_ = new SkinnedLabel(Skin::ToolInfo, skinmgr, this);

	// RANDOM:
	randomOffButton_ = new SkinnedButton(Skin::ToolRandomOff, skinmgr, this);
	connect(randomOffButton_, SIGNAL(clicked()), this, SLOT(randomOffClicked()));
	
	randomOnButton_ = new SkinnedButton(Skin::ToolRandomOn, skinmgr, this);
	connect(randomOnButton_, SIGNAL(clicked()), this, SLOT(randomOnClicked()));
	randomOnButton_->hide();

	// REPEAT:
	repeatOffButton_ = new SkinnedButton(Skin::ToolRepeatOff, skinmgr, this);
	connect(repeatOffButton_, SIGNAL(clicked()), this, SLOT(repeatOffClicked()));
	
	repeatOneButton_ = new SkinnedButton(Skin::ToolRepeatOne, skinmgr, this);
	connect(repeatOneButton_, SIGNAL(clicked()), this, SLOT(repeatOneClicked()));
	repeatOneButton_->hide();
	
	repeatAllButton_ = new SkinnedButton(Skin::ToolRepeatAll, skinmgr, this);
	connect(repeatAllButton_, SIGNAL(clicked()), this, SLOT(repeatAllClicked()));
	repeatAllButton_->hide();

	// OVERVIEW:
	overviewOffButton_ = new SkinnedButton(Skin::ToolOverviewOff, skinmgr, this);
	connect(overviewOffButton_, SIGNAL(clicked()), this, SLOT(overviewOffClicked()));
	
	overviewOnButton_ = new SkinnedButton(Skin::ToolOverviewOn, skinmgr, this);
	connect(overviewOnButton_, SIGNAL(clicked()), this, SLOT(overviewOnClicked()));
	overviewOnButton_->hide();

	// COVER ART FLOW:
	coverArtFlowOffButton_ = new SkinnedButton(Skin::ToolCoverArtFlowOff, skinmgr, this);
	connect(coverArtFlowOffButton_, SIGNAL(clicked()), this, SLOT(coverArtFlowOffClicked()));
	
	coverArtFlowOnButton_ = new SkinnedButton(Skin::ToolCoverArtFlowOn, skinmgr, this);
	connect(coverArtFlowOnButton_, SIGNAL(clicked()), this, SLOT(coverArtFlowOnClicked()));
	coverArtFlowOnButton_->hide();
	
	// VIEWS:
	viewPlayList_ = new SkinnedButton(Skin::ToolViewPlayList, skinmgr, this);
	connect(viewPlayList_, SIGNAL(clicked()), this, SLOT(viewPlayListClicked()));
	viewPlayList_->setToggleButton(true);

	viewPlayInfo_ = new SkinnedButton(Skin::ToolViewPlayInfo, skinmgr, this);
	connect(viewPlayInfo_, SIGNAL(clicked()), this, SLOT(viewPlayInfoClicked()));
	viewPlayInfo_->setToggleButton(true);
}

ToolPanel::~ToolPanel()
{
	
}

void ToolPanel::setInfoText(const QString &text)
{
	timer_->stop();
	infoText_ = text;
	infoLabel_->setText(text);
	infoLabel_->repaint();	
}

void ToolPanel::setStatusText(const QString &text, int milliseconds)
{
	infoLabel_->setText(text);
	infoLabel_->repaint();
	timer_->start(milliseconds, true);
}

void ToolPanel::timerTimedOut()
{
	infoLabel_->setText(infoText_);
	infoLabel_->repaint();
}

void ToolPanel::setPlayOrder(PlayListView::PlayOrder playOrder)
{
	if (playOrder == PlayListView::ORDER_RANDOM || playOrder == PlayListView::ORDER_REPEAT_RANDOM)
	{
		randomOffButton_->hide();
		randomOnButton_->show();
	}
	else
	{
		randomOnButton_->hide();
		randomOffButton_->show();
	}
		
	if (playOrder == PlayListView::ORDER_REPEAT_ONE)
		repeatOneButton_->show();
	else
		repeatOneButton_->hide();
	
	if (playOrder == PlayListView::ORDER_REPEAT_ALL || playOrder == PlayListView::ORDER_REPEAT_RANDOM)
		repeatAllButton_->show();
	else
		repeatAllButton_->hide();
	
	if (!repeatAllButton_->isVisible() && !repeatOneButton_->isVisible())
		repeatOffButton_->show();
	else
		repeatOffButton_->hide();
}

void ToolPanel::buttonStateChanged()
{
	PlayListView::PlayOrder playOrder;
	
	if (randomOnButton_->isVisible())
	{
		if (repeatAllButton_->isVisible())
			playOrder = PlayListView::ORDER_REPEAT_RANDOM;
		else
			playOrder = PlayListView::ORDER_RANDOM;
	}
	else
	{
		if (repeatAllButton_->isVisible())
			playOrder = PlayListView::ORDER_REPEAT_ALL;
		else if (repeatOneButton_->isVisible())
			playOrder = PlayListView::ORDER_REPEAT_ONE;
		else
			playOrder = PlayListView::ORDER_NORMAL;
	}
	
	emit playOrderChanged(playOrder);
}

void ToolPanel::randomOffClicked()
{
	randomOffButton_->hide();
	randomOnButton_->show();
		
	// there is no repeat one random, so make sure this case 
	// won't be reflected in our button state. Switch to repeat all instead.
	if (repeatOneButton_->isVisible())
	{
		repeatOneButton_->hide();
		repeatOffButton_->hide();
		repeatAllButton_->show();
	}
	buttonStateChanged();
}

void ToolPanel::randomOnClicked()
{
	randomOnButton_->hide();
	randomOffButton_->show();
	buttonStateChanged();
}

void ToolPanel::repeatOffClicked()
{
	repeatOneButton_->hide();
	repeatOffButton_->hide();
	repeatAllButton_->show();
	buttonStateChanged();
}

void ToolPanel::repeatOneClicked()
{
	repeatAllButton_->hide();
	repeatOneButton_->hide();
	repeatOffButton_->show();
	buttonStateChanged();
}

void ToolPanel::repeatAllClicked()
{
	repeatAllButton_->hide();
	// same as above, no repeat one random...
	if (randomOnButton_->isVisible())
	{
		repeatOneButton_->hide();
		repeatOffButton_->show();
	}
	else
	{
		repeatOffButton_->hide();
		repeatOneButton_->show();
	}
	buttonStateChanged();
}

void ToolPanel::overviewOffClicked()
{
	overviewOffButton_->hide();
	overviewOnButton_->show();
	emit overviewVisibilityChanged(false);
}

void ToolPanel::overviewOnClicked()
{
	overviewOnButton_->hide();
	overviewOffButton_->show();
	emit overviewVisibilityChanged(true);
}

void ToolPanel::coverArtFlowOffClicked()
{
	coverArtFlowOffButton_->hide();
	coverArtFlowOnButton_->show();
	emit coverArtFlowVisibilityChanged(false);
}

void ToolPanel::coverArtFlowOnClicked()
{
	coverArtFlowOnButton_->hide();
	coverArtFlowOffButton_->show();
	emit coverArtFlowVisibilityChanged(true);
}

void ToolPanel::setOverviewVisibility(bool visible)
{
	if (visible)
	{
		overviewOnButton_->hide();
		overviewOffButton_->show();
	}
	else
	{
		overviewOffButton_->hide();
		overviewOnButton_->show();
	}	
}

void ToolPanel::setCoverArtFlowVisibility(bool visible)
{
	if (visible)
	{
		coverArtFlowOnButton_->hide();
		coverArtFlowOffButton_->show();
	}
	else
	{
		coverArtFlowOffButton_->hide();
		coverArtFlowOnButton_->show();
	}	
}

void ToolPanel::viewPlayListClicked()
{
	viewPlayList_->setOn(true);
	viewPlayInfo_->setOn(false);
	emit viewPlayListActivated();
}

void ToolPanel::viewPlayInfoClicked()
{
	viewPlayList_->setOn(false);
	viewPlayInfo_->setOn(true);
	emit viewPlayInfoActivated();
}

void ToolPanel::setView(ViewType view)
{
	viewPlayList_->setOn(view == ToolPanel::PlayList);
	viewPlayInfo_->setOn(view == ToolPanel::PlayInfo);
}