/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef SKIN_H_INCLUDED
#define SKIN_H_INCLUDED

#include <qdict.h>
#include <qvector.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qimage.h>

class Config;
class SkinManager;
class SkinSection;
class SkinParts;
class SkinModeInformation;

typedef QVector<SkinSection> SkinSections;

//! Skinクラスはスキンの抽象を提供します。
class Skin {
public:
	enum PartsClass {
		PositionedFixedRect,
		PositionedFixedParts,
		PositionedFixedPartsWithSpecificLength,
		PositionedFlexibleParts,
		UNPOSITIONEDCLASS,
		GenericFlexibleParts,
		MAXCLASS
	};
	
	//! スキンパーツの種類
	enum PartsType {
		Background,
		Play,
		Pause,
		Stop,
		Next,
		Previous,
		SeekKnob,
		VolumeKnob,
		CurrentPlayTime,
		TotalPlayTime,
		ToolBackground,
		ToolInfo,
		ToolRandomOff,
		ToolRandomOn,
		ToolRepeatOff,
		ToolRepeatOne,
		ToolRepeatAll,
		ToolOverviewOff,
		ToolOverviewOn,
		ToolCoverArtFlowOff,
		ToolCoverArtFlowOn,
		ToolViewPlayList,
		ToolViewPlayInfo,
		PlaylistBackground, 
		PlaylistPLOn,
		PlaylistPLOff,
		PlaylistDynPlaylistEditorOn,
		PlaylistDynPlaylistEditorOff,
		PlaylistOnTheGoPLOn,
		PlaylistOnTheGoPLOff,
		PlaylistCopy,
		PlaylistCut,
		PlaylistPaste,
		PlaylistDelete,
		PlaylistCopyToOnTheGoPL,
		PlaylistResetFilterAndSorting,
		PlaylistOpen,
		PlaylistSave,
		PlaylistModeSingle,
		PlaylistModeMultiSelect,
		PlaylistModeMoveItem,
		FlowScrollBar,
		FlowScrollBarSlider,
		SeekSliderBar,
		SeekSliderKnob,
		MAX
	};

public:
	Skin(SkinManager *parent, Config &, const QString &group, QString imageDir);
	~Skin();

	bool isValid() const;
	const SkinParts *lookup(PartsType p) const;
	//! シークバーの長さをピクセル単位で返します。

private:
	struct PartsSetupInfo {
		PartsType type;
		PartsClass partsclass;
		int count;
		char *key;
	};
	static const PartsSetupInfo partsSetupInfo_[];

	bool readSections(const QString &input, SkinSections *&sections);
	bool setupParts(const PartsSetupInfo *, Config &c, const QString &group, QDict<QImage> &, const QString &imageDir);

private:
	SkinManager *parent_;
	bool isValid_;
	QVector<SkinParts> parts_;	//!< スキンパーツを保持する配列
};

//! SkinPartsクラスはスキンに含まれるパーツの抽象を提供します。
class SkinParts
{
public:
	SkinParts(Skin::PartsType type, const QRect& geometry, const QPixmap &image, int imageCount, int length, int section, void *data);
	~SkinParts();

	Skin::PartsType type() const;
	const QRect& geometry() const;
	//! 
	const QPixmap& image() const;
	int imageCount() const;
	int length() const;
	void setLength(int length);
	
	int section() const;
	void *data() const;

private:
	Skin::PartsType type_;
	void *data_;
	QRect geometry_;
	QPixmap image_;
	int imageCount_;
	int section_;
	int length_;
};

class SkinSection
{
public:
	enum SectionType {
		Fixed,
		FlexibleTiled
	};
	
	const SectionType type() const { return type_; }
	void setType(SectionType value) { type_ = value; }
	
	const int width() const { return width_; }
	void setWidth(int value) { width_ = value; }

	const int hitWidth() const { return hitWidth_; }
	void setHitWidth(int value) { hitWidth_ = value; } 
	
	const int x() const { return x_; }
	void setX(int value) { x_ = value; }

private:
	SectionType type_;
	int width_;
	int hitWidth_;
	int x_;
};

#endif // SKIN_H_INCLUDED
