/*
 * Copyright (C) 2006-2007	Andre Beckedorf
 * 					 		<evilJazz _AT_ katastrophos _DOT_ net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <qpainter.h>
#include "playlisttoolpanel.h"
#include "skinmanager.h"
#include "skin.h"
#include "skinnedbutton.h"
#include "skinnedlabel.h"
#include "seekbar.h"

PlayListToolPanel::PlayListToolPanel(const SkinManager *skinmgr, QWidget *parent, const char *name)
	: SkinPanel(Skin::PlaylistBackground, skinmgr, parent, name)
{
	// playlist view:
	playlistViewOffButton_ = new SkinnedButton(Skin::PlaylistPLOff, skinmgr, this);
	connect(playlistViewOffButton_, SIGNAL(clicked()), this, SLOT(playlistViewOffClicked()));
	
	playlistViewOnButton_ = new SkinnedButton(Skin::PlaylistPLOn, skinmgr, this);
	playlistViewOnButton_->hide();

	// dynamic playlist editor view:
	dynPlaylistEditorViewOffButton_ = new SkinnedButton(Skin::PlaylistDynPlaylistEditorOff, skinmgr, this);
	connect(dynPlaylistEditorViewOffButton_, SIGNAL(clicked()), this, SLOT(dynPlaylistEditorViewOffClicked()));
	
	dynPlaylistEditorViewOnButton_ = new SkinnedButton(Skin::PlaylistDynPlaylistEditorOn, skinmgr, this);
	dynPlaylistEditorViewOnButton_->hide();

	// on-the-go playlist view:
	otgPlaylistViewOffButton_ = new SkinnedButton(Skin::PlaylistOnTheGoPLOff, skinmgr, this);
	connect(otgPlaylistViewOffButton_, SIGNAL(clicked()), this, SLOT(otgPlaylistViewOffClicked()));
	
	otgPlaylistViewOnButton_ = new SkinnedButton(Skin::PlaylistOnTheGoPLOn, skinmgr, this);
	otgPlaylistViewOnButton_->hide();
	
	// singleselect mode:
	modeSingleSelect_ = new SkinnedButton(Skin::PlaylistModeSingle, skinmgr, this);
	connect(modeSingleSelect_, SIGNAL(clicked()), this, SLOT(modeSingleSelectClicked()));
	modeSingleSelect_->setToggleButton(true);

	// multiselect mode:
	modeMultiSelect_ = new SkinnedButton(Skin::PlaylistModeMultiSelect, skinmgr, this);
	connect(modeMultiSelect_, SIGNAL(clicked()), this, SLOT(modeMultiSelectClicked()));
	modeMultiSelect_->setToggleButton(true);
	
	// move item mode:
	modeMoveItem_ = new SkinnedButton(Skin::PlaylistModeMoveItem, skinmgr, this);
	connect(modeMoveItem_, SIGNAL(clicked()), this, SLOT(modeMoveItemClicked()));
	modeMoveItem_->setToggleButton(true);

	// copy:
	copyButton_ = new SkinnedButton(Skin::PlaylistCopy, skinmgr, this);
	connect(copyButton_, SIGNAL(clicked()), this, SLOT(copyButtonClicked()));
	
	// cut:
	cutButton_ = new SkinnedButton(Skin::PlaylistCut, skinmgr, this);
	connect(cutButton_, SIGNAL(clicked()), this, SLOT(cutButtonClicked()));

	// paste:
	pasteButton_ = new SkinnedButton(Skin::PlaylistPaste, skinmgr, this);
	connect(pasteButton_, SIGNAL(clicked()), this, SLOT(pasteButtonClicked()));
	
	// delete selection:
	deleteButton_ = new SkinnedButton(Skin::PlaylistDelete, skinmgr, this);
	connect(deleteButton_, SIGNAL(clicked()), this, SLOT(deleteButtonClicked()));

	// open playlist:
	openPlaylistButton_ = new SkinnedButton(Skin::PlaylistOpen, skinmgr, this);
	connect(openPlaylistButton_, SIGNAL(clicked()), this, SLOT(openPlaylistButtonClicked()));	

	// save playlist:
	savePlaylistButton_ = new SkinnedButton(Skin::PlaylistSave, skinmgr, this);
	connect(savePlaylistButton_, SIGNAL(clicked()), this, SLOT(savePlaylistButtonClicked()));
	
	// copy to On-The-Go playlist:
	copyToOTGButton_ = new SkinnedButton(Skin::PlaylistCopyToOnTheGoPL, skinmgr, this);
	connect(copyToOTGButton_, SIGNAL(clicked()), this, SLOT(copyToOTGButtonClicked()));
	
	// reset filters and sorting:
	resetFilterAndSortingButton_ = new SkinnedButton(Skin::PlaylistResetFilterAndSorting, skinmgr, this);
	connect(resetFilterAndSortingButton_, SIGNAL(clicked()), this, SLOT(resetFilterAndSortingButtonClicked()));
}

PlayListToolPanel::~PlayListToolPanel()
{
	
}

void PlayListToolPanel::setMode(PlayListManager::Mode mode)
{
	switch (mode)
	{
	case PlayListManager::ModeOpenedPlaylist:
		playlistViewOffButton_->hide();
		playlistViewOnButton_->show();
		dynPlaylistEditorViewOffButton_->show();
		dynPlaylistEditorViewOnButton_->hide();
		otgPlaylistViewOffButton_->show();
		otgPlaylistViewOnButton_->hide();
		break;
	case PlayListManager::ModeOnTheGoPlaylist:
		playlistViewOffButton_->show();
		playlistViewOnButton_->hide();
		dynPlaylistEditorViewOffButton_->show();
		dynPlaylistEditorViewOnButton_->hide();
		otgPlaylistViewOffButton_->hide();
		otgPlaylistViewOnButton_->show();
		break;
	case PlayListManager::ModeDynPlaylistEditor:
		playlistViewOffButton_->show();
		playlistViewOnButton_->hide();
		dynPlaylistEditorViewOffButton_->hide();
		dynPlaylistEditorViewOnButton_->show();
		otgPlaylistViewOffButton_->show();
		otgPlaylistViewOnButton_->hide();
		break;
	}
}

void PlayListToolPanel::setInputMode(PlayListView::InputMode inputMode)
{
	modeSingleSelect_->setOn(inputMode == PlayListView::Select);
	modeMultiSelect_->setOn(inputMode == PlayListView::MultiSelect);
	modeMoveItem_->setOn(inputMode == PlayListView::Move);
}