/*
 * Copyright (C) 2006-2007	Andre Beckedorf
 * 					 		<evilJazz _AT_ katastrophos _DOT_ net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PLAYLISTOVERVIEW_H_INCLUDED
#define PLAYLISTOVERVIEW_H_INCLUDED

#include <qobject.h>
#include <qhbox.h>
#include <qlistbox.h>
#include "skinmanager.h"
#include "playlistview.h"

class QWidget;
class QLabel;
class QVBox;

class PlayListOverview: public QHBox, public PlayListViewExtension
{
	Q_OBJECT
public:
	PlayListOverview(PlayListView *playListView, QWidget *parent = 0, const char *name = 0);
	virtual ~PlayListOverview();

	void execute();
	void reset();
	QString outputViewSource();

	virtual void saveExtensionState(PlayListViewState *dst);
	virtual void loadExtensionState(PlayListViewState *src);

	void setSkinMode(const SkinModeInformation &modeInfo);

	QListBox::SelectionMode selectionMode() { return genreListBox_->selectionMode(); }
	void setSelectionMode(QListBox::SelectionMode mode);

signals:
	void focusOutLeft();
	void focusOutRight();

protected:
	void showEvent(QShowEvent *);
	bool eventFilter(QObject *, QEvent *);

private slots:
	void updateGenres(bool interactive = false);
	void updateArtists(bool interactive = false);
	void updateAlbums(bool interactive = false);
	void updateView(bool interactive);
	void updateView();

	void validateSelection(QListBox *list);

	void genreListBoxSelectionChanged();
	void artistListBoxSelectionChanged();
	void albumListBoxSelectionChanged();

private:
	PlayListView *playListView_;
	bool isDirty_;
	QTimer *updateTimer_;

	bool updatingGenres_;
	bool updatingArtists_;
	bool updatingAlbums_;

	QString selectedGenresFilter;
	QString selectedArtistsFilter;
	QString selectedAlbumsFilter;

	QVBox *genreBox_;
	QVBox *artistBox_;
	QVBox *albumBox_;

	QLabel *genreHeading_;
	QLabel *artistHeading_;
	QLabel *albumHeading_;

	QListBox *genreListBox_;
	QListBox *artistListBox_;
	QListBox *albumListBox_;

	void createColumnBox(QString title, QVBox *&box, QLabel *&heading, QListBox *&listbox);

	void beginUpdateOn(QWidget *widget);
	void endUpdateOn(QWidget *widget);

	QString buildFilter(QListBox *list, const QString &unknown);
	int selectionCount(QListBox *list);
	void createFilteredTable(const QString &selectedFilter, const QString &srctable, const QString &dsttable, const QString &what, const QString &wherecol);
	void doUpdateOnListBox(QListBox *listbox, const QString &selectedFilter, const QString &colname, const QString &srctable, const QString &unknown, const QString &one, const QString &more);
};

#endif // PLAYLISTOVERVIEW_H_INCLUDED
