/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <qlabel.h>
#include <qframe.h>
#include <qlayout.h>
#include <qvbox.h>
#include "identifykeydialog.h"

IdentifyKeyDialog::IdentifyKeyDialog(QWidget *parent, const char *name)
	: QDialog(parent, name, true, WStyle_Customize),
	  key_(-1)
{
	setWFlags(WStyle_Customize | WStyle_NoBorder);
	setMinimumSize(160, 70);
	
	QVBox *box = new QVBox(this);
	box->setFrameStyle(QFrame::StyledPanel | QFrame::Raised);
	box->setSpacing(10);
	
	QLabel *label = new QLabel(tr("<b>Press any key</b>"), box);
	label->setAlignment(AlignCenter);

	QVBoxLayout *layout = new QVBoxLayout(this);
	layout->addWidget(box);
	
	this->grabKeyboard();
}

IdentifyKeyDialog::~IdentifyKeyDialog()
{
	this->releaseKeyboard();
}

void IdentifyKeyDialog::keyPressEvent(QKeyEvent *e)
{
	e->accept();
}

void IdentifyKeyDialog::keyReleaseEvent(QKeyEvent *e)
{
	int key = e->key();

	e->accept();

	if (key == Key_Shift || key == Key_Control || key == Key_Alt || key == 0x1045/* Fn */)
		return;

	if (e->state() & ShiftButton)
		key |= SHIFT;
	if (e->state() & ControlButton)
		key |= CTRL;
	if (e->state() & AltButton)
		key |= ALT;

	key_ = key;

	accept();
}
