#ifndef FORMATSCONFIG_H_INCLUDED
#define FORMATSCONFIG_H_INCLUDED

#include "configuration.h"
#include "configview.h"

class QPushButton;
class QListView;
class QListViewItem;

class FormatsConfig : public ConfigView
{
	Q_OBJECT
public:
	FormatsConfig(Configuration& configuration, QWidget *parent = 0, const char *name = 0) : ConfigView(configuration, parent, name) {}

	virtual void setStatesByConfiguration(const Configuration& config);
	virtual void saveStatesToConfiguration();

protected:
	virtual void createWidgets();

private slots:
	void editFormat(QListViewItem *);
	void editSelectedFormat();
	void addNewFormat();
	void removeSelectedFormat();
	void revertToDefaultFormats();

private:
	void readFromConfiguration(const Configuration& config);

	QPushButton *keyButton_;
	QListView *list;
};

#endif // FORMATSCONFIG_H_INCLUDED
