/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <qapplication.h>
#include <qtextview.h>
#include <qlayout.h>
#include <qvgroupbox.h>
#include <qlabel.h>
#include "aboutdialog.h"
#include "configuration.h"
#include <qscrollview.h>
#include <qvbox.h>

AboutDialog::AboutDialog(QWidget *parent, const char *name, WFlags f)
	: QWidget(parent, name, f)
{
	setCaption(tr("About Quasar Media Player"));
	setWFlags(getWFlags() | Qt::WDestructiveClose);

	QScrollView *scrollView = new QScrollView(this);
	scrollView->setFrameStyle(QScrollView::NoFrame);
	scrollView->setMargin(4);
	scrollView->setResizePolicy(QScrollView::AutoOneFit);

	QVBox *bigbox = new QVBox(scrollView->viewport());
	bigbox->setSpacing(4);
	scrollView->addChild(bigbox);

#ifdef QTOPIA
	QVGroupBox *behaviorBox = new QVGroupBox(tr("Behavior"), bigbox);

	new QLabel(QString(tr("Running on %1")).arg(qConfig.machineName()), behaviorBox);
	QString category(tr("Selected behavior is %2"));
	switch (qConfig.machineCategory()) {
	case Configuration::MACHINE_SLC700:
		category = category.arg("SL-C7x0 / SL-C860 (w100)");
		break;
	case Configuration::MACHINE_SLC3000:
		category = category.arg("SL-C1000 / SL-C3x00 (bvdd)");
		break;
	case Configuration::MACHINE_GENERIC:
		category = category.arg("Generic");
		break;
	}
	new QLabel(category, behaviorBox);
#endif

	QVGroupBox *copyrightBox = new QVGroupBox(tr("Copyright information"), bigbox);
	QTextView *about = new QTextView(copyrightBox);
	about->setTextFormat(Qt::RichText);

	QString revision = "";
 	if (QString(APPREVISION) != "#Revision#")
 		revision = " (" + QString(APPREVISION) + ")";

	about->setText(
			"<bold>Quasar Media Player " + QString("%1.%2").arg(APPVERSION_MAJOR).arg(APPVERSION_MINOR) + revision + "</bold><br/>"
			"Copyright (C) 2006-2008 by Andre Beckedorf <a href=\"mailto:evilJazz@katastrophos.net\">(evilJazz@katastrophos.net)</a><br/>"
			"<br/>"
			"This software is licensed under the terms of the GNU General Public License version 2.<br/>"
			"<br/>"
			"For more information please visit:<br/>"
			"<a href=\"http://katastrophos.net/quasar\">http://katastrophos.net/quasar</a><br/>"
			"<br/>"
			"Based on ZPlayer by Atmark and AGAWA Koji<br/>"
			"MPlayer for Zaurus by AGAWA Koji<br/>"
			"TagLib by Scott Wheeler et al.<br/>"
			"TK File Dialog (C) by TKmix, modified by AGAWA Koji and Andre Beckedorf<br/>"
			"TKvol (C) TKmix<br/>"
			"KeyHelperConf (C) yakty"
	);

	QHBoxLayout *layout = new QHBoxLayout(this);
	layout->addWidget(scrollView);

#ifdef QTOPIA
	showMaximized();
#else
	if (qApp->desktop()->width() < 800 || qApp->desktop()->height() < 600)
		showMaximized();
	else
	{
		resize(640, 480);
		show();
	}
#endif;
}
