/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef QTOPIA
#include <qpe/qpeapplication.h>
#else
#include <qapplication.h>
#endif

#include "quasar.h"
#include "configuration.h"
#include "addonmanager.h"
#include "tplugins.h"

int main(int argc, char **argv)
{
#ifdef QTOPIA
	QPEApplication app(argc, argv);
#else
	QApplication app(argc, argv);
#endif

	qGlobalConfig.read();

	qAddOnManager.init();

	Quasar *quasar = new Quasar();
#ifdef QTOPIA
	app.showMainWidget(quasar);
#else
	app.setMainWidget(quasar);
	if (qApp->desktop()->width() < 800 || qApp->desktop()->height() < 600)
		quasar->showMaximized();
	else
		quasar->show();
#endif

	registerTaglibPlugins();

	int result = app.exec();

	delete quasar;

	qAddOnManager.deinit();

	return result;
}
