/*
 * Copyright (C) 2007-2008 Andre Beckedorf <evilJazz _AT_ katastrophos _DOT_ net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef CUSTOMSCALEDCACHEDIMAGEPROVIDER_H_
#define CUSTOMSCALEDCACHEDIMAGEPROVIDER_H_

#include "cachedimageprovider.h"
#include "backgroundtasks.h"

class CustomScaledCachedImageProvider : public CustomCachedImageProvider
{
	Q_OBJECT
public:
	CustomScaledCachedImageProvider(QObject *owner, const char *name = 0);
	
	void setScale(float scale);
	float scale() const { return scale_; }

signals:
	void scaleChangedAndFlushed();
	
protected:
	virtual void threadedSaveImageToCacheDirectory(CachedImage *cachedImage);
	virtual QImage* loadImageFromCacheDirectory(const QString &cacheFileName);
	
private:
	float scale_;
	int scaleSizeBlock_;
};

#endif /*CUSTOMSCALEDCACHEDIMAGEPROVIDER_H_*/
