/*
 * Copyright (C) 2007-2008 Andre Beckedorf <evilJazz _AT_ katastrophos _DOT_ net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>

#ifdef QTOPIA
#include <qpe/qpeapplication.h>
#include <qpe/qpemenubar.h>
#include <qpe/global.h>
#else
#include <qapplication.h>
#include <qmenubar.h>
#endif

#include <qdialog.h>
#include <qlayout.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qvgroupbox.h>
#include <qhgroupbox.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qslider.h>
#include <qfile.h>
#include <qbuffer.h>
#include <qmessagebox.h>
#include <qdir.h>
#include <qsplitter.h>
#include <qdatetime.h>

#include "paintbox.h"
#include "scrollbar.h"
#include "reflectionimageflow.h"

#include "flowmatixtest.h"

#undef NO_DEBUG
#include "debug.h"

#define SlideWidthHeight 300
#define ReflectionHeight (int)((float)SlideWidthHeight * 0.8)

FlowMatixTest::FlowMatixTest()
{
	setCaption("FlowMatix Test Application");
    updateWidgets();
}

void FlowMatixTest::updateWidgets()
{
	QGridLayout *gl = new QGridLayout(this, 1, 1); 
	
	QSplitter *splitter = new QSplitter(this);
	splitter->setOrientation(Qt::Vertical);
	splitter->setOpaqueResize(true);
	splitter->setSizePolicy(QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding));
	
	imageProvider = new ReflectionImageProvider(this);
	
#ifdef QTOPIA
	imageProvider->setImageCacheDirectory("/hdd3/temp/testcache");
	imageProvider->setPreloadImageFilename("/hdd3/temp/nocover.png");
#else		
	imageProvider->setImageCacheDirectory("/Users/darkstar/Desktop/testcache");
	imageProvider->setPreloadImageFilename("/Users/darkstar/Desktop/nocover.png");
#endif

	lpb_ = new LayeredPaintBox(splitter);
	lpb_->setSizePolicy(QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding));

	QBoxLayout * l = new QVBoxLayout(this);
	l->addWidget(lpb_);
	
	flow = new ReflectionImageFlow(imageProvider, lpb_);

	flow->setVerticalOffset(ReflectionHeight / 2);
	flow->setReflectionHeight(ReflectionHeight);
	flow->setSlideSize(QSize(SlideWidthHeight, SlideWidthHeight + ReflectionHeight));
	
	validExtensionsList_ = QStringList() << "jpeg" << "jpg" << "png" << "bmp" << "tif" << "tiff";
	
	QStringList filenames;
#ifdef QTOPIA
	fillFileList(filenames, "/hdd3/temp/testcover/", true);
#else
	fillFileList(filenames, "/Users/darkstar/Desktop/CoverArts/", true);
#endif

	flow->setFileNames(filenames);
	
	sb_ = new FlowScrollBar(flow, lpb_);
	
	text_ = new TextLayer(lpb_);
	text_->setText("This is a test.");
	
	connect(&testTimer_, SIGNAL(timeout()), this, SLOT(textChangeTimeout()));
	testTimer_.start(10, false);	
	
	connect(lpb_, SIGNAL(rearrangeLayers()), this, SLOT(lpbRearrangeLayers()));
	
	lpb_->setFocus();
	
	splitter->setResizeMode(lpb_, QSplitter::Stretch);

	QWidget *blah = new QWidget(splitter);
	blah->setMinimumSize(50, 50);
	
	gl->addWidget(splitter, 0, 0);
}

void FlowMatixTest::lpbRearrangeLayers()
{
	flow->setGeometry(QRect(0, 10, lpb_->width(), lpb_->height() - 100));
	sb_->setGeometry(QRect(50, lpb_->height() - 80, lpb_->width() - 100, 40));
	text_->setGeometry(QRect(10, 100, 150, 50));
}

void FlowMatixTest::textChangeTimeout()
{
	QTime time = QTime::currentTime();
	text_->setText(time.toString() + " " + QString::number(time.msec()));
}

void FlowMatixTest::fillFileList(QStringList &filelist, const QString &path, const bool subdir)
{
	QDir dir(path);
	if (!dir.exists()) return;
	
	dir.setFilter(QDir::Files | (subdir ? QDir::Dirs : 0));
	dir.setSorting(QDir::Unsorted);

	const QFileInfoList *list = dir.entryInfoList();
	QString fileName;
	QFileInfoListIterator it(*list);
	QFileInfo *info;

	for (; (info = it.current()); ++it)
	{
		if (info->isFile())
		{
			// only add the file, if its extension is known...
			if (validExtension(info->extension(false)))
				filelist.append(info->absFilePath());
		}
		else 
		{
			fileName = info->fileName();
			if (fileName != "." && fileName != "..")
				fillFileList(filelist, info->absFilePath(), subdir);
		}
	}
}

void FlowMatixTest::about()
{
	QMessageBox mb("About FlowMatix Test", 
			"FlowMatix Test 0.1\n"
			"Copyright (C) 2007-2008 by Andre Beckedorf\n"
			"evilJazz@katastrophos.net\n\n"
			"This software is licensed under the terms of\n"
			"the GNU Public License version 2.\n\n"
			"For more information please visit:\n"
			"http://katastrophos.net/zaurus/sources/", QMessageBox::NoIcon, 1, 0, 0);
	mb.exec(); 
}
