/*
 * Copyright (C) 2007-2008 Andre Beckedorf <evilJazz _AT_ katastrophos _DOT_ net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef TRANSITIONTIMER_H_
#define TRANSITIONTIMER_H_

#include <qobject.h>
#include <qtimer.h>
#include <qdatetime.h>

class TransitionTimer : public QObject
{
	Q_OBJECT
public:
	TransitionTimer();
	virtual ~TransitionTimer();
	
	inline bool isRunning() const { return timer_->isActive(); }
	void transitionTo(float value);
	void stopTransition();
	
	float currentValue();
	void setCurrentValue(float value);

	float startValue() const { return startValue_; }
	float endValue() const { return endValue_; }
	
	uint transitionTime() const { return transitionTime_; }
	void setTransitionTime(uint value) { transitionTime_ = value; }
	
	uint timeBetweenSteps() const { return timeBetweenSteps_; }
	void setTimeBetweenSteps(uint value) { timeBetweenSteps_ = value; }
	
signals:
	void transitionStep(float start, float stop, float value, float step);
	void transitionStopped(); // triggered everytime the current transition stops, either forcefully or because the end value was reached
	void transitionFinished(); // triggered everytime the end value was reached
	
private slots:
	void timerTimedOut();
	
private:
	QTimer *timer_;
	QTime time_;
	
	uint transitionTime_;
	uint timeBetweenSteps_;
	
	float startValue_;
	float currentValue_;
	float endValue_;
	float step_;
	
	void updateCurrentValue();
	void stopTimer();
	float transitionFunction(uint elapsedTime, uint endTime);
};

#endif /*TRANSITIONTIMER_H_*/
