/*
 * Copyright (C) 2007-2008 Andre Beckedorf <andre@graphics32.org>
 *
 * Includes ported and optimized sourcecode of the Graphics32 project
 * which has been ported from Delphi to C++/Qt.
 * More information available here:
 * http://www.graphics32.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef IMAGEFX_H_
#define IMAGEFX_H_

#include <qcolor.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qpoint.h>

struct FloatPoint
{
	float X;
	float Y;
};

FloatPoint floatPoint(float X, float Y);

uint blendARGB(uint ForegroundColor, uint BackgroundColor);

class ImageFX
{
public:
	static QSize optimalFitSize(const QSize &srcSize, const QSize &maxDstSize);
	static QImage createReflection(const QImage &srcImage, uint reflectionHeight = 100, uint startAlpha = 100, uint stopAlpha = 0);
	static void calculatePerspectivePoints(float posX, float posY, float width, float height, float perspective, float depth, float axisPos, bool radialMode, FloatPoint &p1, FloatPoint &p2, FloatPoint &p3, FloatPoint &p4);
	static void projectiveTransformation(const QImage &srcImage, QImage &dstImage, const QRect &dstClip, const FloatPoint &p1, const FloatPoint &p2, const FloatPoint &p3, const FloatPoint &p4, bool antialias = false, bool blend = false);
	static void projectiveTransformationLUT(const QImage &srcImage, QImage &dstImage, const QRect &dstClip, const FloatPoint &p1, const FloatPoint &p2, const FloatPoint &p3, const FloatPoint &p4, bool antialias, uint *lut);
};

#endif /*IMAGEFX_H_*/
