#!/bin/bash

TARGET="Windows"
BINARY_NAME="quasar.exe"

SCRIPT_FILENAME="`cd \`dirname \"$0\"\`; pwd`/`basename \"$0\"`"
DISTRO_ROOT=$(dirname "$SCRIPT_FILENAME")

source "$DISTRO_ROOT/makedistro-common.sh.in"

function prepareMakefile()
{
	qmake quasar-mingw.pro > Makefile
}

function signBinary()
{
	if [ -d "$DISTRO_ROOT/authenticode" ]; then
		osslsigncode \
			-spc "$DISTRO_ROOT/authenticode/public/katastrophos.p7b" \
			-key "$DISTRO_ROOT/authenticode/private/katastrophos.der" \
			-n "$2" \
			-i "http://quasar.katastrophos.net" \
			-t "http://time.certum.pl" \
			-in "$1" \
			-out "$1.signed"
	
		mv "$1.signed" "$1" 
	fi
}

buildBinary "$TOOLS_ROOT/devenv-x86-mingw.sh"
copySkeletonBinaryAndSkins "$DISTRO_ROOT/skeletons/windows/bin" "$INPUT_ROOT/$BINARY_NAME" "$INPUT_ROOT/skins"
cp "$DEV_ROOT/LICENSE" "$INPUT_ROOT/License.txt"
cp "$QTDIR/lib/qt-mt3.dll" "$INPUT_ROOT/"

downloadExternalFile "http://katastrophos.net/downloads/quasar/mplayer-win.exe.gz"
gzip -c -d "$EXTERNALS_ROOT/mplayer-win.exe.gz" > "$INPUT_ROOT/mplayer.exe"

removeObsoleteFiles

# Sign binaries
signBinary "$INPUT_ROOT/quasar.exe" "Quasar Media Player"
signBinary "$INPUT_ROOT/mplayer.exe" "MPlayer"
signBinary "$INPUT_ROOT/qt-mt3.dll" "Qt3-MT Runtime for Quasar Media Player"
signBinary "$INPUT_ROOT/mingwm10.dll" "MinGW Runtime for Quasar Media Player"

# Create setup binary with Inno Setup compiler
# Check http://katastrophos.net/andre/blog/2009/03/16/setting-up-the-inno-setup-compiler-on-debian/
# on how to set up the iscc environment...
iscc "$DISTRO_ROOT/skeletons/windows/quasar.iss" || onError "Innosetup failed."

# Sign setup
signBinary "$INPUT_ROOT/QuasarMediaPlayerSetup.exe" "Quasar Media Player"

# Move setup binary to destination
movePackageToDestination "$INPUT_ROOT/QuasarMediaPlayerSetup.exe" "$OUTPUT_ROOT/QuasarMediaPlayer_${APPVERSION_FILENAME_SUFFIX}_Setup.exe" "$1"

# Create self contained version and zip it
writeSelfcontainedMarker "$INPUT_ROOT/quasar.ini"
cd "$INPUT_ROOT"
#zip -9 -r "$INPUT_ROOT/QuasarMediaPlayer.zip" * || onError "Zipping failed."
7za a -t7z -m0=lzma -mx=9 -ms=on "$INPUT_ROOT/QuasarMediaPlayer.7z" . || onError "Zipping failed."
cd -

# Move zipped selfcontained version to destination
#movePackageToDestination "$INPUT_ROOT/QuasarMediaPlayer.zip" "$OUTPUT_ROOT/QuasarMediaPlayer_${APPVERSION_FILENAME_SUFFIX}.zip" "$2"
movePackageToDestination "$INPUT_ROOT/QuasarMediaPlayer.7z" "$OUTPUT_ROOT/QuasarMediaPlayer_${APPVERSION_FILENAME_SUFFIX}.7z" "$2"
cleanUp
