/*
 * Copyright (C) 2006-2007	Andre Beckedorf
 * 					 		<evilJazz _AT_ katastrophos _DOT_ net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PLAYLISTMANAGER_H_INCLUDED
#define PLAYLISTMANAGER_H_INCLUDED

#include <qobject.h>
#include <qvaluelist.h>
#include <qlistbox.h>

#include "playlistview.h"

class QWidget;
class QWidgetStack;
class Configuration;
class Media;

class PlayListManager : public QObject
{
	Q_OBJECT

public:
	PlayListManager(PlayListView *targetPlayList, QWidgetStack *container, Configuration &config, QWidget *owner);
	virtual ~PlayListManager();

	enum Mode {
		ModeDynPlaylistEditor = 0,
		ModeOpenedPlaylist = 1,
		ModeOnTheGoPlaylist = 2,
		ModeLastActivePlaylist = 3,
		ModeMax = 4
	};

	Mode activeMode() { return activeMode_; }
	bool setActiveMode(Mode mode);

	PlayListView::InputMode inputMode();
	void setInputMode(PlayListView::InputMode inputMode);

	bool isDynamicPlaylist() const { return isDynPlayList_ && !(activeMode_ == ModeOnTheGoPlaylist); }
	bool isDynamicPlaylistEditorActive() const { return lboxDynPlayList_; }

	bool isAnythingSelected() const
	{
		return (!isDynamicPlaylistEditorActive() && playListView_->selectedItems().count() > 0) ||
			(isDynamicPlaylistEditorActive() && lboxDynPlayList_->currentItem() > -1);
	}

	QExtStringList *dynamicPlayList() { return &dynPlayList_; }

	bool isOnTheGoPlayListActive() const { return playListView_->playListSource() == "onthego_playlist"; }

	int mediaClipboardCount() const { return mediaIDClipboard_.count(); }

	QString getDisplayPlayListFilename();

	QString playlistFile;
	bool readPlayList(const QString &filename, bool assumeInDB = false);
	void addToPlayList(const QExtStringList &filelist, bool interpretPlayList, const QString &playlistDirectory = QString::null, const QString &dialogTitle = NULL);
	bool openASX(const QString&);

public slots:
	// Playlist edit
	void execDialogAddDirToPlayList();
	void execDialogAddDirWithSubDirsToPlayList();
	void execDialogAddFileToPlayList();
	void execDialogAddURLToPlayList() { openURL(NULL); }
	void removeFileFromPlayList();

	void refreshDynamicPlayList();

	void newPlayList();
	void newDynamicPlayList();
	void clearPlayList();
	void execDialogOpenPlayList();
	void savePlayList();
	void execDialogSavePlayListAs();

	void cutSelectionFromPlayList();
	void copySelectionFromPlayList();
	void pasteIntoPlayList();
	void selectAll();
	void deselectAll();
	void copyToOnTheGoPlayList();

signals:
	void playlistFileNameChanged();
	void playlistCleared();
	void playlistLoaded();
	void clipboardChanged();
	void selectionChanged();
	void switchingModeTo(PlayListManager::Mode mode);
	void switchedModeTo(PlayListManager::Mode mode);
	void showMessage(const QString &message, int milliseconds = 3000);

private slots:
	void mediaDatabasePreparingStatements(sqlite3 *db);
	void mediaDatabaseFinalizingStatements(sqlite3 *db);

private:
	QWidget *owner_;
	PlayListView *playListView_;
	QWidgetStack *playListContainer_;
	Configuration &config_;

	bool isDynPlayList_;
	QExtStringList dynPlayList_;
	QListBox *lboxDynPlayList_;
	QWidget *previouslyVisibleWidget_;

	QValueList<unsigned long> mediaIDClipboard_;

	Mode activeMode_;

	PlayListViewState playlistParams_;
	PlayListViewState otgPlaylistParams_;

	sqlite3_stmt *stmtSelectTotalFileSizeAndCountForMediaLocation;
	sqlite3_stmt *stmtSelectAllMediaIDsForMediaLocation;

	void openURL(const QString &uri);
	void addDialog(const bool, const bool subdir = false);
	void addFile(const QString&);
	void addDir(const QString&, const bool subdir = false);

	void checkInputMode();

	void fillFileList(QExtStringList &filelist, const QString &path, const bool subdir);
	void addFromPlayList(const QExtStringList &filelist, bool interpretPlayList, const QString &playlistDirectory = QString::null, const QString &dialogTitle = NULL);

	void writePlayList(const QString &filename);
	void readPlayList(const QString &filename, const QExtStringList &filelist, const QString &dialogTitle = NULL, bool assumeInDB = false);

	void directlyAppendToPlaylistTable(const QValueList<unsigned long> &itemIDs, const QString &tableName);
};

#endif // PLAYLISTMANAGER_H_INCLUDED
