/*
 * playlist.h
 *
 *  Created on: 18.11.2009
 *      Author: darkstar
 */

#ifndef PLAYLIST_H_
#define PLAYLIST_H_

#include <qobject.h>
#include <qvaluelist.h>

#include "mediadatabase.h"

typedef QValueList<unsigned long> MediaIDList;

class PlayList : public QObject
{
	Q_OBJECT
public:
	PlayList(MediaDatabase *mediaDatabase, const QString dbTable);
	virtual ~PlayList();

	const QString &sourceTable() const { return dbTable_; }

	void beginUpdate();
	void endUpdate();
	void propagateChanges();

	void reset();      // clears the content and resets the filename
	void clear();      // clears the content (table and dyn playlist)
	void clearTable(); // clears the table content only

	void addFile(const QString &fileName);
	void addDir(const QString &path, const bool subdir);
	void addURL(const QString &url);

	void fillFileList(QExtStringList &filelist, const QString &path, const bool subdir);
	void addFromFileList(const QExtStringList &filelist, bool interpretPlayList, const QString &playlistDirectory = QString::null);

	void appendMediaIDs(const MediaIDList &mediaIDs);
	int getNextIndex() const;

	enum Type {
		Static = 0,
		Dynamic = 1
	};

	void setType(Type type);
	Type type() const { return type_; }

	bool isDynamic() { return type_ == Dynamic; }
	const QExtStringList &dynPlayList() { return dynPlayList_; }
	void setDynPlayList(const QExtStringList &dynPlayList);

	void repopulate();

	const QString fileName() const { return playListFileName_; }

	bool loadFromFile(const QString &filename);

	const QString saveToFile();
	const QString saveToFile(const QString &filename);
	const QString exportToFile(const QString &filename);

	const QString loadFromDatabase(const QString &tableName);
	void saveToDatabase();

signals:
	void playListChanged();

	void startingActivity(const QString &activityName);
	void updateActivityProgress(const QString &text, int stepNo, int stepsTotal, bool &cancel);
	void finishedActivity(const QString &activityName, bool canceled);

private slots:
	void mediaDatabasePreparingStatements(sqlite3 *db);
	void mediaDatabaseFinalizingStatements(sqlite3 *db);

private:
	MediaDatabase *mediaDatabase_;
	QString dbTable_;

	sqlite3_stmt *stmtSelectTotalFileSizeAndCountForMediaLocation;
	sqlite3_stmt *stmtSelectAllMediaIDsForMediaLocation;
	sqlite3_stmt *stmtInsertMediaIDIntoPlaylist;

	Type type_;
	QString playListFileName_;

	QExtStringList dynPlayList_;

	int updateCount_;

	void requireRepopulation();
};

#endif /* PLAYLIST_H_ */
