#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>

#ifndef WINDOWS
#include <sys/ioctl.h>
#endif

#include <qapplication.h>

#ifdef QTOPIA
#include <qpe/config.h>
#include <qpe/qcopenvelope_qws.h>
#endif

#ifdef __linux__
#include <linux/soundcard.h>
#endif

#include "system_volume.h"

SystemVolume & SystemVolume::singleton()
{
	static SystemVolume instance;
	return instance;
}

SystemVolume::SystemVolume()
	: 	internalVolume_(100),
		useInternalVolume_(false)
{
#ifndef __linux__
	useInternalVolume_ = true;
#endif
}

SystemVolume::~SystemVolume()
{
}

bool SystemVolume::setLevel(int level, bool publish)
{
#ifdef __linux__

char levelc; 
printf("SetVol:%d", level);
char svol[128];
sprintf(svol, "gconftool -t int -s /apps/osso/sound/master_volume -- %d",level);
system(svol);

#endif
		//internalVolume_ = level;
	
	emit levelChanged(level);
	
	return true;	
}


int SystemVolume::getCurrentLevel()
{
#ifdef __linux__

int level = 0;
char str[512],*ptr;
FILE *gconfv;

gconfv = popen("gconftool  -g /apps/osso/sound/master_volume", "r");
	//return level = 100;
fgets(str,512,gconfv);
ptr=strchr(str,'\n');
if(ptr!=NULL)
	*ptr='\0';
printf("currentvol:%s\n",str);
pclose(gconfv);
level = atoi(str);
return level;
		//return level >> 8;
#endif
		//return internalVolume_;
}

