#ifdef QTOPIA
#include <qpe/qcopenvelope_qws.h>
#endif

#include "platformservices.h"
#include "configuration.h"
#include "system_volume.h"

PlatformServices & PlatformServices::singleton()
{
	static PlatformServices instance;
	return instance;
}

PlatformServices::PlatformServices()
{
	// TODO Auto-generated constructor stub

}

PlatformServices::~PlatformServices()
{
	// TODO Auto-generated destructor stub
}

void PlatformServices::turnOnDisplay()
{
#ifdef QTOPIA
	QCopEnvelope screenMode("QPE/System", "setBlankLCD(int)");
	screenMode << 0;
#endif
}

void PlatformServices::turnOffDisplay()
{
#ifdef QTOPIA
	QCopEnvelope screenMode("QPE/System", "setBlankLCD(int)");
	screenMode << 1;
#endif
}

void PlatformServices::setVolumeRelative(int v)
{
	int setLevel = (qSystemVolume.getCurrentLevel() + v);

	if (setLevel < 0)
		setLevel = 0;
	if (100 <= setLevel)
		setLevel = 100;

	qSystemVolume.setLevel(setLevel);
}

void PlatformServices::setVolumeAbsolute(int v)
{
	int setLevel = v;

	if (setLevel < 0)
		setLevel = 0;
	if (100 <= setLevel)
		setLevel = 100;

	qSystemVolume.setLevel(setLevel);
}

void PlatformServices::disableSuspend()
{
#ifdef QTOPIA
	// 自動減光と自動サスペンドを無効にする
	/* +--+- 減光 -+- サスペンド -+
	 * |0 |        |              |
	 * |1 |        |       o      |
	 * |2 |   o    |              |
	 * |3 |   o    |       o      |
	 */
	QCopEnvelope e1("QPE/System", "setScreenSaverMode(int)");
	e1 << 0;
	// スクリーンセーバを無効にする
	QCopEnvelope e2("QPE/System", "setScreenSaverIntervals(int,int,int)");
	e2 << 0 << 0 << 0;

	QCopEnvelope e3("QPE/System", "setEnableSuspendCoverClose(bool)");
	e3 << FALSE;
#endif
}

void PlatformServices::enableSuspend()
{
#ifdef QTOPIA
	// スクリーンセーバを有効にする
	QCopEnvelope e1("QPE/System", "setScreenSaverIntervals(int,int,int)");
	e1 << -1 << -1 << -1;
	// 自動減光とオートパワーオフを有効にする
	QCopEnvelope e2("QPE/System", "setScreenSaverMode(int)");
	e2 << 3;

	QCopEnvelope e3("QPE/System", "setEnableSuspendCoverClose(bool)");
	e3 << TRUE;
#endif
}

void PlatformServices::setRemoteCon(bool shuttingDown)
{
#ifdef QTOPIA
	Config cfg("qpe");
	cfg.setGroup("Remocon");

	//QCopEnvelope e("QPE/System", "registRemoconMaster(QString,int)");

	if (qConfig.registerAsRemoteConMaster)
	{
		//e << QString(BINNAME) << (shuttingDown ? 0 : 1);
		cfg.writeEntry("master", QString(BINNAME));
	}
	else if (cfg.readEntry("master") == QString(BINNAME))
	{
		//e << QString("musicplayer") << (shuttingDown ? 0 : 1);
		cfg.writeEntry("master", "musicplayer");
	}
#endif
}
