/*
 * addonmanager.cpp
 *
 *  Created on: 26.02.2009
 *      Author: darkstar
 */

#include "addonmanager.h"

/* AddOn */

AddOn::AddOn()
	:	QObject()
{
	qAddOnManager.registerAddOn(this);
}

AddOn::~AddOn()
{
	qAddOnManager.unregisterAddOn(this);
}

/* AddOnManager */

AddOnManager &AddOnManager::singleton()
{
	static AddOnManager instance;
	return instance;
}

AddOnManager::AddOnManager()
{
	addOns_ = new QList<AddOn>();
}

AddOnManager::~AddOnManager()
{
	for (AddOn *addOn = addOns_->first(); addOn != 0; addOn = addOns_->next())
	{
		unregisterAddOn(addOn);
	}

	delete addOns_;
}

void AddOnManager::registerAddOn(AddOn *addOn)
{
	addOns_->append(addOn);
	addOn->addOnManager_ = this;
	qDebug("registerAddOn %p", addOn);
}

bool AddOnManager::unregisterAddOn(AddOn *addOn)
{
	qDebug("unregisterAddOn %p", addOn);

	addOn->addOnManager_ = 0;
	return addOns_->removeRef(addOn);
}

void AddOnManager::hookMainWindow(Quasar *mainWindow)
{
	for (AddOn *addOn = addOns_->first(); addOn != 0; addOn = addOns_->next())
		addOn->hookMainWindow(mainWindow);
}

void AddOnManager::hookPlayListView(PlayListView *playList)
{
	for (AddOn *addOn = addOns_->first(); addOn != 0; addOn = addOns_->next())
		addOn->hookPlayListView(playList);
}

void AddOnManager::hookConfigurationDialog(ConfigurationDialog *cd)
{
	for (AddOn *addOn = addOns_->first(); addOn != 0; addOn = addOns_->next())
		addOn->hookConfigurationDialog(cd);
}

void AddOnManager::writeToConfig(Config &cf)
{
	for (AddOn *addOn = addOns_->first(); addOn != 0; addOn = addOns_->next())
		addOn->writeToConfig(cf);
}

void AddOnManager::readFromConfig(Config &cf)
{
	for (AddOn *addOn = addOns_->first(); addOn != 0; addOn = addOns_->next())
		addOn->readFromConfig(cf);
}

void AddOnManager::init()
{
	for (AddOn *addOn = addOns_->first(); addOn != 0; addOn = addOns_->next())
		addOn->init();
}

void AddOnManager::deinit()
{
	for (AddOn *addOn = addOns_->first(); addOn != 0; addOn = addOns_->next())
		addOn->deinit();
}
