#ifndef REVELMEDIAFILEADDON_H_
#define REVELMEDIAFILEADDON_H_

#include <qmenubar.h>
#include <qmessagebox.h>

#include "quasar.h"
#include "media.h"
#include "addonmanager.h"
#include "imagefx.h"
#include "coverartflow.h"

class RevealMediaFileAddOn : public AddOn
{
	Q_OBJECT
public:
	static RevealMediaFileAddOn& singleton();
#	define qRevealMediaFileAddOn RevealMediaFileAddOn::singleton()

	RevealMediaFileAddOn()
		:	AddOn()
	{
		qDebug("Registering RevealMediaFileAddOn");
	}

	virtual ~RevealMediaFileAddOn()
	{
	}

	virtual void hookMainWindow(Quasar *mainWindow)
	{
		mainWindow_ = mainWindow;
#ifdef OSX
		mainWindow_->editMenu_->insertItem(tr("Reveal in Finder..."), this, SLOT(revealFile()));
#endif

#ifdef WINDOWS
		mainWindow_->editMenu_->insertItem(tr("Reveal in Explorer..."), this, SLOT(revealFile()));
#endif
	}

private slots:
	void revealFile();

private:
	Quasar *mainWindow_;
};

#endif /* REVELMEDIAFILEADDON_H_ */
