#include "revealmediafileaddon.h"

#ifdef OSX

#include <Carbon/Carbon.h>

OSErr GetPSNFromSignature(OSType signature, ProcessSerialNumber *psn)
{
       ProcessSerialNumber     currPSN;
       ProcessInfoRec          currPIR;
       OSErr                   err;

       currPSN.lowLongOfPSN = kNoProcess;
       currPSN.highLongOfPSN = 0;

       do {
             err = GetNextProcess(&currPSN);
             if (err == noErr)
             {
                   currPIR.processName = NULL;
                   currPIR.processAppSpec = NULL;
                   currPIR.processInfoLength = sizeof(ProcessInfoRec);
                   err = GetProcessInformation(&currPSN, &currPIR);
                   if (err == noErr && currPIR.processSignature == signature)
                   {
                         if (psn) *psn = currPSN;
                         break;
                   }
             }
       } while (err == noErr);

       return err;
}


bool revealItemInFinder(const char* posixUTF8Path)
{
	OSErr	err;
	AEAddressDesc targetAddrDesc = { typeNull, nil };
	AppleEvent theAppleEvent = { typeNull, nil };
	AppleEvent replyAppleEvent = { typeNull, nil };
	AliasHandle alias = nil;
	OSType finderSig = 'MACS';

	FSRef itemRef;
	err = FSPathMakeRef((const UInt8 *)posixUTF8Path, &itemRef, NULL);
	require_noerr(err, Bail);

	err = FSNewAlias(nil, &itemRef, &alias);
	require_noerr(err, Bail);

	HLock((Handle) alias); // HLock is unneeded on Mac OS X

	// address target by signature
	err = AECreateDesc(typeApplSignature, &finderSig, sizeof(OSType), &targetAddrDesc);
	require_noerr(err, Bail);

	// make the event
	err = AECreateAppleEvent(kAEMiscStandards, kAEMakeObjectsVisible, &targetAddrDesc, kAutoGenerateReturnID, kAnyTransactionID, &theAppleEvent);
	require_noerr(err, Bail);

	err = AEPutParamPtr(&theAppleEvent, keyDirectObject, typeAlias, *alias, GetHandleSize((Handle) alias));
	require_noerr(err, Bail);

	// send it
	err = AESend(&theAppleEvent, &replyAppleEvent, kAENoReply,
                kAENormalPriority, kAEDefaultTimeout, NULL, NULL);

	// bring the finder forward
	ProcessSerialNumber finderPSN;
	GetPSNFromSignature(finderSig, &finderPSN); // this calls GetNextProcess until GetProcessInformation finds the serial number of the app with the given signature
	SetFrontProcess(&finderPSN);

Bail:
	if (alias)  DisposeHandle((Handle) alias);
	if (targetAddrDesc.dataHandle) AEDisposeDesc(&targetAddrDesc);
	if (theAppleEvent.dataHandle)  AEDisposeDesc(&theAppleEvent);

	return err == noErr;
}

#endif

#ifdef WINDOWS
#include <windows.h>
#include <shellapi.h>

bool revealItemInExplorer(const QString &filename, bool showExplorerWithFoldersBar)
{
	if (QFile::exists(filename))
	{
		QString params = QString("/select,\"%1\"")
			.arg(QDir::convertSeparators(filename));

		if (showExplorerWithFoldersBar)
			params = "/e," + params;

		ShellExecuteW(0, L"open", L"explorer.exe", (const WCHAR *)params.ucs2(), NULL, SW_SHOWNORMAL);

		return true;
	}
	else
		return false;
}
#endif

void RevealMediaFileAddOn::revealFile()
{
	QList<Media> selectedList = mainWindow_->playListView_->getSelectedMedia();

	if (!selectedList.isEmpty())
	{
		Media *current = selectedList.at(0);

#ifdef OSX
		revealItemInFinder(current->location().toString().utf8());
#endif

#ifdef WINDOWS
		revealItemInExplorer(current->location().toString(), true);
#endif
	}
}

static RevealMediaFileAddOn instance;

RevealMediaFileAddOn &RevealMediaFileAddOn::singleton()
{
	return instance;
}
