#include <qpushbutton.h>
#include <qframe.h>
#include <qscrollview.h>
#include <qgrid.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qvgroupbox.h>
#include <qlayout.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qtabdialog.h>
#include <qspinbox.h>
#include <qlineedit.h>

#include "qscrobblerconfig.h"
#include "qscrobbleraddon.h"

/* QScrobblerConfiguration */

QScrobblerConfiguration::QScrobblerConfiguration()
{
    username_ = "";
    md5Password_ = "";
    cacheSaveInterval_ = 20;
    submissionPaused_ = false;
}

void QScrobblerConfiguration::write(Config &cf) const
{
	cf.setGroup("QScrobbler");
	cf.writeEntry("username", username_);
	cf.writeEntry("password", md5Password_);
	cf.writeEntry("cacheSaveInterval", cacheSaveInterval_);
	cf.writeEntry("submissionPaused", submissionPaused_);
}

void QScrobblerConfiguration::read(Config &cf)
{
	cf.setGroup("QScrobbler");
	username_ = cf.readEntry("username", "");
	md5Password_ = cf.readEntry("password", "");
	cacheSaveInterval_ = cf.readNumEntry("cacheSaveInterval", 20);
	submissionPaused_ = cf.readBoolEntry("submissionPaused", false);
}

/* QScrobblerConfig */

QScrobblerConfig::QScrobblerConfig(Configuration& configuration, QWidget *parent, const char *name)
	: ConfigView(configuration, parent, name)
{
}

void QScrobblerConfig::createWidgets()
{
	ConfigView::createWidgets();

	setFrameStyle(NoFrame);
	setMargin(4);
	setResizePolicy(AutoOneFit);

	QVBox *main = new QVBox(viewport());
	main->setSpacing(4);
	addChild(main);

	// Account data information
	QGroupBox *accountDataBox = new QGroupBox(1, Qt::Vertical, tr("Account"), main);

	QGrid *grid = new QGrid(2, QGrid::Horizontal, accountDataBox);
	grid->setSpacing(5);
	grid->setMargin(5);

	QLabel *lbUsername = new QLabel(tr("Username:"), grid);
	leUsername = new QLineEdit(grid);

	QLabel *lbPassword = new QLabel(tr("Password:"), grid);
	lePassword = new QLineEdit(grid);
	lePassword->setEchoMode(QLineEdit::Password);
}

void QScrobblerConfig::setStatesByConfiguration(const Configuration& config)
{
	ConfigView::setStatesByConfiguration(config);

	leUsername->setText(qScrobblerAddOn.config().username());
	lePassword->setText(qScrobblerAddOn.config().md5Password());
}

void QScrobblerConfig::saveStatesToConfiguration()
{
	ConfigView::saveStatesToConfiguration();

	qScrobblerAddOn.config().setUsername(leUsername->text());

	if (lePassword->text() != qScrobblerAddOn.config().md5Password())
		qScrobblerAddOn.config().setPassword(lePassword->text());
}
