#include "configuration.h"
#include "debugaddon.h"
#include "helpers.h"

#ifdef OSX
#include <qtextedit.h>

static QTextEdit* debugConsole = NULL;

static void messageOutputHandler(QtMsgType type, const char *msg)
{
	if (!debugConsole)
	{
		debugConsole = new QTextEdit(0, "Debug Console");
		QFont font = debugConsole->font();
		font.setFamily("Courier");
		debugConsole->setFont(font);
		debugConsole->setReadOnly(true);
	}

	switch (type)
	{
		case QtDebugMsg:
			debugConsole->append(QString("Debug: %1").arg(msg));
			break;
		case QtWarningMsg:
			debugConsole->append(QString("Warning: %1").arg(msg));
			break;
		case QtFatalMsg:
			debugConsole->append(QString("Fatal: %1").arg(msg));
			break;
	}
}
#endif

//#ifdef DEBUG
static DebugAddOn instance;
//#endif

void DebugAddOn::init()
{
#ifdef OSX
	qInstallMsgHandler(messageOutputHandler);
#endif
}

void DebugAddOn::deinit()
{
#ifdef OSX
	saveWidgetPosition(debugConsole, qGlobalConfig.configFilename(), "debugConsole");
	qInstallMsgHandler(0);
#endif
}

void DebugAddOn::showDebugConsole()
{
#ifdef OSX
	debugConsole->show();
	loadWidgetPosition(debugConsole, qGlobalConfig.configFilename(), "debugConsole");
#endif
}
