<?php
include("CoverArtProviders.php");

$debugMode = $_GET['debug'] == 1;

$limit = 0;
if (isset($_GET['limit']) && is_numeric($_GET['limit']))
	$limit = (int)$_GET['limit'];
	
$searchStringArtist = stripslashes($_GET['artist']);
$searchStringAlbum = stripslashes($_GET['album']);

if (empty($searchStringArtist) || empty($searchStringArtist))
	exit;

$mode = "results";
if (isset($_GET['mode']))
	$mode = $_GET['mode'];
	
$coverArtProviders = array(
	new CoverArtProviderAmazon("com"),
	new CoverArtProviderAmazon("de"),
	new CoverArtProviderWalmart(),
	new CoverArtProviderGoogleImages("com")
);

if (!isset($_GET['nocache']) && $_GET['nocache'] != 1)
	$coverArtProviders = array(new CoverArtProviderCache($coverArtProviders, 1));
	
switch ($mode)
{
case "fetchimage":
	foreach ($coverArtProviders as $provider)
	{
		$result = $provider->getAlbumArtImage($searchStringArtist, $searchStringAlbum);
		if (isset($result) && $result['success'])
			break;
	}

	if ($result['success'])
	{
		header('Content-Type: ' . $result['mimetype']);
		echo $result['imagedata'];
	}
	else
	{
		echo "No album art found.";
	}
	break;
	
case "imageurls":
	header('Content-Type: text/plain');

	$results = getCoverArtResults($searchStringArtist, $searchStringAlbum, $limit, $coverArtProviders);
		
	foreach ($results as $result)
		echo $result->imageURL . "\n";

	break;
		
case "results":
	header('Content-Type: text/plain');
	
	$results = getCoverArtResults($searchStringArtist, $searchStringAlbum, $limit, $coverArtProviders);
	
	foreach ($results as $result)
		echo $result->title . ":|:" . $result->detailsURL . ":|:" . $result->thumbnailImageURL . ":|:" . $result->imageURL . "\n";
	
	break;
	
case "debug":
	header('Content-Type: text/plain');

	print_r($_GET);

	foreach ($coverArtProviders as $provider)
	{
		$result = $provider->getCoverArtList($searchStringArtist, $searchStringAlbum);
		print_r($result);
	}
	
	break;
}
	
?>