/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef VIDEOPLAYBACKWINDOW_H_INCLUDED
#define VIDEOPLAYBACKWINDOW_H_INCLUDED

#include <qwidget.h>
#include <qtimer.h>

// #include "seekbar.h"
#include "media.h"

class QPoint;
class QKeyEvent;

class VideoPlaybackWindow: public QWidget
{
	Q_OBJECT

public:
	VideoPlaybackWindow(QWidget *parent = 0, const char *name = 0);

protected:
	void focusInEvent(QFocusEvent *);
	void focusOutEvent(QFocusEvent *);
	void mousePressEvent(QMouseEvent*);
	void mouseReleaseEvent(QMouseEvent*);
	void mouseMoveEvent(QMouseEvent*);

signals:
	void seekAbsolutePercentage(int);
	void seekSliderMoved(int);
	void seekStart();
	void seekEnd();

private:
	QPoint lastMousePosition_;
	int step_;
	QTimer timer_;
};

#endif // VIDEOPLAYBACKWINDOW_H_INCLUDED
