#ifndef TOOLPANEL_H_INCLUDED
#define TOOLPANEL_H_INCLUDED

#include <qwidget.h>
#include <qbutton.h>
#include <qlabel.h>
#include <qframe.h>
#include <qstring.h>
#include <qtimer.h>
#include "skinpanel.h"
#include "playlist.h"

// Forward declarations
class Skin;
class SkinParts;
class SkinnedButton;
class SkinnedLabel;
class SkinManager;
class SeekBar;

class ToolPanel : public SkinPanel
{
	Q_OBJECT

public:
	enum ViewType {
		PlayList,
		PlayInfo,
		MAX
	};

	ToolPanel(const SkinManager *, QWidget *parent = 0, const char *name = 0);
	virtual ~ToolPanel();

	void setInfoText(const QString &text);
	void setPlayOrder(PlayList::PlayOrder playOrder);
	void setOverviewVisibility(bool visible);
	void setCoverArtFlowVisibility(bool visible);
	void setView(ViewType view);

public slots:
	void setStatusText(const QString &text, int milliseconds = 3000);	
	
signals:
	void playOrderChanged(int playOrderID);
	void overviewVisibilityChanged(bool visible);
	void coverArtFlowVisibilityChanged(bool visible);
	void viewPlayListActivated();
	void viewPlayInfoActivated();
	
private slots:
	void timerTimedOut();

	void randomOffClicked();
	void randomOnClicked();

	void repeatOffClicked();
	void repeatOneClicked();
	void repeatAllClicked();

	void overviewOffClicked();
	void overviewOnClicked();
	
	void coverArtFlowOffClicked();
	void coverArtFlowOnClicked();

	void viewPlayListClicked();
	void viewPlayInfoClicked();
	
private:
	QTimer *timer_;
	QString infoText_;
	
	SkinnedLabel *infoLabel_;
	
	SkinnedButton *randomOffButton_;
	SkinnedButton *randomOnButton_;
	
	SkinnedButton *repeatOffButton_;
	SkinnedButton *repeatOneButton_;
	SkinnedButton *repeatAllButton_;

	SkinnedButton *overviewOffButton_;
	SkinnedButton *overviewOnButton_;

	SkinnedButton *coverArtFlowOffButton_;
	SkinnedButton *coverArtFlowOnButton_;
	
	SkinnedButton *viewPlayList_;
	SkinnedButton *viewPlayInfo_;
	
	void buttonStateChanged();
};

#endif // TOOLPANEL_H_INCLUDED
