/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef SKINNEDBUTTON_H_INCLUDED
#define SKINNEDBUTTON_H_INCLUDED

#include <qbutton.h>
#include "skin.h"
#include "skinmanager.h"

// Forward declarations
class QPainter;

class SkinnedButton : public QButton
{
	Q_OBJECT

public:
	SkinnedButton(Skin::PartsType type, const SkinManager *skinmgr, QWidget *parent = 0, const char *name = 0);
	void setToggleButton(bool value);
	void setOn(bool enable);  

public slots:
	void setSkin(const Skin *skin);
	void show();

protected:
	void drawButton(QPainter *p);

private slots:
	void skinPanelResized();
	
private:
	Skin::PartsType type_;		//!< スキンパーツの種類
	const SkinParts *parts_;	//!< 現在のスキンパーツへのポインタ
};

#endif // SKINNEDBUTTON_H_INCLUDED
