/* Based on python-edje kinetic scroll code by Kenneth Christiansen. */
/* Converted to Qt4 by berkus. */
/* This code is in public domain. */

#include <stdlib.h>
#include <qglobal.h>
#include <qtimer.h>
#include <qdatetime.h>
#include <qevent.h>
#include <qscrollbar.h>

#include "kineticlistview.h"

#define DPRINTF

KineticListView :: KineticListView(QWidget *parent)
    : QListView(parent)
{
	enabled_ = true;
	mouseDown_ = false;
	lastYPos_ = 0;
	lastDiff_ = -1;
	startPos_ = 0;
	mouseMoved_ = false;
	continueScrolling_ = false;
	isScrolling_ = false;
	pixelPerSec_ = 0;
	pixelsLeft_ = 0;
	sign_ = 0;
}

KineticListView :: ~KineticListView()
{
}

void KineticListView::setKineticScrollingEnabled(bool value)
{
	enabled_ = value;
}

void KineticListView :: viewportMouseMoveEvent ( QMouseEvent * event )
{
	if (enabled_ && selectionMode() == QListView::Single)
	{
		DPRINTF("mouseMoveEvent");

		if (mouseDown_)
		{
			int y_pos = event->y();
			int diff = lastYPos_ - y_pos;

			if (diff == 0)
				return;

			mouseMoved_ = true;

			if((lastDiff_ != -1) && ((diff < 0) != (lastDiff_ < 0)))
			{
				lastYPos_ = y_pos;
				startPos_ = y_pos;
				startTime_ = QTime::currentTime();
			}

			lastDiff_ = diff;
			//verticalScrollBar()->setValue(verticalScrollBar()->value() + diff); // move view here!
			scrollBy(0, +diff);
			lastYPos_ = y_pos;
			lastUpdateTime_ = QTime::currentTime();
		}
	}

	QListView::viewportMouseMoveEvent(event);
}

void KineticListView :: viewportMousePressEvent ( QMouseEvent * event )
{
	if (enabled_ && selectionMode() == QListView::Single)
	{
		DPRINTF("mousePressEvent");

		if (!isScrolling_)
			mouseMoved_ = false;

		continueScrolling_ = false;
		mouseDown_ = true;
		int y_pos = event->y();
		lastDiff_ = -1;
		lastYPos_ = y_pos;
		startPos_ = y_pos;
		startTime_ = QTime::currentTime();
		lastUpdateTime_ = QTime::currentTime();
	}

	QListView::viewportMousePressEvent(event);
}

void KineticListView :: viewportMouseReleaseEvent ( QMouseEvent * event )
{
	if (enabled_ && selectionMode() == QListView::Single)
	{
		DPRINTF("mouseReleaseEvent");

		if (mouseDown_)
		{
			mouseDown_ = false;
			int end_pos = event->y();
			if (!mouseMoved_ && !isScrolling_)
			{
				// Clicked
				QListView::viewportMouseReleaseEvent(event);
				DPRINTF("mouseReleaseEvent::clicked");
				return;
			}
			mouseMoved_ = false;
			isScrolling_ = false;

			// do not scroll if the finger was paused
			if (lastUpdateTime_.msecsTo(QTime::currentTime()) > 80)
			{
				DPRINTF("mouseReleaseEvent::fingerPause");
				QListView::viewportMouseReleaseEvent(event);
				return;
			}

			QTime end_time = QTime::currentTime();
			int pos_diff = end_pos - startPos_;
			int time_diff = startTime_.msecsTo(end_time);

			if (time_diff == 0)
				time_diff = 1;

			pixelPerSec_ = pos_diff * 1000 / time_diff;
			DPRINTF("mouseReleaseEvent::pos_diff %d  time diff %d", pos_diff, time_diff);
			DPRINTF("mouseReleaseEvent::pixel/sec %d", pixelPerSec_);
			continueScrolling_ = true;
			doScroll();
		}
	}
	else
		QListView::viewportMouseReleaseEvent(event);
}

void KineticListView :: doScroll()
{
	isScrolling_ = true;
	if (!continueScrolling_)
	{
		DPRINTF("doScroll: stopping scrolling");
		return;
	}

	int diff = pixelPerSec_ / 10;
	int row_height = 16;
	if (firstChild())
		row_height = firstChild()->height();

	// magnetic scroll
	if (abs(pixelPerSec_) - diff < row_height)
	{
		int offset = verticalScrollBar()->value() % row_height;

		if (offset >= row_height / 2)
		{
			sign_ = 1;
			offset = row_height - offset;
		} else
			sign_ = -1;

		pixelsLeft_ = offset;
		doMagneticScroll();
		return;
	}

	if (diff)
	{
		DPRINTF("doScroll at %d pix/s", pixelPerSec_);
		//verticalScrollBar()->setValue(verticalScrollBar()->value() - diff); // move view here!
		scrollBy(0, -diff);
		pixelPerSec_ -= diff;
	}

	QTimer::singleShot(20, this, SLOT(doScroll()));
}

// TODO: Not working in Qt4 as it did in e17. Need to change logic.
void KineticListView :: doMagneticScroll()
{
	if ((pixelsLeft_ <= 0) || (abs(pixelPerSec_) < 1))
	{
		mouseMoved_ = false;
		isScrolling_ = false;
		return;
	}

	pixelPerSec_ -= pixelPerSec_ / 10;
	int pixels_to_subtract = abs(pixelPerSec_ / 10);
	if (pixels_to_subtract < 1)
		pixels_to_subtract = 1;

	if (pixelsLeft_ - pixels_to_subtract > 0)
	{
		pixelsLeft_ -= pixels_to_subtract;
		//verticalScrollBar()->setValue(verticalScrollBar()->value() + sign_ * pixels_to_subtract); // move view here!
		scrollBy(0, -sign_ * pixels_to_subtract);
	}
	else
	{
		//verticalScrollBar()->setValue(verticalScrollBar()->value() + sign_ * pixelsLeft_); // move view here!
		scrollBy(0, -sign_ * pixelsLeft_);
		pixelsLeft_ = 0;
	}

	QTimer::singleShot(100, this, SLOT(doMagneticScroll()));
}
