#ifndef COVERARTFLOW_H_
#define COVERARTFLOW_H_

#include <qintdict.h>
#include <qtimer.h>

#include "reflectionimageflow.h"
#include "playlist.h"
#include "scrollbar.h"
#include "skin.h"
#include "media.h"
#include "skinmanager.h"

const int SlideWidthHeight = 300;
const int ReflectionHeight = (int)((float)SlideWidthHeight * 0.8);

class CachedImage;

class CoverArtItem
{
public:
	int playlistID;
	QString key;
	QString filename;
	QString artist;
	QString album;
};

typedef QList<CoverArtItem> CoverArtItemList;

class CoverArtImageProvider : public ReflectionImageProvider
{
	Q_OBJECT
public:
	CoverArtImageProvider(QObject *owner, const char *name = 0);

	static QString createKey(const QString &artist, const QString &album)
	{
		return artist.lower() + " - " + album.lower();
	}

	static CoverArtItem createCoverArtItemFromMedia(const Media &info);

protected:
	virtual QImage* threadedCreateImage(CachedImage *cachedImage);
	virtual void initializeCachedImage(CachedImage *cachedImage);
	virtual void finalizeCachedImage(CachedImage *cachedImage);
};

class CoverArtFlow : public ReflectionImageFlow, public PlayListViewExtension
{
	Q_OBJECT
public:
	CoverArtFlow(ReflectionImageProvider *imageProvider, LayeredPaintBox *parent);
	virtual ~CoverArtFlow();

	void execute();
	void reset();
	QString outputViewSource();

	void setActive(bool value);
	bool active() { return active_; }

protected:
	virtual void setPlayListView(PlayList *playList);
	virtual void extensionGraphExecutionFinished();

	virtual QImage getImage(int index);

	virtual void transitionFinished();
	virtual void paintOverlay(QPainter &p, const QPixmap &pixmap);

	virtual void mouseDoubleClickEvent(QMouseEvent *e);

private slots:
	void playListCurrentChanged(QListViewItem *);
	void imageWasCached(CachedImage *image);
	void preloadImages();
	void focusCurrentAlbum();

private:
	CoverArtItemList coverArtItems_;
	QIntDict<int> playlistIDLookupDict_;
	QTimer preloadImagesTimer_;
	QTimer focusAlbumTimer_;
	bool active_;
};

class ScrollBarSkinSupport : public QObject
{
	Q_OBJECT
public:
	ScrollBarSkinSupport(Skin::PartsType scrollBarType, Skin::PartsType scrollBarSliderType, const SkinManager *skinmgr, PositionedLayer *owner);
	int buttonSize();
	int minSliderWidth();
	void paintOverlay(QPainter &p, const QRect &geometry, const QRect &slider);

protected slots:
	void setSkin(const Skin *skin);

protected:
	Skin::PartsType scrollBarType_;
	Skin::PartsType scrollBarSliderType_;
	const SkinParts *scrollBarParts_;
	const SkinParts *scrollBarSliderParts_;
	const Skin *skin_;
	PositionedLayer *owner_;
	void paintThreeSectionedParts(QPainter &p, const QRect &dstRect, const SkinParts *parts);
};

class SkinScrollBar : public ScrollBar
{
	Q_OBJECT
public:
	SkinScrollBar(Skin::PartsType scrollBarType, Skin::PartsType scrollBarSliderType, const SkinManager *skinmgr, LayeredPaintBox *parent);

protected:
	virtual void paintOverlay(QPainter &p, const QPixmap &pixmap);
	virtual int buttonSize() { return skinSupport_.buttonSize(); }
	virtual int minSliderWidth() { return skinSupport_.minSliderWidth(); }

private slots:
	void setSkin(const Skin *skin) { invalidate(); }

private:
	ScrollBarSkinSupport skinSupport_;
};

class SkinFlowScrollBar : public FlowScrollBar
{
	Q_OBJECT
public:
	SkinFlowScrollBar(Skin::PartsType scrollBarType, Skin::PartsType scrollBarSliderType, const SkinManager *skinmgr, CustomFlow *flow, LayeredPaintBox *parent);

protected:
	virtual void paintOverlay(QPainter &p, const QPixmap &pixmap);
	virtual int buttonSize() { return skinSupport_.buttonSize(); }
	virtual int minSliderWidth() { return skinSupport_.minSliderWidth(); }

private slots:
	void setSkin(const Skin *skin) { invalidate(); }

private:
	ScrollBarSkinSupport skinSupport_;
};

#endif /*COVERARTFLOW_H_*/
