/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <qapplication.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qspinbox.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlistview.h>
#include <qtabbar.h>

#include "configurationdialog.h"
#include "configuration.h"
#include "configview.h"
#include "helpers.h"
#include "addonmanager.h"
#include "config/generalconfig.h"
#include "config/mplayerconfig.h"
#include "config/formatsconfig.h"
#include "config/hotkeyconfig.h"
#include "config/hotareaconfig.h"
#include "config/uiconfig.h"
#include "config/coverartconfig.h"

ConfigurationDialog::ConfigurationDialog(const Configuration &config, QWidget *parent, const char *name)
	:	QTabDialog(parent, name, true),
		configViews(),
		workingConfiguration_(config)
{
	createWidgets();
}

void ConfigurationDialog::createWidgets()
{
	setCaption(tr("Configuration"));
#ifdef QTOPIA
	setWState(WState_Reserved1);
#endif

	generalConfig = new GeneralConfig(workingConfiguration_, this);
	connect(generalConfig, SIGNAL(defaultButtonClicked()), this, SLOT(setDefaultSetting()));
	connect(generalConfig, SIGNAL(nukeMediaCacheButtonClicked()), this, SIGNAL(nukeMediaCacheButtonClicked()));
	initializeAndAddConfigViewTab(generalConfig, generalConfig, tr("General"));

	mplayerConfig = new MPlayerConfig(workingConfiguration_, this);
	initializeAndAddConfigViewTab(mplayerConfig, mplayerConfig, tr("MPlayer"));

	formatsConfig = new FormatsConfig(workingConfiguration_, this);
	initializeAndAddConfigViewTab(formatsConfig, formatsConfig, tr("Formats"));

	hotKeyConfig = new HotKeyConfig(workingConfiguration_, this);
	initializeAndAddConfigViewTab(hotKeyConfig, hotKeyConfig, tr("HotKey"));

	hotAreaConfig = new HotAreaConfig(workingConfiguration_, this);
	initializeAndAddConfigViewTab(hotAreaConfig, hotAreaConfig, tr("HotAreas"));

	uiConfig = new UIConfig(workingConfiguration_, this);
	initializeAndAddConfigViewTab(uiConfig, uiConfig, tr("User Interface"));

	coverArtConfig = new CoverArtConfig(workingConfiguration_, this);
	initializeAndAddConfigViewTab(coverArtConfig, coverArtConfig, tr("Cover Art"));

	qAddOnManager.hookConfigurationDialog(this);

	setStatesByConfiguration(workingConfiguration_);

	// Hide buttons
#ifdef QTOPIA
	setOkButton(QString::null);
#endif
}

void ConfigurationDialog::initializeAndAddConfigViewTab(BaseConfigView *cv, QWidget *view, const QString &tabCaption)
{
	cv->createWidgets();
	addTab(view, tabCaption);
	configViews.append(cv);
}

void ConfigurationDialog::showEvent(QShowEvent *)
{
#ifdef QTOPIA
	showMaximized();
#endif;
}

void ConfigurationDialog::setDefaultSetting()
{
	workingConfiguration_ = Configuration();
	setStatesByConfiguration(workingConfiguration_);
}

void ConfigurationDialog::setStatesByConfiguration(const Configuration& config)
{
	for (BaseConfigView *cv = configViews.first(); cv != 0; cv = configViews.next())
		cv->setStatesByConfiguration(config);

	emit settingStatesByConfiguration(config);
}

void ConfigurationDialog::saveStatesToConfiguration()
{
	for (BaseConfigView *cv = configViews.first(); cv != 0; cv = configViews.next())
		cv->saveStatesToConfiguration();

	emit savingStatesToConfiguration();
}

void ConfigurationDialog::showMPlayerConfig()
{
	showPage(mplayerConfig);
	mplayerConfig->setFocus();
	mplayerConfig->focusMPlayerPathWidget();
}

int ConfigurationDialog::exec()
{
	loadWidgetPosition(this, qGlobalConfig.configFilename(), "ConfigDialog");
	int result = QTabDialog::exec();
	saveStatesToConfiguration();
	saveWidgetPosition(this, qGlobalConfig.configFilename(), "ConfigDialog");
	return result;
}
