#ifndef COVERARTCONFIG_H_INCLUDED
#define COVERARTCONFIG_H_INCLUDED

#include "configuration.h"
#include "configview.h"

class CoverArtConfig : public ConfigView
{
	Q_OBJECT
public:
	CoverArtConfig(Configuration& configuration, QWidget *parent = 0, const char *name = 0) : ConfigView(configuration, parent, name) {}
	virtual void setStatesByConfiguration(const Configuration& config);

	QVBox *vbox() { return vbox_; }

protected:
	virtual void createWidgets();

private slots:
	void setCoverArtDirectory(const QString& dir) { config().coverArtDirectory = dir; }
	void execCoverArtDirectoryDialog();

	void setCoverArtFlowCacheDirectory(const QString& dir) { config().coverArtFlowCacheDirectory = dir; }
	void execCoverArtFlowCacheDirectory();

private:
	QVBox *vbox_;

	// Widgets
	QLineEdit *coverArtDirectory_;
	QLineEdit *coverArtFlowCacheDirectory_;
};

#endif // COVERARTONFIG_H_INCLUDED
