/*
 * Copyright (C) 2007-2008 Andre Beckedorf <evilJazz _AT_ katastrophos _DOT_ net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef FLOWMATIXTEST_H_INCLUDED
#define FLOWMATIXTEST_H_INCLUDED

#include <qdialog.h>
#include <qstring.h>
#include <qtimer.h>

#include "debug.h"

class QLabel;
class QProgressBar;
class QTimer;
class QListView;
class QCheckBox;
class QRadioButton;
class QPushButton;
class QSlider;
class QVGroupBox;
class QWidgetStack;
class ReflectionImageProvider;

class ReflectionImageFlow;
class FlowScrollBar;
class TextLayer;
class LayeredPaintBox;

class FlowMatixTest: public QWidget
{
	Q_OBJECT

public:
	FlowMatixTest();

private slots:
	void about();
	void lpbRearrangeLayers();
	void textChangeTimeout();
	
private:
	void updateWidgets();
	void fillFileList(QStringList &filelist, const QString &path, const bool subdir);

	QStringList validExtensionsList_;
	bool validExtension(const QString &extension) { return validExtensionsList_.contains(extension.lower()); }
	
	ReflectionImageProvider *imageProvider;
	ReflectionImageFlow *flow;
	FlowScrollBar *sb_;
	
	QTimer testTimer_;
	TextLayer *text_;
	
	LayeredPaintBox *lpb_;
};

#endif // FLOWMATIXTEST_H_INCLUDED
