#!/bin/bash

TARGET="Windows"
BINARY_NAME="quasar.exe"

SCRIPT_FILENAME="`cd \`dirname \"$0\"\`; pwd`/`basename \"$0\"`"
DISTRO_ROOT=$(dirname "$SCRIPT_FILENAME")

source "$DISTRO_ROOT/makedistro-common.sh.in"

function prepareMakefile()
{
	qmake quasar-mingw.pro > Makefile
}

buildBinary "$TOOLS_ROOT/devenv-x86-mingw.sh"
copySkeletonBinaryAndSkins "$DISTRO_ROOT/skeletons/windows/bin" "$INPUT_ROOT/$BINARY_NAME" "$INPUT_ROOT/skins"
cp "$DEV_ROOT/LICENSE" "$INPUT_ROOT/License.txt"
cp "$QTDIR/lib/qt-mt3.dll" "$INPUT_ROOT/"

downloadExternalFile "http://katastrophos.net/downloads/quasar/mplayer-win.exe.gz"
gzip -c -d "$EXTERNALS_ROOT/mplayer-win.exe.gz" > "$INPUT_ROOT/mplayer.exe"

removeObsoleteFiles

# Create setup binary with Inno Setup compiler
iscc "$DISTRO_ROOT/skeletons/windows/quasar.iss" || onError "Innosetup failed."

# Move setup binary to destination
movePackageToDestination "$INPUT_ROOT/QuasarMediaPlayerSetup.exe" "$OUTPUT_ROOT/QuasarMediaPlayer_${APPVERSION_FILENAME_SUFFIX}_Setup.exe" "$1"

# Create self contained version and zip it
writeSelfcontainedMarker "$INPUT_ROOT/quasar.ini"
cd "$INPUT_ROOT"
#zip -9 -r "$INPUT_ROOT/QuasarMediaPlayer.zip" * || onError "Zipping failed."
7za a -t7z -m0=lzma -mx=9 -ms=on "$INPUT_ROOT/QuasarMediaPlayer.7z" . || onError "Zipping failed."
cd -

# Move zipped selfcontained version to destination
#movePackageToDestination "$INPUT_ROOT/QuasarMediaPlayer.zip" "$OUTPUT_ROOT/QuasarMediaPlayer_${APPVERSION_FILENAME_SUFFIX}.zip" "$2"
movePackageToDestination "$INPUT_ROOT/QuasarMediaPlayer.7z" "$OUTPUT_ROOT/QuasarMediaPlayer_${APPVERSION_FILENAME_SUFFIX}.7z" "$2"
cleanUp
