#!/bin/bash

TARGET="OS X"
BINARY_NAME="quasar"

SCRIPT_FILENAME="`cd \`dirname \"$0\"\`; pwd`/`basename \"$0\"`"
DISTRO_ROOT=$(dirname "$SCRIPT_FILENAME")

source "$DISTRO_ROOT/makedistro-common.sh.in"

function prepareMakefile()
{
	qmake quasar-osx.pro > Makefile
}

buildBinary "$TOOLS_ROOT/devenv-x86-ppc-osx.sh"
buildApplicationBundle

cd "$INPUT_ROOT"
zip -9 -r "$INPUT_ROOT/QuasarMediaPlayerOSX.zip" "Quasar Media Player.app" || onError "Zipping failed."
cd -

movePackageToDestination "$INPUT_ROOT/QuasarMediaPlayerOSX.zip" "$OUTPUT_ROOT/QuasarMediaPlayerOSX_${APPVERSION_FILENAME_SUFFIX}.zip" "$1"
cleanUp
