#ifndef SYSTEM_VOLUME_H
#define SYSTEM_VOLUME_H

#include <qobject.h>

class SystemVolume : public QObject
{
	Q_OBJECT
	
public:
	static SystemVolume& singleton();
#	define qSystemVolume SystemVolume::singleton()

	SystemVolume();
	virtual ~SystemVolume();
	
	bool setLevel(int level, bool publish = true);
	int getCurrentLevel();
	
	bool useInternalVolume() { return useInternalVolume_; }
	void setUseInternalVolume(bool value) { useInternalVolume_ = value; }
	
signals:
	void levelChanged(int level);

private:
	int internalVolume_;
	bool useInternalVolume_;
};

#endif	// SYSTEM_VOLUME_H
