/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef KEYNAMES_H_INCLUDED
#define KEYNAMES_H_INCLUDED

#include <qstring.h>
#include <qmap.h>
#include <qnamespace.h>

class KeyNames
{
public:
	static const QString getName(int code){
		if(namemap.isEmpty()) setNameMap();
		QString name;
		if (code & Qt::SHIFT)
			name += "Shift+";
		if (code & Qt::CTRL)
			name += "Ctrl+";
		if (code & Qt::ALT)
			name += "Alt+";
		code &= ~Qt::MODIFIER_MASK;
		if(namemap.contains(code)){
			return(name + namemap[code]);
		} else {
			return(QString::null);
		}
	}
	static void clearName(){
		namemap.clear();
	}
	static int getCode(const QString& s){
		if(codemap.isEmpty()) setCodeMap();
		if(codemap.contains(s)){
			return(codemap[s]);
		} else {
			return(0);
		}
	}
	static void setCode(const QString& s, int code){
		if(codemap.contains(s) == false){
			codemap.insert(s, code);
		}
	}
	static void clearCode(){
		codemap.clear();
	}
	static void reset(){
		clearCode();
	}
private:
	static QMap<QString, int> codemap;
	static QMap<int, QString> namemap;

	static void setCodeMap();
	static void setNameMap();
};

#endif /* KEYNAMES_H_INCLUDED */
