/*
 * addonmanager.h
 *
 *  Created on: 26.02.2009
 *      Author: darkstar
 */

#ifndef ADDONMANAGER_H_
#define ADDONMANAGER_H_

#include <qobject.h>
#include <qlist.h>

#ifdef QTOPIA
#include <qpe/config.h>
#else
#include <config.h>
#endif

class AddOnManager;
class PlayList;
class Quasar;
class ConfigurationDialog;

class AddOn: public QObject
{
public:
	AddOn();
	virtual ~AddOn();

	virtual void hookMainWindow(Quasar *mainWindow) {}
	virtual void hookPlayListView(PlayList *playList) {}
	virtual void hookConfigurationDialog(ConfigurationDialog *cd) {}

	virtual void writeToConfig(Config &cf) {}
	virtual void readFromConfig(Config &cf) {}

	virtual void init() {}
	virtual void deinit() {}

	AddOnManager *addOnManager() { return addOnManager_; }

private:
	friend class AddOnManager;
	AddOnManager *addOnManager_;
};

class AddOnManager
{
public:
	static AddOnManager& singleton();
#	define qAddOnManager AddOnManager::singleton()

	AddOnManager();
	virtual ~AddOnManager();

	void registerAddOn(AddOn *addOn);
	bool unregisterAddOn(AddOn *addOn);

	virtual void hookMainWindow(Quasar *mainWindow);
	virtual void hookPlayListView(PlayList *playList);
	virtual void hookConfigurationDialog(ConfigurationDialog *cd);

	virtual void writeToConfig(Config &cf);
	virtual void readFromConfig(Config &cf);

	virtual void init();
	virtual void deinit();

private:
	QList<AddOn> *addOns_;
};

#endif /* ADDONMANAGER_H_ */
