/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef ACTION_H_INCLUDED
#define ACTION_H_INCLUDED

#include <qobject.h>
#include <qstring.h>
#include <qcstring.h>
#include <qlist.h>
#include <qmap.h>
#include "configuration.h"

class Action : public QObject
{
	Q_OBJECT
public:
	Action() : QObject(), name_(), id_(0) {};
	Action(const Action &a) : QObject(), name_(a.name()), id_(a.id()) {};
	Action(const QCString& name, int id);

	QCString name() const { return name_; }
	QString translatedName() const;
	int id() const { return id_; }
	int accelID() const { return 0xF000 + id_; }

	int operator<(const Action& rhs) { return name_ < rhs.name(); }
	int operator==(const Action& rhs) { return name_ == rhs.name(); }
	Action& operator=(const Action& rhs)
	{
		name_ = rhs.name();
		id_ = rhs.id();
		return *this;
	}

public slots:
	void execute() const;

signals:
	void executed();

private:
	QCString name_;
	int id_;
};


class ActionManager
{
public:
	static ActionManager& singleton();
#define gActionManager ActionManager::singleton()

	const Action& actionByName(const QCString& name) const;
	const Action& actionByID(int id) const;
	const Action& actionByAccelID(int accelID) const;

	QList<Action> allActions() const;

	Configuration::HotKeyMap defaultHotKey(Configuration::HotKeyContext context) const;

private:
	ActionManager();

	Configuration::HotKeyMap defaultHotKeyMap_[Configuration::HOTKEY_CONTEXT_MAX];

	void createDefaultHotKeyMap();

	void addHotKey(const QCString &name, int key, int context1,
			int context2 = Configuration::HOTKEY_CONTEXT_MAX,
			int context3 = Configuration::HOTKEY_CONTEXT_MAX,
			int context4 = Configuration::HOTKEY_CONTEXT_MAX);

	struct ActionDecl {
		int id;
		const char *name;
	};

	static const ActionDecl actionDecls_[];

	typedef QMap<QCString, Action> ActionMap;
	ActionMap actionMap_;

	Action nullAction_;
};

#endif // ACTION_H_INCLUDED
