#include <QtTest/QtTest>
#include "MeetingRoomCombo.h"
#include "Room.h"
#include "TestMeetingRoomCombo.h"
#include <QApplication>

void TestMeetingRoomCombo::initTestCase()
{
	iRooms.append( new Room( "Hercules", "meetingroom.hercules@ixonos.com" ) );
	iRooms.append( new Room( "Pegasus", "meetingroom.pegasus_jyv@ixonos.com" ) );
	iRooms.append( new Room( "Taurus", "meetingroom.taurus_jyv@ixonos.com" ) );

	iCombo = new MeetingRoomCombo( iRooms );
	QVERIFY( iCombo != 0 );
}

void TestMeetingRoomCombo::cleanupTestCase()
{
	delete iCombo;
	iCombo = NULL;
}

void TestMeetingRoomCombo::init()
{
}

void TestMeetingRoomCombo::cleanup()
{
}

void TestMeetingRoomCombo::testCount()
{
	QCOMPARE( iCombo->count(), iRooms.count() );
}

void TestMeetingRoomCombo::testCurrentIndex()
{
	iCombo->setCurrentIndex( 0 );
	QCOMPARE( iCombo->currentIndex(), 0 );

	iCombo->setCurrentIndex( -10 );
	QCOMPARE( iCombo->currentIndex(), -1 );

	iCombo->setCurrentIndex( 10 );
	QCOMPARE( iCombo->currentIndex(), -1 );

	iCombo->setCurrentRoom( iRooms.at( 1 ) );
	QCOMPARE( iCombo->currentIndex(), 1 );
}

void TestMeetingRoomCombo::testCurrentRoom()
{
	iCombo->setCurrentRoom( iRooms.at( 1 ) );
	QCOMPARE( iCombo->currentRoom()->equals( iRooms.at( 1 ) ), true );
	QCOMPARE( iCombo->currentRoom()->equals( iRooms.at( 0 ) ), false );
}

void TestMeetingRoomCombo::testSetCurrentIndex()
{
	for ( int i = 0; i < iRooms.count(); i++ )
	{
		iCombo->setCurrentIndex( i );
		QCOMPARE( iCombo->currentIndex(), i );
	}
}

void TestMeetingRoomCombo::testSetCurrentRoom()
{
	for ( int i = 0; i < iRooms.count(); i++ )
	{
		iCombo->setCurrentRoom( iRooms[i] );
		QCOMPARE( iCombo->currentRoom(), iRooms[i] );
	}
}

void TestMeetingRoomCombo::testSetCurrentRoomBy()
{
	iCombo->setCurrentRoomBy( iRooms.at( 0 )->name() );
	QCOMPARE( iCombo->currentIndex(), 0 );

	iCombo->setCurrentRoomBy( iRooms.at( 2 )->name() );
	QCOMPARE( iCombo->currentIndex(), 2 );

	iCombo->setCurrentRoomBy( "WRONG NAME" );
	QCOMPARE( iCombo->currentIndex(), -1 );
}

void TestMeetingRoomCombo::testFindRoom()
{
	for ( int i = 0; i < iRooms.count(); i++ )
	{
		QCOMPARE( iCombo->findRoom( iRooms[i] ), i );
	}
}

void TestMeetingRoomCombo::testFindRoomBy()
{
	QCOMPARE( iCombo->findRoomBy( iRooms.at( 0 )->name() ), 0 );
	QCOMPARE( iCombo->findRoomBy( iRooms.at( 1 )->name() ), 1 );
	QCOMPARE( iCombo->findRoomBy( "WRONG NAME" ), -1 );
}
